/* $Id: transferlist.h,v 1.6 2000/03/04 14:56:43 koss Exp $
   $Log: transferlist.h,v $
   Revision 1.6  2000/03/04 14:56:43  koss
   Fixed KFileDialog stuff : QString -> KURL, getOpenFileName ->
   getOpenURL etc.
   Now Caitoo at least compiles ( and even works on local files :-) ).
   Signals not working yet, that's why  nothing gets displayed in a listview.

   Revision 1.5  2000/02/06 09:09:11  mueller
   #include<qlist.h>

   Revision 1.4  1999/11/19 19:02:12  koss
   Reading and writing transfers is now here instead of KMainWidget.

   Revision 1.3  1999/10/29 16:58:18  koss
   Fixed adding of transfers.

   Revision 1.2  1999/10/19 17:36:48  koss
   Class Transfer moved to a separate file.

   Revision 1.1  1999/10/18 22:15:21  koss
   KMyListView renamed to TransferList.
   Added class Transfer ( renamed KItem ).
   Added class TransferIterator.

   Revision 1.1  1999/10/12 18:23:47  koss
   ported to QListView.
   now is kmytablistbox = kmylistview

   Revision 1.5  1999/02/07 20:03:44  matt
   renamed timed to scheduled

   Revision 1.4  1999/02/07 17:14:12  matt
   added some new icons

   Revision 1.3  1998/12/19 19:39:19  matt
   Added new icons

   Revision 1.1.1.1  1998/05/06 19:13:31  matt
   Imported sources


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */

#ifndef _TransferList_h
#define _TransferList_h

#include <qlistview.h>
#include <qlist.h>

#include <kurl.h>

class Transfer;

class TransferIterator : public QListViewItemIterator {

public:

  TransferIterator( QListView* view ) : QListViewItemIterator( view ) {}

  Transfer* current() const { return (Transfer*) QListViewItemIterator::current(); }
  void reset() { curr = listView->firstChild(); }

};


class TransferList : public QListView {
  Q_OBJECT

public:

  enum DownloadStatus { STATUS_EMPTY, STATUS_DELAYED, STATUS_LOADING, STATUS_SCHEDULED };

  TransferList (QWidget *parent = 0, const char *name = 0 );
  virtual ~TransferList();

  Transfer* addTransfer();

  virtual void setSelected( QListViewItem *item, bool selected );
  
  void moveToBegin( Transfer *item );
  void moveToEnd( Transfer *item );

  uint getPhasesNum() { return phasesNum; }
  bool updateStatus( int counter );
  bool find( KURL _src );
  int downloadStatus();

  void readTransfers( QString file );
  void writeTransfers( QString file );

  friend class Transfer;

  static void initStatic();

signals:
  void transferSelected( Transfer* item );
  void popupMenu( Transfer* item );

protected slots:
  void slotTransferSelected( QListViewItem *item );
  void slotPopupMenu( QListViewItem *item );

protected:

  void readConfig();
  void writeConfig();

  // ListView IDs
  int lv_pixmap, lv_filename, lv_resume, lv_count, lv_progress;
  int lv_total, lv_speed, lv_remaining, lv_url;

  static QList<QPixmap> *animConn;
  static QList<QPixmap> *animTry;
  static QPixmap *pixQueued;
  static QPixmap *pixScheduled;
  static QPixmap *pixDelayed;
  static QPixmap *pixFinished;
  static QPixmap *pixRetrying;

  uint phasesNum;
};


#endif // _TransferList_h
