
#ifndef __KFINGER_H_
#define __KFINGER_H_

#include <qkeycode.h> 
#include <qcombobox.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qtooltip.h>

#include <ktmainwindow.h>
#include <ktabctl.h>

#include "finger.h"

char *sstr1;

class QSlider;
class QLineEdit;
class QMultiLineEdit;
class QCheckBox;
class QPushButton;
class QRadioButton;
class QListBox;

class NetutilView : public KTMainWindow
{
    Q_OBJECT
public:
    NetutilView();

private slots:
    void	slotAuto(int a);
    void        stopIt(); 
    void        connRef();
     void        writeIt();
    void        save(); 
    void        loadSettings(); 
    void	button1Clicked();
    void	talk();
//    void	sliderValueChanged( int );
    void        timerEvent(QTimerEvent *);
    void        about();
    void        HtmlHelp(); 
    void        setup();
private:
    KToolBar *toolBar;
    KStatusBar *statusBar;
    QString sstr;  
    KConfig *config;
    KApplication *app;
    QMultiLineEdit *le;
    KMenuBar *menubar;
    QLabel     *msg;
    bool  autofinger;
    FingerProtocol *protocol;
    //    QPushButton *pb;
    int Timer,tencount,val;
    //KCombo *ed2Combo,*ed3Combo;
    QComboBox *ed2Combo,*ed3Combo;
//    KSlider* sb;

};


class Format : public QDialog
{
    Q_OBJECT

public:
    Format (QWidget* parent = NULL,const char* name = NULL,const char *sufi=NULL);
 
protected slots:
    void save();
    void quit();

protected:
    KConfig *config;
    KApplication *app;

    QString suf;
    QLineEdit* var1Format;
    QLineEdit* var2Format;
    QLineEdit* var1Offset;
    QLineEdit* var2Offset;
    QRadioButton* cbvar[5];
    QLineEdit* outFormat;
};



class Talk : public QDialog
{
    Q_OBJECT

public:

    Talk (QWidget* parent = 0,const char* name = 0,QString command="ktalk");
    virtual ~Talk();

public slots:
        
    void adduser(const char *username);

protected slots:
        
    virtual void newselect(int a);
    virtual void runtalk();
    virtual void quit();

private:
QListBox* usrQListBox;
QLineEdit* TalkLineEdit;
QString theCommand;
protected:

};



class Setup : public QDialog
{
    Q_OBJECT
public:
    Setup( QWidget *parent=0, const char *name=0 );
private:
    QLineEdit* tmpQLineEdit;
    QListBox* tmpQListBox; 
    QLineEdit* tmpQLineEdit1;
    QListBox* tmpQListBox1; 
    QCheckBox* tmpQCheckBox;
    KIntNumInput* tmpQSlider;
    QLabel* FingerTime;
    KConfig* config;
    QRadioButton* but[7];
    QLineEdit* SQLineEdit;
    QLineEdit* UQLineEdit;
    QLineEdit* TQLineEdit;
    QLineEdit* TCQLineEdit;

private slots:
    void        value(int);
    void        quit();
    void        save();  
    void        Add();
    void        Remove();
    void        Add1();
    void        Remove1();
    void        format();
    void        format1();
};


#endif
