/*
 *   WhoisDlg.h - Dialog for the whois command
 * 
 *   part of knu: KDE network utilities
 *
 *   Copyright (C) 1997-1999  Bertrand Leconte
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * $Id: WhoisDlg.h,v 1.4 1999/10/08 22:52:28 bero Exp $
 *
 * $Log: WhoisDlg.h,v $
 * Revision 1.4  1999/10/08 22:52:28  bero
 * KTMainWindow
 *
 * Revision 1.3  1999/10/05 17:54:19  corey
 * Add support for selection between whois and fwhois commands.
 *
 * Revision 1.2  1999/06/18 21:22:10  leconte
 * . use KTMainWindow insteed of KTMainWindow
 * . myListManager added here (it will perhaps goes to kdelibs)
 * . klistmanagertest added
 * . some cleanup
 *
 */
#ifndef __WhoisDlg_h__
#define __WhoisDlg_h__

#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>

#include "CommandDlg.h"
#include "mylistmanager.h"

class WhoisCfgDlg;

class WhoisDlg: public CommandDlg
{
  friend WhoisCfgDlg;
  Q_OBJECT

public:
  WhoisDlg(QString commandName, 
	  QWidget* parent = NULL, const char* name = NULL);
  virtual ~WhoisDlg();
  

protected:
  bool         buildCommandLine(QString);

  // widgets
  //QCheckBox   *whoisCb1;
  //QLineEdit   *whoisLe2;
  QLabel      *whoisLbl2;
  QComboBox   *whoisCb2;
  QFrame      *frame1;

  // layout
  QBoxLayout  *layout3;

  // Static member
  static QStringList Server_List;

};


class WhoisCfgDlg: public CommandCfgDlg
{
  // Q_OBJECT

public:
  WhoisCfgDlg(const char *tcs, 
	     QWidget* parent = NULL, const char* name = NULL);
  ~WhoisCfgDlg() {};

  /**
   *
   */
  virtual QWidget *makeWidget(QWidget* parent, bool makeLayouts = TRUE);
  virtual void deleteConfigWidget();

  /**
   * commit changes to the configfile
   * 
   * @return if the change have been done
   * @see cancelChanges
   */
  virtual bool commitChanges();
  
  /**
   * cancel changes to the configfile
   *
   * @see commitChanges
   */
  virtual void cancelChanges();

  /**
   * This is called just before the OptionDlg is shown
   */
  void readConfig();

protected:

  // The configWidget
  myListManager *cfgListManager;
  QButtonGroup *cfgBG;
  QRadioButton *cfgWhoisBtn, *cfgFwhoisBtn;
  QBoxLayout *cfgLayout2;
};

#endif // __WhoisDlg_h__

