/*
 * imap.h -- Declaration of class KImap4Drop.
 */
#ifndef KEG_IMAPDROP_H
#define KEG_IMAPDROP_H

#include <qstring.h>
#include "polldrop.h"

class KBiffImap;
class QWidget;
class KDropDialog;

/**
 * Polling monitor for IMAP4 maildrops.
 * @author Kurt Granroth (granroth@kde.org)
 * $version $Id: imap.h,v 1.1 1999/07/22 18:16:55 tibirna Exp $
 */
class KImap4Drop : public KPollableDrop
{
private:
	QString _server;
	int	_port;

	QString _user;
	QString _password;
	QString _mailbox;
	bool	_savePassword;

	bool _valid;

	KBiffImap *_imap;

public:
	static const char *HostConfigKey;
	static const char *PortConfigKey;
	static const char *UserConfigKey;
	static const char *MailboxConfigKey;
	static const char *PassConfigKey;
	static const char *SavePassConfigKey;
	static const int  DefaultPort;

public:
	/**
	* KImap4Drop Constructor
	*/
	KImap4Drop();

	/** 
	  * Set the IMAP4 server that will be checked for new mail.
	 */
	void setImapServer( const char *server, int port );

	/** Set the account information for the IMAP server. */
	void setUser( const char *user, const char *password, const char *mailbox,
			bool savepwd = false );

	const char *server() const { return _server; }
	int port() const { return _port; }

	const char *user() const { return _user; }
	const char *password() const { return _password; }
	const char *mailbox() const { return _mailbox; }

	virtual void recheck();

	virtual bool valid();

	/**
	* KImap4Drop Destructor
	*/
	virtual ~KImap4Drop();


	virtual KMailDrop* clone () const ;
	virtual bool readConfigGroup ( const KConfigBase& cfg );
	virtual bool writeConfigGroup ( KConfigBase& cfg ) const;
	virtual const char *type() const { return "imap4"; }

	virtual void addConfigPage( KDropCfgDialog * );

private:
	KImap4Drop& operator = ( const KImap4Drop& );
	static void encrypt( QString& str );
	static void decrypt( QString& str );
};
#endif // KEG_IMAPDROP_H
