/* This file implements the tab showing personal attributes of persons.
 * This file additionally implements  the comment and birthday tab,
 * since they are totally simple. 
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.11 $
 */

#ifndef KAB_LOOK_EDIT_TABPERSON_H
#define KAB_LOOK_EDIT_TABPERSON_H "$ID$"

#include "look_edit_basictab.h"
#include <qdatetime.h>

class KabAPI;
class KDatePicker;
class QLineEdit;
class QLabel;
class QGridLayout;
class QMultiLineEdit;
class QStringList;

class TabPerson : public TabBasic
{
  Q_OBJECT
public:
  TabPerson(KabAPI*, QWidget *parent=0);
  ~TabPerson();
  /** Derived from TabBasic. */
  void storeContents(AddressBook::Entry& entry);
  /** Dito. */
  void setContents(const AddressBook::Entry& entry);
protected:
  // void resizeEvent(QResizeEvent*);
  QLineEdit *firstname;
  QLineEdit *middlename;
  QLineEdit *lastname;
  QLineEdit *fn; // the formatted name, replaces the combination of first/middle/last
  QLineEdit *nameprefix;
  QLineEdit *title;
  QLineEdit *rank;
  QLabel *l_firstname;
  QLabel *l_middlename;
  QLabel *l_lastname;
  QLabel *l_fn; // the formatted name, replaces the combination of first/middle/last
  QLabel *l_nameprefix;
  QLabel *l_title;
  QLabel *l_rank;
  QPushButton *buttonEmail;
  QPushButton *buttonTalk;
  QPushButton *buttonURLs;
  QGridLayout *layout;
  QStringList *emails;
  QStringList *talk;
  QStringList *urls;
protected slots:
  void textChangedSlot(const QString&);
  void editEmailAddresses();
  void editTalkAddresses();
  void editURLs();
};

class TabBirthday : public TabBasic
{
  Q_OBJECT
public:
  TabBirthday(KabAPI*, QWidget *parent=0);
  /** Derived from TabBasic. */
  void storeContents(AddressBook::Entry& entry);
  /** Dito. */
  void setContents(const AddressBook::Entry& entry);
protected:
  void resizeEvent(QResizeEvent*);
  KDatePicker *datepicker;
protected slots:
  void dateChanged(QDate); 
};

class TabComment : public TabBasic
{
  Q_OBJECT
public:
  TabComment(KabAPI*, QWidget *parent=0);
  /** Derived from TabBasic. */
  void storeContents(AddressBook::Entry& entry);
  /** Dito. */
  void setContents(const AddressBook::Entry& entry);
protected:
  void resizeEvent(QResizeEvent*);
  QMultiLineEdit *mle;
protected slots:
  void textChangedSlot();
};

#endif // KAB_LOOK_EDIT_TABPERSON_H
