/* -------------------------------------------------------------

   configdialog.cpp (part of Klipper - Cut & paste history for KDE)

   $Id: configdialog.cpp,v 1.7 2000/06/01 13:56:15 hausmann Exp $

   (C) 2000 by Carsten Pfeiffer <pfeiffer@kde.org>

   Licensed under the Artistic License

 ------------------------------------------------------------- */

#include <qlayout.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qvbox.h>
#include <qlabel.h>

#include <kaboutdialog.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpopupmenu.h>

#include "keditablelistview.h"
#include "configdialog.h"

ConfigDialog::ConfigDialog( const ActionList *list, KGlobalAccel *accel )
    : KDialogBase( KDialogBase::Tabbed, i18n("Klipper configuration"),
		    KDialogBase::Ok | KDialogBase::Cancel | KDialogBase::Help,
		    KDialogBase::Ok, 0L, "config dialog" )
{
    QFrame *w = 0L; // the parent for the widgets

    w = addPage( i18n("General") );
    generalWidget = new GeneralWidget( w, "general widget" );
    w = addPage( i18n("Actions") );
    actionWidget = new ActionWidget( list, w, "actions widget" );
    w = addPage( i18n("Shortcuts") );
    keysWidget = new KeysWidget( accel, w, "shortcuts widget" );

    /* hmmm, this sort of sucks...
    w = addVBoxPage( i18n("About") );
    KAboutWidget *about = new KAboutWidget( w, "about widget" );

    about->setAuthor("Andrew Stanley-Jones", "asj@cban.com",
		     QString::null, QString::null);
    about->addContributor("Carsten Pfeiffer", "pfeiffer@kde.org",
			  QString::null, QString::null);
    about->setMaintainer("Carsten Pfeiffer",
			 QString::null, QString::null, QString::null);
    about->setVersion( "0.7" );
    */
}
		

ConfigDialog::~ConfigDialog()
{
}



/////////////////////////////////////////
////


GeneralWidget::GeneralWidget( QWidget *parent, const char *name )
    : QVGroupBox( parent, name )
{
    QVBoxLayout *layout = new QVBoxLayout( parent, 0,
					   KDialogBase::spacingHint() );
    layout->addWidget( this );

    setTitle( i18n("General settings" ));

    cbMousePos = new QCheckBox( i18n("Popup menu at mouse-cursor position"),
				this );
    cbSaveContents = new QCheckBox( i18n("Save clipboard contents on exit"),
				    this );
}

GeneralWidget::~GeneralWidget()
{
}


/////////////////////////////////////////
////


ActionWidget::ActionWidget( const ActionList *list, QWidget *parent,
			    const char *name )
    : QVGroupBox( parent, name )
{
    ASSERT( list != 0L );

    setTitle( i18n("Action settings (right-click to add/remove commands)") );
    QVBoxLayout *layout = new QVBoxLayout( parent, 0,
					   KDialogBase::spacingHint() );
    layout->addWidget( this );


    listView = new KEditableListView( this, "list view" );
    listView->addColumn( i18n("Regular expression") );
    listView->addColumn( i18n("Description") );

    listView->setRootIsDecorated( true );
    listView->setMultiSelection( false );
    listView->setAllColumnsShowFocus( true );
    listView->setSelectionMode( QListView::Single );
    connect( listView, SIGNAL( rightButtonPressed( QListViewItem *,
						   const QPoint&, int) ),
	     SLOT( slotRightPressed( QListViewItem *, const QPoint&, int )));

    ClipAction *action   = 0L;
    ClipCommand *command = 0L;
    QListViewItem *item  = 0L;
    QListViewItem *child = 0L;
    QListViewItem *after = 0L; // QListView's default inserting really sucks
    ActionListIterator it( *list );

    const QPixmap& doc = SmallIcon( "misc" );
    const QPixmap& exec = SmallIcon( "exec" );

    for ( action = it.current(); action; action = ++it ) {
	item = new QListViewItem( listView, after,
				  action->regExp(), action->description() );
	item->setPixmap( 0, doc );

	QListIterator<ClipCommand> it2( action->commands() );
	for ( command = it2.current(); command; command = ++it2 ) {
	    child = new QListViewItem( item, after,
				       command->command, command->description);
	    child->setPixmap( 0, exec );
	    after = child;
	}
	after = item;
    }

    listView->setSorting( -1 ); // newly inserted items just append unsorted

    QHBox *box = new QHBox( this );
    box->setSpacing( KDialog::spacingHint() );
    QPushButton *button = new QPushButton( i18n("&Add Action"), box );
    connect( button, SIGNAL( clicked() ), SLOT( slotAddAction() ));

    button = new QPushButton( i18n("&Delete Action"), box );
    connect( button, SIGNAL( clicked() ), SLOT( slotDeleteAction() ));

    QLabel *label = new QLabel(i18n("Click on a highlighted item's column to change it. \"%s\" in a command will be replaced with the clipboard contents."), box);
    label->setAlignment( WordBreak | AlignLeft | AlignVCenter );

    box->setStretchFactor( label, 5 );
}

ActionWidget::~ActionWidget()
{
}


void ActionWidget::slotRightPressed( QListViewItem *item, const QPoint&, int )
{
    if ( !item )
	return;

    int addCmd = 0, rmCmd = 0;
    KPopupMenu *menu = new KPopupMenu;
    addCmd = menu->insertItem( i18n("Add Command") );
    rmCmd = menu->insertItem( i18n("Remove Command") );
    if ( !item->parent() ) {// no "command" item
	menu->setItemEnabled( rmCmd, false );
	item->setOpen( true );
    }

    int id = menu->exec( QCursor::pos() );
    if ( id == addCmd ) {
	QListViewItem *p = item->parent() ? item->parent() : item;
	QListViewItem *cmdItem = new QListViewItem( p, item,
			 i18n("Click here to set the command to be executed"),
			 i18n("describe the command") );
	cmdItem->setPixmap( 0, SmallIcon( "exec" ) );
    }
    else if ( id == rmCmd )
	delete item;

    delete menu;
}

void ActionWidget::slotAddAction()
{
    QListViewItem *item = new QListViewItem( listView );
    item->setPixmap( 0, SmallIcon( "misc" ));
    item->setText( 0, i18n("Click here to set the regexp"));
    item->setText( 1, i18n("describe the action"));
}


void ActionWidget::slotDeleteAction()
{
    QListViewItem *item = listView->currentItem();
    if ( item && item->parent() )
	item = item->parent();
    delete item;
}


ActionList * ActionWidget::actionList()
{
    QListViewItem *item = listView->firstChild();
    QListViewItem *child = 0L;
    ClipAction *action = 0L;
    ActionList *list = new ActionList;
    list->setAutoDelete( true );
    while ( item ) {
	action = new ClipAction( item->text( 0 ), item->text( 1 ) );
	child = item->firstChild();

	// add the commands
	while ( child ) {
	    action->addCommand( child->text( 0 ), child->text( 1 ), true );
	    child = child->nextSibling();
	}
	
	list->append( action );
	item = item->nextSibling();
    }

    return list;
}


///////////////////////////////////////////////////////
//////////


KeysWidget::KeysWidget( KGlobalAccel *accel, QWidget *parent, const char *name)
    : QVGroupBox( parent, name )
{
    QVBoxLayout *layout = new QVBoxLayout( parent, 0,
					   KDialogBase::spacingHint() );
    layout->addWidget( this );

    setTitle( i18n("Global keyboard shortcuts") );

    dict = new QDict<KKeyEntry>(accel->keyDict());
    dict->setAutoDelete( false );
    keyChooser = new KKeyChooser( dict, this );
}

KeysWidget::~KeysWidget()
{
    delete dict;
}


#include "configdialog.moc"
