/* -*- C++ -*-

  $Id: TranslateCmd.h,v 1.2 2000/05/16 13:25:21 sattler Exp $

  This file is part of KIllustrator.
  Copyright (C) 1998 Kai-Uwe Sattler (kus@iti.cs.uni-magdeburg.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by  
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef TranslateCmd_h_
#define TranslateCmd_h_

#include "Command.h"

/**
 * Translates the selected objects of the given document <tt>doc</tt>
 * by the values of <tt>x</tt> and <tt>y</tt>.
 */
class TranslateCmd : public ObjectManipCmd { 
  Q_OBJECT
public:
  TranslateCmd (GDocument* doc, float x, float y);

  void execute ();

  float xOffset () const { return dx; }
  float yOffset () const { return dy; }

private:
  float dx, dy;
};

#endif
