
/*********************************************************************
 *      compiler.h - some defines for dsp registers
 *      Copyright (C) 2000 Rui Sousa 
 ********************************************************************* 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 ********************************************************************* 
*/

#ifndef _COMPILER_H
#define COMPILER_H

#include "types.h"
#include "list.h"

#define DSP_CODE_SIZE 0x400

u32 dsp_code[DSP_CODE_SIZE];

char patch_name[32];

#define PATCH_NAME(a) patch_name = (a);

#define TRAM_LINE_TOTAL 0xa0

#define TRAM_LINE_USAGE_READ 0x01
#define TRAM_LINE_USAGE_WRITE 0x02

struct tram_line {
	struct list_head list;
	u8 usage;
	u32 address_value;
	u32 data_value;
	u32 num;
	struct tram_block *block;
};

struct tram_line *tram_line_table[TRAM_LINE_TOTAL];

LIST_HEAD(tram_line_list);

#define TRAM_BLOCK_TYPE_EMPTY 0x00
#define TRAM_BLOCK_TYPE_DELAYLINE 0x01
#define TRAM_BLOCK_TYPE_LOOKUPTABLE 0x02

struct tram_block {
	struct list_head list;
	int type;
	int size;
	int num;
	struct list_head tram_line;
};

LIST_HEAD(tram_block_list);

#define GPR_TOTAL 0x100

#define GPR_USAGE_INPUT 0x01
#define GPR_USAGE_OUTPUT 0x02
#define GPR_USAGE_STATIC 0x04
#define GPR_USAGE_DYNAMIC 0x08
#define GPR_USAGE_CONTROL 0x10

struct gpr {
	struct list_head list;
	u8 usage;
	u32 value;
	u32 num;
	char name[32];
};

struct gpr *gpr_table[GPR_TOTAL]; 

LIST_HEAD(gpr_list);

int ip;

/* nicer names */

#define macs(z, w, x, y) op(0x0, (z), (w), (x), (y))
#define macs1(z, w, x, y) op(0x1, (z), (w), (x), (y))
#define macw(z, w, x, y) op(0x2, (z), (w), (x), (y))
#define macw1(z, w, x, y) op(0x3, (z), (w), (x), (y))

#define macints(z, w, x, y) op(0x4, (z), (w), (x), (y))
#define macintw(z, w, x, y) op(0x5, (z), (w), (x), (y))

#define acc3(z, w, x, y) op(0x6, (z), (w), (x), (y))
#define macmv(z, w, x, y) op(0x7, (z), (w), (x), (y))
#define andxor(z, w, x, y) op(0x8, (z), (w), (x), (y))
#define tstneg(z, w, x, y) op(0x9, (z), (w), (x), (y))
#define limit(z, w, x, y) op(0xa, (z), (w), (x), (y))
#define limit1(z, w, x, y) op(0xb, (z), (w), (x), (y))
#define log(z, w, x, y) op(0xc, (z), (w), (x), (y))
#define exp(z, w, x, y) op(0xd, (z), (w), (x), (y))
#define interp(z, w, x, y) op(0xe, (z), (w), (x), (y))
#define skip(z, w, x, y) op(0xf, (z), (w), (x), (y))

#define and(z, x , y)	andxor((z), (x), (y), C_0)
#define xor(z, x, y)	andxor((z), cnt(0x10), (x), (y))
#define neg(z, x)	andxor((z), (x), cnt(0x10), cnt(0x10))
//#define NAND(z, x, y) ANDXOR((z),

#define SPDIF_L in(0x02)
#define SPDIF_R in(0x03)

#define FRONT_L out(0x00)
#define FRONT_R out(0x01)

#define REAR_L out(0x08)
#define REAR_R out(0x09)

/* constants */

#define C_0     cnt(0x00)
#define C_1     cnt(0x01)
#define C_2     cnt(0x02)
#define C_3     cnt(0x03)
#define C_4     cnt(0x04)
#define C_8	cnt(0x05)
#define C_16    cnt(0x06)
#define C_32	cnt(0x07)
#define C_256	cnt(0x08)

/* accumulator */

#define ACCUM    cnt(0x16)

#endif
