/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.util.Archive;
import netscape.util.ClassInfo;
import netscape.util.CompactInputStream;
import netscape.util.CompactOutputStream;
import netscape.util.IdHashtable;
import netscape.util.InconsistencyException;

public class ClassTable {
    Archive archive;
    String className;
    int classCount;
    String[] classNames;
    int[] classVersions;
    int fieldCount;
    byte[] fieldTypes;
    String[] fieldNames;
    IdHashtable columnForField;
    int rowCapacity;
    int rowCount;
    Object[] fieldColumns;
    int tableId;
    boolean uniqueStrings;

    public ClassTable(Archive archive) {
        this.archive = archive;
    }

    public ClassTable(Archive archive, ClassInfo classInfo) {
        this(archive);
        this.className = classInfo.className();
        this.classCount = classInfo.classCount();
        this.classNames = classInfo.classNames();
        this.classVersions = classInfo.classVersions();
        this.fieldCount = classInfo.fieldCount();
        this.fieldTypes = classInfo.fieldTypes();
        this.fieldNames = classInfo.fieldNames();
        this.fieldColumns = new Object[this.fieldCount];
    }

    public Archive archive() {
        return this.archive;
    }

    public String className() {
        return this.className;
    }

    public String[] classNames() {
        return this.classNames;
    }

    public int versionForClassName(String string) {
        int n = this.classCount;
        int n2 = 0;
        while (n2 < n) {
            if (this.classNames[n2].equals(string)) {
                return this.classVersions[n2];
            }
            ++n2;
        }
        return 0;
    }

    public int rowCount() {
        return this.rowCount;
    }

    private Object newColumn(int n, int n2) {
        switch (n) {
            case 0: {
                return new boolean[n2];
            }
            case 1: {
                return new boolean[n2][];
            }
            case 2: {
                return new char[n2];
            }
            case 3: {
                return new char[n2][];
            }
            case 4: {
                return new byte[n2];
            }
            case 5: {
                return new byte[n2][];
            }
            case 6: {
                return new short[n2];
            }
            case 7: {
                return new short[n2][];
            }
            case 8: {
                return new int[n2];
            }
            case 9: {
                return new int[n2][];
            }
            case 10: {
                return new long[n2];
            }
            case 11: {
                return new long[n2][];
            }
            case 12: {
                return new float[n2];
            }
            case 13: {
                return new float[n2][];
            }
            case 14: {
                return new double[n2];
            }
            case 15: {
                return new double[n2][];
            }
            case 16: {
                return new String[n2];
            }
            case 17: {
                return new String[n2][];
            }
            case 18: {
                return new int[n2];
            }
            case 19: {
                return new int[n2][];
            }
        }
        throw new InconsistencyException("Unknown field type: " + n);
    }

    private void ensureCapacity(int n) {
        if (n <= this.rowCapacity) {
            return;
        }
        int n2 = 0;
        while (n2 < this.fieldCount) {
            Object object = this.newColumn(this.fieldTypes[n2], n);
            if (this.rowCapacity > 0) {
                System.arraycopy(this.fieldColumns[n2], 0, object, 0, this.rowCapacity);
            }
            this.fieldColumns[n2] = object;
            ++n2;
        }
        this.rowCapacity = n;
    }

    private void growCapacity() {
        int n = this.rowCapacity == 0 ? 8 : 2 * this.rowCapacity;
        this.ensureCapacity(n);
    }

    public int newIdentifier() {
        if (this.rowCount >= this.rowCapacity) {
            this.growCapacity();
        }
        int n = this.archive.mapIdentifier(this, this.rowCount);
        ++this.rowCount;
        return n;
    }

    public int rowForIdentifier(int n) {
        return this.archive.rowForIdentifier(n);
    }

    public int columnForField(String string) {
        int n;
        if (this.archive.performanceDebug) {
            System.err.println("*** Field " + string + " of class " + this.className + " was accessed out of order.");
        }
        if (this.columnForField == null) {
            this.columnForField = new IdHashtable(true);
            n = 0;
            while (n < this.fieldCount) {
                this.columnForField.putKnownAbsent((Object)this.fieldNames[n], n + 1);
                ++n;
            }
        }
        n = this.columnForField.get((Object)string);
        return n - 1;
    }

    void uniqueStrings(ClassInfo classInfo) {
        this.setUniqueStrings(true);
        if (classInfo.fieldCount != this.fieldCount) {
            if (this.archive.performanceDebug) {
                System.err.println("Failed to unique Strings in class " + classInfo.className());
            }
            return;
        }
        this.columnForField = null;
        String[] stringArray = classInfo.fieldNames;
        String[] stringArray2 = this.fieldNames;
        int n = this.fieldCount;
        int n2 = 0;
        while (n2 < n) {
            if (!stringArray2[n2].equals(stringArray[n2])) {
                if (this.archive.performanceDebug) {
                    System.err.println("Failed to unique Strings in class " + classInfo.className());
                }
                return;
            }
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
        if (classInfo.classCount != this.classCount) {
            return;
        }
        stringArray = classInfo.classNames;
        stringArray2 = this.classNames;
        n = this.classCount;
        n2 = 0;
        while (n2 < n) {
            if (!stringArray2[n2].equals(stringArray[n2])) {
                return;
            }
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
    }

    void setUniqueStrings(boolean bl) {
        this.uniqueStrings = bl;
    }

    boolean hasUniqueStrings() {
        return this.uniqueStrings;
    }

    public boolean booleanAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((boolean[])this.fieldColumns[n2])[n];
    }

    public void setBooleanAt(int n, int n2, boolean bl) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((boolean[])this.fieldColumns[n2])[n] = bl;
    }

    public boolean[] booleanArrayAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((boolean[][])this.fieldColumns[n2])[n];
    }

    public void setBooleanArrayAt(int n, int n2, boolean[] blArray) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((boolean[][])this.fieldColumns[n2])[n] = blArray;
    }

    public char charAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((char[])this.fieldColumns[n2])[n];
    }

    public void setCharAt(int n, int n2, char c) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((char[])this.fieldColumns[n2])[n] = c;
    }

    public char[] charArrayAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((char[][])this.fieldColumns[n2])[n];
    }

    public void setCharArrayAt(int n, int n2, char[] cArray) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((char[][])this.fieldColumns[n2])[n] = cArray;
    }

    public byte byteAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((byte[])this.fieldColumns[n2])[n];
    }

    public void setByteAt(int n, int n2, byte by) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((byte[])this.fieldColumns[n2])[n] = by;
    }

    public byte[] byteArrayAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((byte[][])this.fieldColumns[n2])[n];
    }

    public void setByteArrayAt(int n, int n2, byte[] byArray) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((byte[][])this.fieldColumns[n2])[n] = byArray;
    }

    public short shortAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((short[])this.fieldColumns[n2])[n];
    }

    public void setShortAt(int n, int n2, short s) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((short[])this.fieldColumns[n2])[n] = s;
    }

    public short[] shortArrayAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((short[][])this.fieldColumns[n2])[n];
    }

    public void setShortArrayAt(int n, int n2, short[] sArray) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((short[][])this.fieldColumns[n2])[n] = sArray;
    }

    public int intAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((int[])this.fieldColumns[n2])[n];
    }

    public void setIntAt(int n, int n2, int n3) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((int[])this.fieldColumns[n2])[n] = n3;
    }

    public int[] intArrayAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((int[][])this.fieldColumns[n2])[n];
    }

    public void setIntArrayAt(int n, int n2, int[] nArray) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((int[][])this.fieldColumns[n2])[n] = nArray;
    }

    public long longAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((long[])this.fieldColumns[n2])[n];
    }

    public void setLongAt(int n, int n2, long l) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((long[])this.fieldColumns[n2])[n] = l;
    }

    public long[] longArrayAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((long[][])this.fieldColumns[n2])[n];
    }

    public void setLongArrayAt(int n, int n2, long[] lArray) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((long[][])this.fieldColumns[n2])[n] = lArray;
    }

    public float floatAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((float[])this.fieldColumns[n2])[n];
    }

    public void setFloatAt(int n, int n2, float f) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((float[])this.fieldColumns[n2])[n] = f;
    }

    public float[] floatArrayAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((float[][])this.fieldColumns[n2])[n];
    }

    public void setFloatArrayAt(int n, int n2, float[] fArray) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((float[][])this.fieldColumns[n2])[n] = fArray;
    }

    public double doubleAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((double[])this.fieldColumns[n2])[n];
    }

    public void setDoubleAt(int n, int n2, double d) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((double[])this.fieldColumns[n2])[n] = d;
    }

    public double[] doubleArrayAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((double[][])this.fieldColumns[n2])[n];
    }

    public void setDoubleArrayAt(int n, int n2, double[] dArray) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((double[][])this.fieldColumns[n2])[n] = dArray;
    }

    public String stringAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((String[])this.fieldColumns[n2])[n];
    }

    public void setStringAt(int n, int n2, String string) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((String[])this.fieldColumns[n2])[n] = string;
    }

    public String[] stringArrayAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((String[][])this.fieldColumns[n2])[n];
    }

    public void setStringArrayAt(int n, int n2, String[] stringArray) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((String[][])this.fieldColumns[n2])[n] = stringArray;
    }

    public int identifierAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((int[])this.fieldColumns[n2])[n];
    }

    public void setIdentifierAt(int n, int n2, int n3) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((int[])this.fieldColumns[n2])[n] = n3;
    }

    public int[] identifierArrayAt(int n, int n2) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return ((int[][])this.fieldColumns[n2])[n];
    }

    public void setIdentifierArrayAt(int n, int n2, int[] nArray) {
        if (n >= this.rowCount) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        ((int[][])this.fieldColumns[n2])[n] = nArray;
    }

    public void writeInfo(OutputStream outputStream) throws IOException {
        CompactOutputStream compactOutputStream = outputStream instanceof CompactOutputStream ? (CompactOutputStream)outputStream : new CompactOutputStream(outputStream);
        compactOutputStream.writeCompactUTF(this.className);
        int n = this.fieldCount;
        compactOutputStream.writeCompactInt(n);
        int n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeCompactUTF(this.fieldNames[n2]);
            compactOutputStream.writeByte((int)this.fieldTypes[n2]);
            ++n2;
        }
        n = this.classCount;
        compactOutputStream.writeCompactInt(n);
        n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeCompactUTF(this.classNames[n2]);
            compactOutputStream.writeCompactInt(this.classVersions[n2]);
            ++n2;
        }
        compactOutputStream.writeCompactInt(0);
    }

    public void writeData(OutputStream outputStream) throws IOException {
        CompactOutputStream compactOutputStream = outputStream instanceof CompactOutputStream ? (CompactOutputStream)outputStream : new CompactOutputStream(outputStream);
        compactOutputStream.writeCompactInt(this.rowCount);
        int n = this.fieldCount;
        int n2 = 0;
        while (n2 < n) {
            if (this.fieldTypes[n2] == 0) {
                this.writeBooleanColumn(compactOutputStream, (boolean[])this.fieldColumns[n2], this.rowCount);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            Object object = this.fieldColumns[n2];
            switch (this.fieldTypes[n2]) {
                case 1: {
                    this.writeBooleanArrayColumn(compactOutputStream, (boolean[][])object, this.rowCount);
                    break;
                }
                case 2: {
                    this.writeCharColumn(compactOutputStream, (char[])object, this.rowCount);
                    break;
                }
                case 3: {
                    this.writeCharArrayColumn(compactOutputStream, (char[][])object, this.rowCount);
                    break;
                }
                case 4: {
                    this.writeByteColumn(compactOutputStream, (byte[])object, this.rowCount);
                    break;
                }
                case 5: {
                    this.writeByteArrayColumn(compactOutputStream, (byte[][])object, this.rowCount);
                    break;
                }
                case 6: {
                    this.writeShortColumn(compactOutputStream, (short[])object, this.rowCount);
                    break;
                }
                case 7: {
                    this.writeShortArrayColumn(compactOutputStream, (short[][])object, this.rowCount);
                    break;
                }
                case 8: {
                    this.writeIntColumn(compactOutputStream, (int[])object, this.rowCount);
                    break;
                }
                case 9: {
                    this.writeIntArrayColumn(compactOutputStream, (int[][])object, this.rowCount);
                    break;
                }
                case 10: {
                    this.writeLongColumn(compactOutputStream, (long[])object, this.rowCount);
                    break;
                }
                case 11: {
                    this.writeLongArrayColumn(compactOutputStream, (long[][])object, this.rowCount);
                    break;
                }
                case 12: {
                    this.writeFloatColumn(compactOutputStream, (float[])object, this.rowCount);
                    break;
                }
                case 13: {
                    this.writeFloatArrayColumn(compactOutputStream, (float[][])object, this.rowCount);
                    break;
                }
                case 14: {
                    this.writeDoubleColumn(compactOutputStream, (double[])object, this.rowCount);
                    break;
                }
                case 15: {
                    this.writeDoubleArrayColumn(compactOutputStream, (double[][])object, this.rowCount);
                    break;
                }
                case 16: {
                    this.writeStringColumn(compactOutputStream, (String[])object, this.rowCount);
                    break;
                }
                case 17: {
                    this.writeStringArrayColumn(compactOutputStream, (String[][])object, this.rowCount);
                    break;
                }
                case 18: {
                    this.writeIntColumn(compactOutputStream, (int[])object, this.rowCount);
                    break;
                }
                case 19: {
                    this.writeIntArrayColumn(compactOutputStream, (int[][])object, this.rowCount);
                    break;
                }
                default: {
                    throw new InconsistencyException("Unknown field type: " + this.fieldTypes[n2]);
                }
                case 0: 
            }
            ++n2;
        }
        compactOutputStream.writeCompactInt(0);
    }

    private void writeBooleanColumn(CompactOutputStream compactOutputStream, boolean[] blArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeCompactBoolean(blArray[n2]);
            ++n2;
        }
    }

    private void writeBooleanArrayColumn(CompactOutputStream compactOutputStream, boolean[][] blArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            boolean[] blArray2 = blArray[n2];
            if (blArray2 == null) {
                compactOutputStream.writeCompactInt(-1);
            } else {
                compactOutputStream.writeCompactInt(blArray2.length);
                this.writeBooleanColumn(compactOutputStream, blArray2, blArray2.length);
            }
            ++n2;
        }
    }

    private void writeCharColumn(CompactOutputStream compactOutputStream, char[] cArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeChar((int)cArray[n2]);
            ++n2;
        }
    }

    private void writeCharArrayColumn(CompactOutputStream compactOutputStream, char[][] cArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            char[] cArray2 = cArray[n2];
            if (cArray2 == null) {
                compactOutputStream.writeCompactInt(-1);
            } else {
                compactOutputStream.writeCompactInt(cArray2.length);
                this.writeCharColumn(compactOutputStream, cArray2, cArray2.length);
            }
            ++n2;
        }
    }

    private void writeByteColumn(CompactOutputStream compactOutputStream, byte[] byArray, int n) throws IOException {
        compactOutputStream.write(byArray, 0, n);
    }

    private void writeByteArrayColumn(CompactOutputStream compactOutputStream, byte[][] byArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray2 = byArray[n2];
            if (byArray2 == null) {
                compactOutputStream.writeCompactInt(-1);
            } else {
                compactOutputStream.writeCompactInt(byArray2.length);
                this.writeByteColumn(compactOutputStream, byArray2, byArray2.length);
            }
            ++n2;
        }
    }

    private void writeShortColumn(CompactOutputStream compactOutputStream, short[] sArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeShort((int)sArray[n2]);
            ++n2;
        }
    }

    private void writeShortArrayColumn(CompactOutputStream compactOutputStream, short[][] sArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            short[] sArray2 = sArray[n2];
            if (sArray2 == null) {
                compactOutputStream.writeCompactInt(-1);
            } else {
                compactOutputStream.writeCompactInt(sArray2.length);
                this.writeShortColumn(compactOutputStream, sArray2, sArray2.length);
            }
            ++n2;
        }
    }

    private void writeIntColumn(CompactOutputStream compactOutputStream, int[] nArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeCompactInt(nArray[n2]);
            ++n2;
        }
    }

    private void writeIntArrayColumn(CompactOutputStream compactOutputStream, int[][] nArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int[] nArray2 = nArray[n2];
            if (nArray2 == null) {
                compactOutputStream.writeCompactInt(-1);
            } else {
                int n3 = nArray2.length;
                compactOutputStream.writeCompactInt(n3);
                int n4 = 0;
                while (n4 < n3) {
                    compactOutputStream.writeInt(nArray2[n4]);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void writeLongColumn(CompactOutputStream compactOutputStream, long[] lArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeLong(lArray[n2]);
            ++n2;
        }
    }

    private void writeLongArrayColumn(CompactOutputStream compactOutputStream, long[][] lArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            long[] lArray2 = lArray[n2];
            if (lArray2 == null) {
                compactOutputStream.writeCompactInt(-1);
            } else {
                compactOutputStream.writeCompactInt(lArray2.length);
                this.writeLongColumn(compactOutputStream, lArray2, lArray2.length);
            }
            ++n2;
        }
    }

    private void writeFloatColumn(CompactOutputStream compactOutputStream, float[] fArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeFloat(fArray[n2]);
            ++n2;
        }
    }

    private void writeFloatArrayColumn(CompactOutputStream compactOutputStream, float[][] fArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            float[] fArray2 = fArray[n2];
            if (fArray2 == null) {
                compactOutputStream.writeCompactInt(-1);
            } else {
                compactOutputStream.writeCompactInt(fArray2.length);
                this.writeFloatColumn(compactOutputStream, fArray2, fArray2.length);
            }
            ++n2;
        }
    }

    private void writeDoubleColumn(CompactOutputStream compactOutputStream, double[] dArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeDouble(dArray[n2]);
            ++n2;
        }
    }

    private void writeDoubleArrayColumn(CompactOutputStream compactOutputStream, double[][] dArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            double[] dArray2 = dArray[n2];
            if (dArray2 == null) {
                compactOutputStream.writeCompactInt(-1);
            } else {
                compactOutputStream.writeCompactInt(dArray2.length);
                this.writeDoubleColumn(compactOutputStream, dArray2, dArray2.length);
            }
            ++n2;
        }
    }

    private void writeStringColumn(CompactOutputStream compactOutputStream, String[] stringArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            compactOutputStream.writeCompactUTF(stringArray[n2]);
            ++n2;
        }
    }

    private void writeStringArrayColumn(CompactOutputStream compactOutputStream, String[][] stringArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray2 = stringArray[n2];
            if (stringArray2 == null) {
                compactOutputStream.writeCompactInt(-1);
            } else {
                compactOutputStream.writeCompactInt(stringArray2.length);
                this.writeStringColumn(compactOutputStream, stringArray2, stringArray2.length);
            }
            ++n2;
        }
    }

    public void readInfo(InputStream inputStream) throws IOException {
        int n;
        CompactInputStream compactInputStream = inputStream instanceof CompactInputStream ? (CompactInputStream)inputStream : new CompactInputStream(inputStream);
        this.className = compactInputStream.readCompactUTF();
        this.fieldCount = n = compactInputStream.readCompactInt();
        this.fieldNames = new String[n];
        this.fieldTypes = new byte[n];
        this.fieldColumns = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            this.fieldNames[n2] = compactInputStream.readCompactUTF();
            this.fieldTypes[n2] = compactInputStream.readByte();
            ++n2;
        }
        this.classCount = n = compactInputStream.readCompactInt();
        this.classNames = new String[n];
        this.classVersions = new int[n];
        n2 = 0;
        while (n2 < n) {
            this.classNames[n2] = compactInputStream.readCompactUTF();
            this.classVersions[n2] = compactInputStream.readCompactInt();
            ++n2;
        }
        n = compactInputStream.readCompactInt();
        if (n > 0) {
            compactInputStream.skipBytes(n);
        }
    }

    public void readData(InputStream inputStream) throws IOException {
        CompactInputStream compactInputStream = inputStream instanceof CompactInputStream ? (CompactInputStream)inputStream : new CompactInputStream(inputStream);
        this.rowCount = compactInputStream.readCompactInt();
        this.ensureCapacity(this.rowCount);
        int n = this.fieldCount;
        int n2 = 0;
        while (n2 < n) {
            if (this.fieldTypes[n2] == 0) {
                this.readBooleanColumn(compactInputStream, (boolean[])this.fieldColumns[n2], this.rowCount);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            Object object = this.fieldColumns[n2];
            switch (this.fieldTypes[n2]) {
                case 1: {
                    this.readBooleanArrayColumn(compactInputStream, (boolean[][])object, this.rowCount);
                    break;
                }
                case 2: {
                    this.readCharColumn(compactInputStream, (char[])object, this.rowCount);
                    break;
                }
                case 3: {
                    this.readCharArrayColumn(compactInputStream, (char[][])object, this.rowCount);
                    break;
                }
                case 4: {
                    this.readByteColumn(compactInputStream, (byte[])object, this.rowCount);
                    break;
                }
                case 5: {
                    this.readByteArrayColumn(compactInputStream, (byte[][])object, this.rowCount);
                    break;
                }
                case 6: {
                    this.readShortColumn(compactInputStream, (short[])object, this.rowCount);
                    break;
                }
                case 7: {
                    this.readShortArrayColumn(compactInputStream, (short[][])object, this.rowCount);
                    break;
                }
                case 8: {
                    this.readIntColumn(compactInputStream, (int[])object, this.rowCount);
                    break;
                }
                case 9: {
                    this.readIntArrayColumn(compactInputStream, (int[][])object, this.rowCount);
                    break;
                }
                case 10: {
                    this.readLongColumn(compactInputStream, (long[])object, this.rowCount);
                    break;
                }
                case 11: {
                    this.readLongArrayColumn(compactInputStream, (long[][])object, this.rowCount);
                    break;
                }
                case 12: {
                    this.readFloatColumn(compactInputStream, (float[])object, this.rowCount);
                    break;
                }
                case 13: {
                    this.readFloatArrayColumn(compactInputStream, (float[][])object, this.rowCount);
                    break;
                }
                case 14: {
                    this.readDoubleColumn(compactInputStream, (double[])object, this.rowCount);
                    break;
                }
                case 15: {
                    this.readDoubleArrayColumn(compactInputStream, (double[][])object, this.rowCount);
                    break;
                }
                case 16: {
                    this.readStringColumn(compactInputStream, (String[])object, this.rowCount);
                    break;
                }
                case 17: {
                    this.readStringArrayColumn(compactInputStream, (String[][])object, this.rowCount);
                    break;
                }
                case 18: {
                    this.readIntColumn(compactInputStream, (int[])object, this.rowCount);
                    break;
                }
                case 19: {
                    this.readIntArrayColumn(compactInputStream, (int[][])object, this.rowCount);
                    break;
                }
                default: {
                    throw new InconsistencyException("Unknown field type: " + this.fieldTypes[n2]);
                }
                case 0: 
            }
            ++n2;
        }
        n = compactInputStream.readCompactInt();
        if (n > 0) {
            compactInputStream.skipBytes(n);
        }
    }

    private void readBooleanColumn(CompactInputStream compactInputStream, boolean[] blArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = compactInputStream.readCompactBoolean();
            ++n2;
        }
    }

    private void readBooleanArrayColumn(CompactInputStream compactInputStream, boolean[][] blArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = compactInputStream.readCompactInt();
            if (n3 >= 0) {
                boolean[] blArray2 = new boolean[n3];
                blArray[n2] = blArray2;
                this.readBooleanColumn(compactInputStream, blArray2, n3);
            }
            ++n2;
        }
    }

    private void readCharColumn(CompactInputStream compactInputStream, char[] cArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = compactInputStream.readChar();
            ++n2;
        }
    }

    private void readCharArrayColumn(CompactInputStream compactInputStream, char[][] cArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = compactInputStream.readCompactInt();
            if (n3 >= 0) {
                char[] cArray2 = new char[n3];
                cArray[n2] = cArray2;
                this.readCharColumn(compactInputStream, cArray2, n3);
            }
            ++n2;
        }
    }

    private void readByteColumn(CompactInputStream compactInputStream, byte[] byArray, int n) throws IOException {
        compactInputStream.readFully(byArray, 0, n);
    }

    private void readByteArrayColumn(CompactInputStream compactInputStream, byte[][] byArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = compactInputStream.readCompactInt();
            if (n3 >= 0) {
                byte[] byArray2 = new byte[n3];
                byArray[n2] = byArray2;
                this.readByteColumn(compactInputStream, byArray2, n3);
            }
            ++n2;
        }
    }

    private void readShortColumn(CompactInputStream compactInputStream, short[] sArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = compactInputStream.readShort();
            ++n2;
        }
    }

    private void readShortArrayColumn(CompactInputStream compactInputStream, short[][] sArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = compactInputStream.readCompactInt();
            if (n3 >= 0) {
                short[] sArray2 = new short[n3];
                sArray[n2] = sArray2;
                this.readShortColumn(compactInputStream, sArray2, n3);
            }
            ++n2;
        }
    }

    private void readIntColumn(CompactInputStream compactInputStream, int[] nArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = compactInputStream.readCompactInt();
            ++n2;
        }
    }

    private void readIntArrayColumn(CompactInputStream compactInputStream, int[][] nArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = compactInputStream.readCompactInt();
            if (n3 >= 0) {
                int[] nArray2 = new int[n3];
                nArray[n2] = nArray2;
                int n4 = 0;
                while (n4 < n3) {
                    nArray2[n4] = compactInputStream.readInt();
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void readLongColumn(CompactInputStream compactInputStream, long[] lArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = compactInputStream.readLong();
            ++n2;
        }
    }

    private void readLongArrayColumn(CompactInputStream compactInputStream, long[][] lArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = compactInputStream.readCompactInt();
            if (n3 >= 0) {
                long[] lArray2 = new long[n3];
                lArray[n2] = lArray2;
                this.readLongColumn(compactInputStream, lArray2, n3);
            }
            ++n2;
        }
    }

    private void readFloatColumn(CompactInputStream compactInputStream, float[] fArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = compactInputStream.readFloat();
            ++n2;
        }
    }

    private void readFloatArrayColumn(CompactInputStream compactInputStream, float[][] fArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = compactInputStream.readCompactInt();
            if (n3 >= 0) {
                float[] fArray2 = new float[n3];
                fArray[n2] = fArray2;
                this.readFloatColumn(compactInputStream, fArray2, n3);
            }
            ++n2;
        }
    }

    private void readDoubleColumn(CompactInputStream compactInputStream, double[] dArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = compactInputStream.readDouble();
            ++n2;
        }
    }

    private void readDoubleArrayColumn(CompactInputStream compactInputStream, double[][] dArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = compactInputStream.readCompactInt();
            if (n3 >= 0) {
                double[] dArray2 = new double[n3];
                dArray[n2] = dArray2;
                this.readDoubleColumn(compactInputStream, dArray2, n3);
            }
            ++n2;
        }
    }

    private void readStringColumn(CompactInputStream compactInputStream, String[] stringArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = compactInputStream.readCompactUTF();
            ++n2;
        }
    }

    private void readStringArrayColumn(CompactInputStream compactInputStream, String[][] stringArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = compactInputStream.readCompactInt();
            if (n3 >= 0) {
                String[] stringArray2 = new String[n3];
                stringArray[n2] = stringArray2;
                this.readStringColumn(compactInputStream, stringArray2, n3);
            }
            ++n2;
        }
    }
}

