#include <errno.h>
#include <signal.h>
#include <stdio.h>

#include "x286emul.h"
#include "ldt.h"
#include "syscall.h"
#include "lcall7.h"

#ifdef DEBUG
# include "debug.h"
#endif


int
emu_exec(struct sigcontext_struct *sc)
{
	unsigned short *p;
	int argc, envc;
	char **q;
	unsigned short *stkladdr;

	if(LDATA){	/* Large Data */
		stkladdr = (unsigned short *)(ldt[sc->ss >> 3].base + (sc->ebx & 0xffff));
		sc->ebx = ldt[stkladdr[1]>>3].base + stkladdr[0];	/* pgm */
		sc->ecx = ldt[stkladdr[3]>>3].base + stkladdr[2];	/* arg */
		sc->esi = ldt[stkladdr[5]>>3].base + stkladdr[4];	/* env */
	}
	else {
		sc->ebx = ldt[sc->ds>>3].base + (sc->ebx & 0xffff);	/* pgm */
		sc->ecx = ldt[sc->ds>>3].base + (sc->ecx & 0xffff);	/* arg */
		sc->esi = ldt[sc->ds>>3].base + (sc->esi & 0xffff);	/* env */
	}


#ifdef DEBUG
	if (__dbf)
		fprintf(__dbf, "x286emul:   exec: program = \"%s\"\n", (char *)sc->ebx);
#endif

	for (argc=0,p=(unsigned short *)sc->ecx; p && *p; p++,argc++) {
#ifdef DEBUG
		if (__dbf){
			if(LDATA){
				fprintf(__dbf, "x286emul:         arg %d: \"%s\"\n",
					argc, (char *)ldt[*(p+1)>>3].base + *p);
				p++;
				}
			else
				fprintf(__dbf, "x286emul:         arg %d: \"%s\"\n",
					argc, (char *)ldt[sc->ds>>3].base + *p);
		}
#endif
	}

	for (envc=0,p=(unsigned short *)sc->esi; p && *p; p++,envc++) {
#ifdef DEBUG
		if (__dbf){
			if(LDATA){
				fprintf(__dbf, "x286emul:         env %d: \"%s\"\n",
					envc, (char *)ldt[*(p+1)>>3].base + *p);
				p++;
				}
			else
				fprintf(__dbf, "x286emul:         env %d: \"%s\"\n",
					envc, (char *)ldt[sc->ds>>3].base + *p);
		}
#endif
	}

	if (!(q = alloca(sizeof(char *) * (argc + envc + 2)))) {
		errno = ENOMEM;
		return -1;
	}

	p = (unsigned short *)sc->ecx;
	sc->ecx = (int)q;
	for (; p && *p; p++){
		if(LDATA){
			*(q++) = (char *)(ldt[*(p+1)>>3].base + *p);
			p++;
			}
		else
			*(q++) = (char *)(ldt[sc->ds>>3].base + *p);
		}
	*(q++) = (char *)0;

	p = (unsigned short *)sc->esi;
	sc->esi = (int)q;
	for (; p && *p; p++){
		if(LDATA){
			*(q++) = (char *)(ldt[*(p+1)>>3].base + *p);
			p++;
			}
		else
			*(q++) = (char *)(ldt[sc->ds>>3].base + *p);
		}
	*(q++) = (char *)0;

	return lcall7(sc->eax & 0xffff, sc->ebx, sc->ecx, sc->esi);
}
