#include <stdio.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/*************************************************************************
 *
 * Function:    fopen
 *
 * Description:
 *    This procedure will open the file and construct a file descriptor
 *    for future access.
 *
 * Entry:
 *    name    - Pointer to the file name to be opened
 *    mode    - Pointer to the file mode
 *
 * Returns:
 *    A pointer to the file table or NULL to indicate a file error.
 */

FILE *fopen (const char *file, const char *mode)
    {
    FILE *stream = NULL;
    FUNC_ENTRY ("fopen");
/*
 *  Abort if either of the parameters are empty.
 */
    if (file != NULL && mode != NULL)
        {
	if (*file != '\0' && *mode != '\0')
	    {
	    stream = _getstream();
	    }
        }
/*
 *  If there is a stream then attempt to open the file
 */
    if (stream != NULL)
        {
	stream = _openfile (file, mode, stream);
        }
/*
 *  Return the resulting stream pointer
 */
    FUNC_EXIT ("fopen");
    return (stream);
    }
