/**********************************
 Set user automatically to away/na
 (c) 1999 Jeremy Wise
 GnomeICU
***********************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <X11/Xlib.h>
#ifdef USE_XSCREENSAVER
# include <X11/Xutil.h>
# include <X11/extensions/scrnsaver.h>
#endif

int old_status = 0x9999;

/*** Global functions ***/
guint auto_away( void )
{
	static Display *display = NULL;
	int status;
	int time_idle = 0;

#ifdef USE_XSCREENSAVER
	static XScreenSaverInfo *info = NULL;
	int event_base, error_base; /* for XScreenSaverQuery */
#endif

#ifdef USE_XPOINTER_CHANGE
	static Window w1, w2, root;
	static int x = -1, y = -1, x1, y1, x2, y2, b;
	static unsigned long last_idle = 0;
#endif

#ifdef TRACE_FUNCTION
/*	g_print( "auto_away\n" );*/
#endif

	if( display == NULL )
		display = XOpenDisplay( gdk_get_display() );

	status = Current_Status & 0xffff;

	if( status != STATUS_ONLINE && status != STATUS_AWAY &&
		 status != STATUS_FREE_CHAT && status != STATUS_NA )
			return TRUE;

#ifdef USE_XSCREENSAVER
	if( XScreenSaverQueryExtension(display, &event_base, &error_base) )
	{
	        if( info == NULL )
		        info = XScreenSaverAllocInfo();
	        XScreenSaverQueryInfo ( display, DefaultRootWindow( display ),
	                              info );
	        time_idle = info->idle;
	}
#endif

#ifdef USE_XPOINTER_CHANGE
	if( x == -1 && y == -1 )
	{
		last_idle = time(0);
		root = RootWindow( display, DefaultScreen( display ) );
	}

	XQueryPointer( display, root, &w1, &w2, &x1, &y1, &x2, &y2, (uint*)&b );
	if( !( x1 == x && y1 == y ) )
	{
		x = x1;
		y = y1;
		last_idle = time( 0 );
	}
	
	time_idle = time( 0 ) - last_idle;
	time_idle = time_idle < 0 ? 0 : time_idle * 1000;
#endif

	if( time_idle > 60000 * AUTO_NA )
	{
		if( old_status == 0x9999 )
			old_status = Current_Status;
		if( status != STATUS_NA )
			icq_change_status( STATUS_NA );
	}
	else if( time_idle > 60000 * AUTO_AWAY )
	{
		if( old_status == 0x9999 )
			old_status = Current_Status;
		if( status != STATUS_AWAY )
			icq_change_status( STATUS_AWAY );
	}
	else
	{
		if( old_status != 0x9999 )
			icq_change_status( old_status );
		old_status = 0x9999;
	}

	return TRUE;
}
