/*****************************
 Drag & Drop support
 (c) 1999 Jeremy Wise
 GnomeICU
*****************************/

/* GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <ctype.h>
#include <libgnome/libgnome.h>
#include <string.h>
#include <gtk/gtk.h>

enum
{
  TARGET_URL,
  TARGET_NETSCAPE_URL
};

static GtkTargetEntry contact_list_drop_types[]=
{
  { "_NETSCAPE_URL", 0, TARGET_NETSCAPE_URL },
  { "text/uri-list", 0, TARGET_URL },
  { "x-url/http", 0, TARGET_NETSCAPE_URL },
  { "x-url/ftp", 0, TARGET_NETSCAPE_URL },
  { "text/plain",0,TARGET_NETSCAPE_URL, }
  /* ??  For some reason Netscape wants to send me stuff as text/plain */
};

static gint n_contact_list_drop_types=
  sizeof(contact_list_drop_types)/sizeof(contact_list_drop_types[0]);

/*** Local function declarations ***/
static void contact_list_dnd_drop(GtkWidget *widget, GdkDragContext *context,
                                  gint x, gint y, GtkSelectionData *selection_data,
                                  guint info, guint time, gpointer data);

/*** Global functions ***/
void init_contact_list_drag_drop(GtkWidget *list)
{
  gtk_signal_connect(GTK_OBJECT(list),
		     "drag_data_received",
		     GTK_SIGNAL_FUNC(contact_list_dnd_drop),
		     NULL);
  gtk_drag_dest_set(GTK_WIDGET(list),
		    GTK_DEST_DEFAULT_MOTION |
		    GTK_DEST_DEFAULT_HIGHLIGHT |
		    GTK_DEST_DEFAULT_DROP,
		    contact_list_drop_types,
		    n_contact_list_drop_types,
		    GDK_ACTION_COPY);
}

/*** Local functions ***/
static void contact_list_dnd_drop(GtkWidget *widget,
				  GdkDragContext *context,
				  gint x,
				  gint y,
				  GtkSelectionData *selection_data,
				  guint info,
				  guint time,
				  gpointer data)
{
  GtkCList *list;
  int row;
  int column;

  g_return_if_fail(widget);
  g_return_if_fail(GTK_IS_CLIST(widget));

  list=GTK_CLIST(widget);

  gtk_clist_get_selection_info(list, x, y, &row, &column);

  gtk_clist_select_row(list, row, column);

  switch(info)
    {
    case TARGET_URL:
      /* We got a bunch of file names */
      {
	GList *files=gnome_uri_list_extract_filenames(selection_data->data),*tmp;

	for(tmp=files; tmp; tmp=g_list_next(tmp))
	  {
	    request_file(widget, (char *)tmp->data);
	  }

	gnome_uri_list_free_strings(files);
      }
      break;
    case TARGET_NETSCAPE_URL:
      {
	GString *type=g_string_new("");
	char *url=(char*) selection_data->data;
	char *tmp=url;
	
	while(isalpha(*tmp))
	  type=g_string_append_c(type,*tmp++);

	if(!strcmp(type->str,""))
	  /* Assume it's a straight filename */
	   {
	     request_file(widget, tmp);
	     g_string_free(type,1);
	     return;
	   }

	if(!strcmp(type->str,"file"))
	  {
	    if(*tmp++!=':')
	      {
		g_warning(_("Badly formed URL: %s\n"),url);
		g_string_free(type,1);
		return;
	      }
	    if(tmp[0]=='/'&&tmp[1]=='/')
	      /* file://host/loationc handling.
	       * If it's of the form file://localhost/stuff, do a file transfer
	       * on stuff, otherwise continue.
	       */
	      {
		tmp+=2;
		if(strstr(tmp,"localhost")==tmp)
		  {
		    tmp+=strlen("localhost");
		    request_file(widget, tmp);
		    g_string_free(type,1);
		    return;
		  }
	      }
	    else /* Of the form file:... */
	      {
		request_file(widget, tmp);
		g_string_free(type,1);
		return;
	      }
	  }

	send_url_window( widget, url );
	g_string_free(type,1);
	break;
      }
    }
}

