/*
 * gnome-print-pixbuf.c: A pixbuf driver for GnomePrint.
 *
 * This implementation uses the GnomePrintRGBP driver.
 *
 * This currently dumps to a file and if the suffix is .pnm
 * it dumps a pnm header.  Just a proof of concept, later this
 * can be dropped and updated to generate ArtPixBufs only.
 *
 * Author:
 *   Miguel de Icaza (miguel@gnu.org)
 *
 * (C) 1999 International GNOME Support
 */
#include <config.h>
#include <stdio.h>
#include <libgnomeprint/gnome-print-pixbuf.h>

static GnomePrintRGBPClass *gpix_parent_class;

static int
gpix_print_band (GnomePrintRGBP *rgbp, guchar *rgb_buffer, ArtIRect *rect)
{
	int size;

	size = (rect->x1 - rect->x0) * (rect->y1 - rect->y0) * 3;
	printf ("Dumping %d bytes (%d %d)-(%d %d)\n", size,
		rect->x0, rect->y0, rect->x1, rect->y1);

	gnome_print_context_write_file (GNOME_PRINT_CONTEXT (rgbp), rgb_buffer, size);

	return 1;
}

static int
gpix_close (GnomePrintContext *pc)
{
	return gnome_print_context_close_file (pc);
}

static void
gpix_class_init (GtkObjectClass *object_class)
{
	GnomePrintRGBPClass *rgbp_class = (GnomePrintRGBPClass *) object_class;
	GnomePrintContextClass *pc_class = (GnomePrintContextClass *) object_class;
	
	gpix_parent_class = gtk_type_class (gnome_print_rgbp_get_type ());

	rgbp_class->print_band = gpix_print_band;

	pc_class->close = gpix_close;
}

GnomePrintPixbuf *
gnome_print_pixbuf_construct (GnomePrintPixbuf *gpix, GnomePrinter *printer, const GnomePaper *paper_info, int dpi)
{
	g_return_val_if_fail (printer != NULL, NULL);
	g_return_val_if_fail (GNOME_IS_PRINTER (printer), NULL);
	g_return_val_if_fail (gpix != NULL, NULL);
	g_return_val_if_fail (GNOME_IS_PRINT_PIXBUF (gpix), NULL);
	g_return_val_if_fail (paper_info != NULL, NULL);
	g_return_val_if_fail (dpi >= 0, NULL);

	if (gnome_print_rgbp_construct (GNOME_PRINT_RGBP (gpix), paper_info, dpi)){
		gnome_print_context_open_file (GNOME_PRINT_CONTEXT (gpix), printer->filename);
		return gpix;
	} else
		return NULL;
}

GnomePrintContext *
gnome_print_pixbuf_new (GnomePrinter *printer, const char *paper_size, int dpi)
{
	GnomePrintPixbuf *gpix;
	const GnomePaper *paper_info;

	g_return_val_if_fail (printer != NULL, NULL);
	g_return_val_if_fail (GNOME_IS_PRINTER (printer), NULL);
	g_return_val_if_fail (paper_size != NULL, NULL);
	g_return_val_if_fail (dpi >= 0, NULL);

	gpix = gtk_type_new (gnome_print_pixbuf_get_type ());

	paper_info = gnome_paper_with_name (paper_size);
	if (paper_info == NULL)
		g_return_val_if_fail (FALSE, NULL);

	if (!gnome_print_pixbuf_construct (gpix, printer, paper_info, dpi))
		gtk_object_unref (GTK_OBJECT (gpix));
	
	return GNOME_PRINT_CONTEXT (gpix);
}

/**
 * gnome_print_pixbuf_get_type:
 *
 * GTK type identification routine for #GnomePrintPixbuf
 *
 * Returns: The Gtk type for the #GnomePrintPixbuf object
 */
GtkType
gnome_print_pixbuf_get_type (void)
{
	static GtkType type = 0;

	if (!type){
		GtkTypeInfo info = {
			"GnomePrintPixbuf",
			sizeof (GnomePrintPixbuf),
			sizeof (GnomePrintPixbufClass),
			(GtkClassInitFunc) gpix_class_init,
			(GtkObjectInitFunc) NULL,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};
		
		type = gtk_type_unique (gnome_print_rgbp_get_type (), &info);
	}
	return type;
}
