;; autoload.jl -- Initialise auto-load functions
;; $Id: autoload.jl,v 1.56 2000/06/12 14:35:36 john Exp $

;; Copyright (C) 1999 John Harper <john@dcs.warwick.ac.uk>

;; This file is part of sawmill.

;; sawmill is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; sawmill is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with sawmill; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; ::autoload-start::
(custom-add-required 'move-resize)
(autoload 'move-window-interactively "move-resize" t)
(autoload 'resize-window-interactively "move-resize" t)
(autoload 'move-selected-window "move-resize" t)
(autoload 'resize-selected-window "move-resize" t)
(autoload 'select-window "select-window")
(autoload 'popup-menu "menus")
(autoload 'popup-window-menu "menus" t)
(autoload 'popup-root-menu "menus" t)
(autoload 'popup-apps-menu "menus" t)
(autoload 'customize "customize" t)
(autoload 'load-session "sm-load")
(autoload 'save-session "sm-save")
(autoload 'map-keymap "keymap")
(autoload 'substitute-keymap-command "keymap")
(autoload 'substitute-keymap-event "keymap")
(autoload 'where-is "keymap")
(autoload 'describe-key "keymap" t)
(autoload 'read-event "keymap")
(autoload 'quote-event "keymap" t)
(autoload 'next-workspace-window "cycle" t)
(autoload 'previous-workspace-window "cycle" t)
(autoload 'next-window "cycle" t)
(autoload 'previous-window "cycle" t)
(autoload 'cycle-windows "x-cycle" t)
(autoload 'cycle-group "x-cycle" t)
(autoload 'cycle-prefix "x-cycle" t)
(autoload 'place-window-first-fit "smart-placement")
(autoload 'place-window-best-fit "smart-placement")
(autoload 'place-window-first-fit-or-interactive "smart-placement")
(define-placement-mode 'first-fit place-window-first-fit)
(define-placement-mode 'best-fit place-window-best-fit)
(define-placement-mode 'first-fit-or-interactive place-window-first-fit-or-interactive)
(autoload 'iconify-group "groups" t)
(autoload 'uniconify-group "groups" t)
(autoload 'make-group-sticky "groups" t)
(autoload 'make-group-unsticky "groups" t)
(autoload 'toggle-group-sticky "groups" t)
(autoload 'send-group-to-workspace "groups")
(autoload 'send-group-to-current-workspace "groups" t)
(autoload 'send-group-to-next-workspace "groups" t)
(autoload 'send-group-to-previous-workspace "groups" t)
(autoload 'move-group-to-current-viewport "groups" t)
(autoload 'move-group-viewport "groups")
(autoload 'move-group-left "groups" t)
(autoload 'move-group-right "groups" t)
(autoload 'move-group-up "groups" t)
(autoload 'move-group-down "groups" t)
(autoload 'raise-group "groups" t)
(autoload 'lower-group "groups" t)
(autoload 'raise-group-depth "groups" t)
(autoload 'lower-group-depth "groups" t)
(autoload 'raise-lower-group "groups" t)
(autoload 'set-group-frame-style "groups")
(autoload 'slide-window-left "slide-window" t)
(autoload 'slide-window-right "slide-window" t)
(autoload 'slide-window-up "slide-window" t)
(autoload 'slide-window-down "slide-window" t)
(autoload 'slide-group-left "slide-window" t)
(autoload 'slide-group-right "slide-window" t)
(autoload 'slide-group-up "slide-window" t)
(autoload 'slide-group-down "slide-window" t)
(autoload 'make-window-ignored "ignore-window" t)
(autoload 'make-window-not-ignored "ignore-window" t)
(autoload 'toggle-window-ignored "ignore-window" t)
(autoload 'gnome-toggle-skip-winlist "gnome-commands" t)
(autoload 'gnome-set-skip-winlist "gnome-commands" t)
(autoload 'gnome-clear-skip-winlist "gnome-commands" t)
(autoload 'gnome-toggle-skip-tasklist "gnome-commands" t)
(autoload 'gnome-set-skip-tasklist "gnome-commands" t)
(autoload 'gnome-clear-skip-tasklist "gnome-commands" t)
(autoload 'add-window-matcher "match-window")
(autoload 'remove-window-matcher "match-window")
(autoload 'gnome-logout "gnome-commands" t)
(autoload 'set-viewport-linear "viewport-linear")
(autoload 'set-window-viewport-linear "viewport-linear")
(autoload 'set-viewport-linear:1 "viewport-linear" t)
(autoload 'set-window-viewport-linear:1 "viewport-linear" t)
(autoload 'set-viewport-linear:2 "viewport-linear" t)
(autoload 'set-window-viewport-linear:2 "viewport-linear" t)
(autoload 'set-viewport-linear:3 "viewport-linear" t)
(autoload 'set-window-viewport-linear:3 "viewport-linear" t)
(autoload 'set-viewport-linear:4 "viewport-linear" t)
(autoload 'set-window-viewport-linear:4 "viewport-linear" t)
(autoload 'set-viewport-linear:5 "viewport-linear" t)
(autoload 'set-window-viewport-linear:5 "viewport-linear" t)
(autoload 'set-viewport-linear:6 "viewport-linear" t)
(autoload 'set-window-viewport-linear:6 "viewport-linear" t)
(autoload 'set-viewport-linear:7 "viewport-linear" t)
(autoload 'set-window-viewport-linear:7 "viewport-linear" t)
(autoload 'set-viewport-linear:8 "viewport-linear" t)
(autoload 'set-window-viewport-linear:8 "viewport-linear" t)
(autoload 'set-viewport-linear:9 "viewport-linear" t)
(autoload 'set-window-viewport-linear:9 "viewport-linear" t)
(autoload 'define-linear-viewport-commands "viewport-linear")
(autoload 'window-maximized-p "maximize")
(autoload 'window-maximized-horizontally-p "maximize")
(autoload 'window-maximized-vertically-p "maximize")
(autoload 'maximize-fill-window "maximize" t)
(autoload 'maximize-fill-window-vertically "maximize" t)
(autoload 'maximize-fill-window-horizontally "maximize" t)
(autoload 'maximize-fill-window-toggle "maximize" t)
(autoload 'maximize-fill-window-vertically-toggle "maximize" t)
(autoload 'maximize-fill-window-horizontally-toggle "maximize" t)
(autoload 'maximize-window "maximize" t)
(autoload 'unmaximize-window "maximize" t)
(autoload 'maximize-window-vertically "maximize" t)
(autoload 'maximize-window-horizontally "maximize" t)
(autoload 'maximize-window-toggle "maximize" t)
(autoload 'maximize-window-vertically-toggle "maximize" t)
(autoload 'maximize-window-horizontally-toggle "maximize" t)
(autoload 'toggle-single-window-mode "iconify" t)
(autoload 'toggle-window-never-focus "ignore-window" t)
(autoload 'raise-window-and-pass-through-click "raise-commands" t)
(autoload 'raise-and-pass-through-click-if-focused "raise-commands" t)
(autoload 'raise-or-pass-through-click "raise-commands" t)
(autoload 'move-cursor-left "move-cursor" t)
(autoload 'move-cursor-right "move-cursor" t)
(autoload 'move-cursor-up "move-cursor" t)
(autoload 'move-cursor-down "move-cursor" t)
(autoload 'move-cursor-left-fine "move-cursor" t)
(autoload 'move-cursor-right-fine "move-cursor" t)
(autoload 'move-cursor-up-fine "move-cursor" t)
(autoload 'move-cursor-down-fine "move-cursor" t)
(autoload 'decode-event "decode-events")
(autoload 'encode-event "decode-events")
(autoload 'string->keysym "decode-events")
(autoload 'modifier->keysyms "decode-events")
(autoload 'should-grab-button-event-p "decode-events")
(autoload 'size-window-add-row "size-window" t)
(autoload 'size-window-subtract-row "size-window" t)
(autoload 'size-window-add-column "size-window" t)
(autoload 'size-window-subtract-column "size-window" t)
(autoload 'grow-window-left "grow-pack" t)
(autoload 'grow-window-right "grow-pack" t)
(autoload 'grow-window-up "grow-pack" t)
(autoload 'grow-window-down "grow-pack" t)
(autoload 'pack-window-left "grow-pack" t)
(autoload 'pack-window-right "grow-pack" t)
(autoload 'pack-window-up "grow-pack" t)
(autoload 'pack-window-down "grow-pack" t)
(autoload 'prompt "prompt")
(autoload 'prompt-for-symbol "prompt")
(autoload 'prompt-for-command "prompt")
(autoload 'prompt-for-function "prompt")
(autoload 'prompt-for-variable "prompt")
(autoload 'prompt-for-file "prompt-extras")
(autoload 'prompt-for-directory "prompt-extras")
(autoload 'prompt-from-list "prompt-extras")
(autoload 'call-with-output-to-screen "with-output")
(autoload 'call-command-with-output-to-screen "with-output" t)
(autoload 'prompt-for-string "prompt-extras")
(autoload 'prompt-for-number "prompt-extras")
(autoload 'pwd-prompt "prompt-extras")
(autoload-macro 'lazy-bind-keys "keymap")
(autoload-macro 'with-output-to-screen "with-output")
(autoload 'prompt-for-window "prompt-wm")
(autoload 'prompt-for-workspace "prompt-wm")
(autoload 'select-workspace-interactively "prompt-wm" t)
(autoload 'draw-window-outline "window-outline")
(autoload 'erase-window-outline "window-outline")
(autoload 'wireframe-animator "anim-outline")
(autoload 'solid-animator "anim-outline")
(define-window-animator 'wireframe wireframe-animator)
(define-window-animator 'solid solid-animator)
(custom-add-required 'audio-events)
(defgroup audio "Sound")
(autoload 'play-sample "play-audio")
(autoload 'describe-symbol "describe" t)
(autoload 'apropos-function "describe" t)
(autoload 'apropos-variable "describe" t)
(autoload-macro 'define-command-to-screen "with-output")
(autoload 'describe-symbol-to-screen "describe" t)
(autoload 'apropos-function-to-screen "describe" t)
(autoload 'apropos-variable-to-screen "describe" t)
(autoload 'describe-key-to-screen "keymap" t)
(autoload 'help:show-faq "help" t)
(autoload 'help:show-programmer-manual "help" t)
(autoload 'help:show-news "help" t)
(autoload 'help:show-homepage "help" t)
(autoload 'gnome-www-page "gnome-commands" t)
(autoload 'gnome-help-browser "gnome-commands" t)
;;; ::autoload-end::
