.TH XScreenSaver 1 "17-Jun-99" "X Version 11"
.SH NAME
vidwhacker - grab images and apply random filters to them
.SH SYNOPSIS
.B vidwhacker
[\-display \fIhost:display.screen\fP] [\-root] [\-window] [\-verbose] [\-stdin] [\-stdout] [\-delay seconds]
.SH DESCRIPTION
The \fIvidwhacker\fP program grabs a image from the system's video input,
applies random image filters to it, and displays the result.  
The \fIvidwhacker\fP program does not terminate until killed.
It depends heavily on
.BR xv (1)
and the various PBM tools
(e.g.,
.BR ppmrelief (1).)
.SH OPTIONS
.I vidwhacker
accepts the following options:
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-window
Pop up a new window displaying the image.  When a new image has been fully
processed, destroy that window and pop up a new one.  This is the default.
.TP 8
.B \-verbose
Print diagnostics.
.TP 8
.B \-stdin
Instead of grabbing an image from the system's video input, read an image
to maniupulate from stdin.  This image must be in 
.TP 8
.B \-delay \fIseconds\fP
How long to sleep between images.  Default 3 seconds (the actual
elapsed time is significantly longer, due to processing time.)
.BR ppm (5)
format.  The program will still perform repeated random image 
transformations, but it will always use this one image as its starting point.
.TP 8
.B \-stdout
Instead of displaying the image on a window or on the root, write the new
image on stdout, and exit.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH BUGS
Grabbing video images is, of course, very system-dependent.  It works
on SGIs, and on Linux systems that have the
.BR qcam (1)
program.  If your system does things differently, you'll need to edit
the vidwhacker script (look for the \fIgrab()\fP function.)

It's slow.
.SH TO DO
It might be interesting to rewrite this to use
.BR gimp (1)
plugins instead of the pbm tools.  It probably wouldn't be any faster,
but there would be a wider variety of effects available.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR xv (1),
.BR ppmtogif (1),
.BR cjpeg (1)
.SH COPYRIGHT
Copyright \(co 1998, 1999 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, 18-Jan-98.
