/**
 *
 * $Id: uilparse.c,v 1.5 1997/09/17 16:25:14 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */ 

static char *rcsid = "$Id: uilparse.c,v 1.5 1997/09/17 16:25:14 miers Exp $";

/* Enable this for verbose lexing */
/* #define DEBUG */

#include <XmI/UilI.h>
#include <uil/UilSymGl.h>

#ifdef __STDC__
extern void uilmsg(Uil_parse_data *pd, int severity, char *fmt,...);
#else
extern void uilmsg();
#endif
extern int next_lexeme(Uil_parse_data *pd);

#ifndef HAVE_BASENAME
static char *
basename (const char *filename)
{
  char *p = strrchr (filename, '/');
  return p ? p + 1 : (char *) filename;
}
#endif
int
get_token(Uil_parse_data *pd)
{
    return 0;
}

/* for lookahead */
void
unget_token(Uil_parse_data *pd)
{
}

static Uil_status_type
parse_module_hdr(Uil_parse_data *pd, sym_root_entry_type *root)
{
}

static Uil_status_type
parse_sections(Uil_parse_data *pd, sym_root_entry_type *root)
{
}

static Uil_status_type
dump_uid(Uil_parse_data *pd, sym_root_entry_type *root)
{
}

Uil_status_type
parse_module(Uil_parse_data *pd)
{
    sym_root_entry_type *root;
    sym_entry_type *e;    
    int ltype, ret;
    extern char *basename();
    
    root = (sym_root_entry_type *)XtCalloc(1, sizeof(sym_root_entry_type));

    ltype = next_lexeme(pd);
    /* first token MUST be "module" */
    if (ltype != KEYWORD)
    {
	uilmsg(pd, Uil_k_severe_status,
	       "Missing module keyword: check module syntax.\n");

	return Uil_k_severe_status;
    }

    pd->desc->parse_tree_root = (char *)root;

    strncpy(root->full_file_name, pd->command->source_file, 255);
    strncpy(root->file_name, basename(pd->command->source_file), 255);

    root->module_hdr =
        (sym_module_entry_type *)XtCalloc(1, sizeof(sym_module_entry_type));

    if ((ret = parse_module_hdr(pd, root)) != Uil_k_success_status)
    {
	return ret;
    }

    if ((ret = parse_sections(pd, root)) != Uil_k_success_status)
    {
	return ret;
    }

    dump_uid(pd, root);
}

