/*

  procinfo.h

  Date:        1995-04-15 23:54:06
  Last Change: 1999-05-15 23:03:38

  Copyright (C) 1995-1998 Sander van Malssen <svm@kozmix.ow.nl>

  This software is released under the GNU Public Licence. See the file
  `COPYING' for details. Since you're probably running Linux I'm sure
  your hard disk is already infested with copies of this file, but if
  not, mail me and I'll send you one.

  $Id: procinfo.h,v 1.20 1999/05/15 21:26:05 svm Exp $

*/

#ifndef _PROCINFO_H
#define _PROCINFO_H

#define VERSION		"17 (1999-05-16)"

#ifndef PROC_DIR
#define PROC_DIR	"/proc/"	/* Needs the trailing slash. */
#endif

#define ISSTR(s)	(!strcmp(s, type))

#if 0
#define VAL		(strtoul(strtok(NULL, "\t "), NULL, 10))
#else
static inline unsigned long find_val(void)
{
    char *cp;

    cp = strtok(NULL, "\t ");
    if (!cp)
	return 0L;
    return (strtoul (cp, NULL, 10));
}
#define VAL	find_val()
#endif

#define DIFF(x)		(show_diff \
			 ? (unsigned long) (((new.x)-(old.x))/rate) \
			 : (new.x))

#define IS_ODD(x)	(x & 1)

#undef  MAX
#define MAX(a,b)	((a) > (b) ? (a) : (b))

#define CDRV		0
#define BDRV		1
#ifndef MAX_CHRDEV
#define MAX_CHRDEV	32
#endif
#ifndef MAX_BLKDEV
#define MAX_BLKDEV	32
#endif
#define MAX_DEV		MAX(MAX_CHRDEV, MAX_BLKDEV)

struct info
{
    unsigned long uptime;
    long m_to, m_us, m_fr, m_sh, m_bu, m_ca;
    long s_to, s_us, s_fr;
    unsigned long cpu_user, cpu_nice, cpu_sys, cpu_idle;
    unsigned long disk[4];
    unsigned long disk_r[4];
    unsigned long disk_w[4];
    unsigned long pgin, pgout, swin, swout;
    unsigned long *intr;	/* Phew. That's better. */
    unsigned long old_intr;
    unsigned long ctxt;
    unsigned long syscalls;
};

/* Prototypes. */

void window_init (void);
void tstp (int i);
void cont (int i);
void winsz (int i);
void quit (int i);
void set_echo (int i);

void fatal (const char *s,...);
void *my_xcalloc (size_t n, size_t s);
void init_terminal_data (void);
char *my_tgets (char *te);

char *make_version (FILE *verionfp);
FILE *myfopen (char *name);
char *hms (unsigned long t);
char *perc (unsigned long i, long t, int cpus);

#endif /* _PROCINFO_H */

/*
   Local variables:
   rm-trailing-spaces: t
   End:
 */
