/* symbols_dtlk.h - header file for speakups DoubleTalk driver. */
#define VERSION_DTLK 07
#define NUM_STATIC_DTLK 7
#define NUM_XTEND_DTLK 3
#define NUM_ALIAS_DTLK 17

/* note the trailing comma... */
#define DEFAULT_STATIC_DTLK \
	"\x18", "\x01\x35\x30p", "\x01\x35s", "\x01\x35x", "\x01\x35v",\
	"\x01\x38\x35p", "\x01\x35\x30p",

/* if empty, should *not* have a trailing comma... */
#define DEFAULT_XTEND_DTLK \
	"\x01\x30o","\x01\x35\x66","\x01\x37\x62",

/* required settings and functionality */
#define STATIC_STR_DTLK \
	{ "#flush", "\x18", "_", (BUILDER | HARD_DIRECT | USE_RANGE | NO_USER), "0,99" },\
	{ "pitch", "50", "\x01_p", (NUMERIC | HARD_DIRECT | USE_RANGE), "0,99" }, \
	{ "rate", "5", "\x01_s", (NUMERIC | HARD_DIRECT | USE_RANGE), "0,9" }, \
	{ "tone", "5", "\x01_x", (NUMERIC | HARD_DIRECT | USE_RANGE), "0,9" }, \
	{ "volume", "5", "\x01_v", (NUMERIC | HARD_DIRECT | USE_RANGE), "0,9" }, \
	{ "caps_start", "\x01+35p", "_", 0, { '*',-1 } }, \
	{ "caps_stop", "\x01-35p", "_", 0, { '*',-1 } }

/* additional settings and functionality */
#define XTEND_STR_DTLK \
	{ "voice", "0", "\x01_o", (NUMERIC | HARD_DIRECT | USE_RANGE), "0,4"}, \
	{ "ffreq", "5", "\x01_f", (NUMERIC | HARD_DIRECT | USE_RANGE), "0,9"}, \
	{ "punct", "7", "\x01_b", (NUMERIC | HARD_DIRECT | USE_RANGE), "0,15"}

#define ALIAS_STR_DTLK \
	{ "artic", "", "\x01_a", NUMERIC | USE_RANGE , "0,9"}, \
	{ "punct", "", "\x01_b", NUMERIC | USE_RANGE , "0,15"}, \
	{ "cmode", "", "\x01_c", ALLOW_BLANK | NUMERIC | USE_RANGE , "0,31"}, \
	{ "phoneme", "", "\x01d", ALLOW_BLANK , { -1 } }, \
	{ "expr", "", "\x01_e", ALLOW_BLANK | NUMERIC | USE_RANGE , "0,9"}, \
	{ "ffreq", "", "\x01_f", ALLOW_BLANK | NUMERIC | USE_RANGE , "0,9"}, \
	{ "protocol", "", "\x01_g", NUMERIC | USE_RANGE , "0,63"}, \
	{ "index", "", "\x01_i", NUMERIC | USE_RANGE , "0,99"}, \
	{ "monotone", "", "\x01m", ALLOW_BLANK, { -1 } }, \
	{ "voice", "", "\x01_o", NUMERIC | USE_RANGE , "0,4"}, \
	{ "pitch", "", "\x01_p", NUMERIC | USE_RANGE , "0,99"}, \
	{ "reverb", "", "\x01_r", NUMERIC | USE_RANGE , "0,9"}, \
	{ "rate", "", "\x01_s", NUMERIC | USE_RANGE , "0,9"}, \
	{ "tmode", "", "\x01_t", ALLOW_BLANK | NUMERIC | USE_RANGE , "0,15"}, \
	{ "volume", "", "\x01_v", NUMERIC | USE_RANGE , "0,9"}, \
	{ "tone", "", "\x01_x", NUMERIC | USE_RANGE , "0,2"}, \
	{ "timeout", "", "\x01_y", NUMERIC | USE_RANGE , "0,15"}
