Summary: System V initialization program
Name: SysVinit
%define version 2.78
Version: %{version}
Release: 2
Copyright: GPL
Group: Daemons
Source: ftp://ftp.cistron.nl/pub/people/miquels/software/sysvinit-2.78.tar.gz
Buildroot: /var/tmp/init-root
Summary(de): System V-Intialisierungsprogramm
Summary(fr): Programme d'initialisation Sys V.
Summary(tr): System V balatma program

%description
SysVinit is the first program started by the Linux kernel when the system
boots, controlling the startup, running, and shutdown of all other
programs.

%description -l de
SysVinit ist das erste Programm, das beim Systemstart vom Linux-Kernel 
gestartet wird. Es steuert das Starten, Ausfhren und Beenden aller
anderen Programme.

%description -l fr
SysVinit est le premier programme excut par le noyau de Linux lorsque le
systme dmarre, il contrle le lancement, l'excution et l'arrt de tous
les autres programmes.

%description -l tr
SysVinit, sistem alrken Linux ekirdei tarafndan altrlan ilk
programdr. Dier programlarn balamalarn, almalarn ve sonlanmalarn
salar/denetler.

%changelog
* Fri Oct  19 1999 Miquel van Smoorenburg <miquels@cistron.nl>
- upgraded to 2.78

* Fri Jun  4 1999 Miquel van Smoorenburg <miquels@cistron.nl>
- upgraded to 2.77

* Tue Nov  3 1998 Miquel van Smoorenburg <miquels@cistron.nl>
- upgraded to 2.76
- no redhat specific patches needed anymore.
- remove inclusion of out-of-date documentation
- I have no idea whether this .spec file will actually produce an RPM ;)

* Thu May 07 1998 Prospector System <bugs@redhat.com>

- translations modified for de, fr, tr

* Wed Apr 08 1998 Cristian Gafton <gafton@redhat.com>
- upgraded to 2.74
- fixed the package source url... (yeah, it was wrong !)

* Wed Oct 1 1997 Cristian Gafton <gafton@redhat.com>
- fixed the MD5 check in sulogin (128 hash bits encoded with base64 gives
  22 bytes, not 24...). Fix in -md5.patch

* Thu Sep 11 1997 Christian 'Dr. Disk' Hechelmann <drdisk@ds9.au.s.shuttle.de>
- /etc/initrunlvl gets linked to /tmp/init-root/var/run/initrunlvl which is
  just plain wrong..
- /usr/bin/utmpdump was missing in the files section, although it was
  explicitly patched into PROGS.
- added attr's to the files section.
- various small fixes.

* Tue Jun 17 1997 Erik Troan <ewt@redhat.com>
- updated to 2.71
- built against glibc 2.0.4

* Fri Feb 07 1997 Michael K. Johnson <johnsonm@redhat.com>
- Added sulogin.8 man page to file list.

%prep
%setup -n sysvinit-%{version}

%build
make -C src

%install
rm -rf $RPM_BUILD_ROOT
for I in sbin usr/bin usr/share/man/man{1,3,5,8} etc var/run dev; do
	mkdir -p $RPM_BUILD_ROOT/$I
done
make -C src ROOT=$RPM_BUILD_ROOT install
ln -sf ../var/run/initrunlvl $RPM_BUILD_ROOT/etc

# If this already exists, just do nothing (the ||: part)
mknod --mode=0600 $RPM_BUILD_ROOT/dev/initctl p ||:
chgrp tty $RPM_BUILD_ROOT/usr/bin/wall
chmod g+s $RPM_BUILD_ROOT/usr/bin/wall

%files
%doc doc/changelog
%doc doc/sysvinit-%{version}.lsm contrib/start-stop-daemon.* 
%attr(-,root,root) /sbin/halt
%attr(-,root,root) /sbin/init
%attr(-,root,root) /sbin/killall5
%attr(-,root,root) /sbin/sulogin
%attr(-,root,root) /sbin/runlevel
%attr(-,root,root) /sbin/shutdown
%attr(-,root,root) /sbin/reboot
%attr(-,root,root) /sbin/telinit
%attr(-,root,root) /bin/pidof
%attr(-,root,root) /usr/bin/mesg
%attr(-,root,root) /usr/bin/last
%attr(-,root,root) /usr/bin/lastb
%attr(-,root,root) /usr/bin/utmpdump
%attr(-,root,tty)  /usr/bin/wall
%attr(-,root,root) /usr/share/man/*/*
%attr(-,root,root) /etc/initrunlvl
%attr(-,root,root) /dev/initctl
