.\" t
.\" @(#)afterstep.1		02/07/00
.TH afterstep 1.8 "Feb 7 2000" afterstep
.UC
.SH NAME
\fBafterstep\fP \- X11 window manager

.SH SYNOPSIS
\fBafterstep\fP [\-d \fIdisplayname\fP] [\--debug] [\-f \fIsteprc_file\fP]
[\-s] [\-v | \--version] [\-c | \--config]

.SH DESCRIPTION
\fBafterstep\fP is an X11 window manager with a NEXTSTEP look and feel but
which attempts to go beyond this to provide new features and flexiblilty.

.SH OPTIONS
.IP "\-d \fI[host]:display[.screen]\fP"
Manage the display \fI[host]:display[.screen]\fP instead of the name obtained
from the environment variable $DISPLAY. $DISPLAY may be unix:0.0, :0.0 or :0,
which doesn't work too well when passed through rsh to another machine, so
$HOSTDISPLAY will also be set, and will use a network-ready description
of the display.  Unfortunately, $HOSTDISPLAY will use the TCP/IP transport
protocol, even for a local connection, so $DISPLAY should be used for 
local connections, as it may use unix-domain sockets, which are faster.

.IP "\--debug"
Puts X transactions in synchronous mode, which dramatically slows things
down, but guarantees that \fBafterstep's\fP internal error messages are
correct.

.IP "\-f \fIstreprc_file\fP"
Causes \fBafterstep\fP to use the old \fIstreprc_file\fP format instead of
the default \fI/usr/local/share/afterstep\fP or user specific
\fI~/GNUstep/Library/AfterStep\fP directory, where the window manager
configuration files are located. \fBafterstep\fP will set both the $DISPLAY
and $HOSTDISPLAY environment variables which will be inherited by all of its 
children; refer to the \-d \fIhost:display.screen\fP to override these.

.IP "\-s"
This will run \fBafterstep\fP on only the specified screen of a multi-screen
display.  Normally, \fBafterstep\fP will attempt to manage all screens of a
multi-screen display and treat each screen independantly.  The "specified
screen" is the one provided by the $DISPLAY environment variable, or
provided through the \fI-d displayname\fP option.  Restarts as well as Quits
of \fBafterstep\fP need to be performed separately on each screen.  The use
of \fIEdgeScroll 0 0\fP is strongly recommended for multi-screen displays.

.IP "\-v | \--version"
Prints out the version number of \fBafterstep\fP.

.IP "\-c | \--config"
Prints out the directory configuration specified to \fBafterstep\fP at
compile time.

.SH INITIALIZATION
During  initialization, \fBafterstep\fP will search for the configuration
files which define the look, feel, and functionality.  The system default
configuration files are located under \fI/usr/local/share/afterstep\fP; but
if copied (and edited to suit a user's needs) to
\fI~/GNUstep/Library/AfterStep\fP, these will override the global share
files.  If the basic "working" configuration files are not found in either
\fI/usr/local/share/afterstep/non-configurable\fP or
\fI~/GNUstep/Library/AfterStep/non-configurable\fP, afterstep will exit. 
If these "working" configuration files have been corrupted or are from a
previous incompatible version, afterstep will exit. Also realize that a
system administrator or software packager might have these installed in
alternate locations, finding them should not be hard.

.SH INVOCATION
\fBafterstep\fP is typically invoked from users' \fI~/.xinitrc\fP as
"exec afterstep", located as the last line in this file.  xdm or asdm et al
use the \fI~/.xsession\fP file. 

.SH ANATOMY OF THE DESKTOP
The default AfterStep starts with the module \fBWinList(1)\fP running as 
a dark grey bar originating from the upper left corner of the screen.  
This is to function in a manner similar to the Windows(R) StartBar, where 
windows appear when opened and can be Maximized from. The \fBPager(1)\fP
is also started in the upper right hand corner. This module controls which
desktop and or view is visable as well as handles the graphics picked for
the root background. Along the lower right hand of the screen and moving
upwards is the module \fBWharf(1)\fP; this acts as a button bar in or from 
which applications can be started. A default \fIstartmenu\fP was also 
provided which was created from the default \fIstart/\fP directory 
structure. Clicking with the left mouse button on the root background will 
bring this menu up, from which applications can be launched. \fBafterstep\fP 
itself creates the decorations for windows. The top decoration is called 
the TitleBar; it contains various window action controlling buttons along 
with the window's title. The lower decoration is called the Handles (or low 
bar or BottomBar); it contains the window resizing handles.

.SH MODULES
A Module is a separate program, which runs as a separate unix process,
but transmits commands for \fBafterstep\fP to execute.  These Modules get
many kinds of window information from \fBafterstep\fP, but typically use
their own configuration files. Users can write their own modules to do
any weird or bizarre manipulations, without affecting the integrity of
\fBafterstep\fP itself.

Modules are documented in their own man pages.

.SH ENVIRONMENT VARIABLES

.IP $SCREEN_GAMMA
Value of this env variable is used to gamma-correct PNG and JPEG images,
when loading them from files. Default value of 1.0 is used if this 
variable is not defined - which means no correction at all. Try using 
2.2 for some older monitors to get brighter images.

.SH CONFIGURATION DIRECTORIES
There are several files within numerous directories which control and or
provide configurations for \fBafterstep\fP.

The \fIbackgrounds/\fP directory is where \fBafterstep\fP looks for
root background images for insertion into the menu, so that picking one of
these images causes \fBPager(1)\fP to load the image into the root 
background. The \fBPager(1)\fP must be running to utilize the menu 
\fIPictures\fP entry. Valid images are currently XPM, JPEG, and PNG; 
provided the associated development libraries were located during compile 
and libraries are available during runtime.

The \fIdesktop/\fP directory contains the \fIbuttons/\fP, \fIicons/\fP, and
\fIsounds/\fP directories.

The \fIdesktop/buttons/\fP directory is the location \fBafterstep\fP looks
for the bitmaps or pixmaps to be used for the \fITitleButtons\fP.  These
are the "icons" which control options for a window, e.g. \fIshaded\fP, 
\fIiconified\fP, and \fIquit\fP to name a few.  Pixmaps for the buttons are
defined in the \fIlook.name\fP file and the actions taken are described in
the \fIfeel.name\fP file.

The \fIdesktop/icons/\fP directory contains the icons which \fBafterstep\fP 
and its modules use. It is divided into three subdirectories, \fI8bpp/\fP, 
\fI16bpp/\fP, and \fIcommon/\fP. With the default configuration, \fI8bpp/\fP 
is used only when in 8bpp, \fI16bpp/\fP is used only when in 15bpp or 
better, and \fIcommon/\fP is always used.

The \fIdesktop/sounds/\fP directory contains the sounds used by 
\fBafterstep\fP and its modules. See the \fBAudio(1)\fP man page for more 
details on sound in AfterStep.

The \fIfeels/\fP directory contains configuration files used to customize 
the feel of AfterStep. Any feel files created should be placed within this
directory, and upon the next rebuild of the \fIstartmenu\fP, they will
appear under DeskTop->Feels in the menu. See the \fIfeel.name\fP section
below for more details.

The \fIlooks/\fP directory contains configuration files used to customize 
the look of AfterStep.  Any look files created should be placed within this
directory, and upon the next rebuild of the \fIstartmenu\fP, they will
appear under DeskTop->Looks in the menu.  See the \fIlook.name\fP section
below for more details.

The \fInon-configurable/\fP directory contains "working" copies of your
configuration files; these are the \fBPager(1)\fP's image files, the current
\fIfeel.name\fP, \fIlook.name\fP and \fIstartmenu\fP files. Editing these
files is a futile attempt unless you know that these files get overwritten;
ergo the name "non-configurable".

The \fIstart/\fP directory contains the start menu directory tree, which 
is used to build the popup desktop menu (startmenu). See the \fIstartmenu\fP
section below for more details.

Also refer to the FILES section near the end of this man page.

.SH CONFIGURATION OPTIONS - \fIautoexec\fP
This is the file that initializes various Modules or programs when
\fBafterstep\fP is either started or restared.  Each set is handled within
Function stanzas.  During the invocation of \fBafterstep\fP:
.nf
	Function "InitFunction"
.sp
or during a restart called via the menu or other button:
	Function "RestartFunction"
.fi
Refer to the BUILT-IN COMMANDS/FUNCTIONS and EXAMPLES sections below.

.SH CONFIGURATION OPTIONS - \fIbase.#bpp\fP
There should exist one base.#bpp configuration file for each colordepth.
The # can be any of 8, 15, 16, 24, and 32; which are the colordepths
available by most Xservers.

.IP "ModulePath \fIpath[:path]\fP"
Specifies the \fIpaths\fP to locate the \fIModules\fP in.

.IP "IconPath \fIpath[:path]\fP"
Specifies the \fIpaths\fP to locate the bitmaps in, typically used only if
XPM, JPEG, or PNG images aren't available. Valid bitmaps are standard X11
XBM's.

.IP "PixmapPath \fIpath[:path]\fP"
Specifies the \fIpaths\fP to locate the pixmaps in.  Valid pixmaps are
currently XPM, JPEG, and PNG.

.IP "*ScriptPath \fIpath[:path]\fP"
Specifies the \fIpaths\fP to locate the scripts for use with the
\fIScript\fP Module.

Refer to the \fBPager(1)\fP man page for the other settings.

.SH CONFIGURATION OPTIONS - \fIcompatibility\fP
This file is only used with the \fI\-f steprc_file\fP option.  It defines a
few needed configuration options which were not in the old .steprc files.

.IP "PixmapPath \fIpath[:path]\fP"
Specifies the \fIpaths\fP to locate the pixmaps in.  Valid pixmaps are
currently XPM, JPEG, and PNG.

.IP "TitleButton \fIbutton unclicked_image clicked_image\fP"
\fIbutton\fP defines the button location number from 1 to 10 in the following
layout: [1] [3] [5] [7] [9] (title) [10] [8] [6] [4] [2].

\fIunclicked_image\fP is the bitmap or pixmap to be used during the static
state of the associated buton location.

\fIclicked_image\fP is the bitmap or pixmap to be used during a clicked
state of the associated button location.

.IP "DrawMenuBorders \fI0|1|2\fP"
Specifies the look of the (start)menu.  Using \fI0\fP will draw the
menu with no border on either the menu \fIlabel\fP or menu \fIitem\fP
portions.  Using \fI1\fP will draw a border around each menu \fIlabel\fP and
around the menu \fIitem\fP.  Using \fI2\fP will drawn a border around the
menu \fIlabel\fP and the entire menu \fIitem\fP list.  The border colors are
calculated from the \fIBackColor\fP under \fIMyStyle menu_item\fP of the
\fIlook.name\fP. The "hilight" (top & left) color is one half lighter than
the \fIBackColor color\fP and the "shadow" (bottom & right) is one half
darker than the \fIBackColor color\fP.  If the \fIBackColor color\fP is
black, the color grey is used.

.SH CONFIGURATION OPTIONS - \fIdatabase\fP
This file contains window properties for application windows which controls
their "behavior" within \fBafterstep\fP.

.IP "Style \fI""WM_NAME"" option[s]\fP"
The \fI"WM_NAME"\fP can the window's name, class or resource string.  It can 
also contain wildcards such as "*" or "?", which are matched in the usual
UNIX filename manner. Using the standard X11 \fBxprop(1)\fP command at a 
command prompt or the \fIWindow Properties\fP menu item entry under 
\fIDesktop\fP menu entry will return this (and other) property.
.RS
The \fIoption[s]\fP is a comma separated list containing all or some of
the following keywords.  If conflicting style options are specified, the
last one will be used:

.IP "FocusStyle [\fIstyle\fP]"
Specifies a MyStyle to be used for this window when it has the keyboard 
focus.  If \fIstyle\fP is unspecified, the default focus style will be 
used instead (see \fIFWindowStyle\fP, below).

.IP "StickyStyle \fIstyle\fP"
Specifies a MyStyle to be used for this window when it does not have the 
keyboard focus, and is sticky.  If \fIstyle\fP is unspecified, the default 
sticky style will be used instead (see \fISWindowStyle\fP, below).

.IP "UnfocusStyle \fIstyle\fP"
Specifies a MyStyle to be used for this window when it does not have the 
keyboard focus, and is not sticky.  If \fIstyle\fP is unspecified, the 
default unfocus style will be used instead (see \fIUWindowStyle\fP, below).

.IP "\fIAvoidCover\fP | \fIAllowCover\fP"
Specifies that other windows should not be allowed to cover the app window. 
Prevents other windows from moving in front of (or behind) the app window. 
If \fISmartPlacement\fP is specified in the \fIfeel\fP file, windows will 
not be allowed to automatically place themselves over the app window, if 
possible. \fIAllowCover\fP turns off \fIAvoidCover\fP. The default is 
\fIAllowCover\fP.

.IP "\fIBorderWidth width\fP"
Specifying this in conjunction with \fINoHandles\fP, sets the border width
of a window to be \fIwidth\fP. A \fIwidth\fP of \fI0\fP causes no border.
 This option has no affect if not used with \fINoHandles\fP.  The default
is \fI1\fP implicitly for all windows.

.\" .IP "\fIHandleWidth width\fP"
.\" Specifies the \fIwidth\fP of the resize handles on the
.\" The default \fIwidth\fP is 8 pixels.

.IP "\fINoFocus\fP | \fIFocus\fP"
This will set the window to refuse any input focus.  The default is
\fIFocus\fP implicitly for all windows.

.IP "\fIIcon [/path/]name.[xpm|jpg|png]\fP | \fINoIcon\fP"
Specifies the [/path/]name.[xpm|jpg|png] to use when iconified, overriding
any icon the app itself might provide.  \fINoIcon\fP turns this off for the
specified app and the icon will simply disappear when the app is iconified.
Refer to the EXAMPLES below for a method to make all icons disappear. The
default is to use the app's supplied icon or the icon specified with the
WM_NAME of "Unknown" or "*".

.IP "\fINoTitle\fP | \fITitle\fP"
Specifies that \fIafterstep\fP should not put a title bar decoration on the 
app.  The default is \fITitle\fP implicitly for all windows.

.IP "\fINoHandles\fP | \fIHandles\fP"
Specifies that the app window will not display the "low bar" decoration. 
This also removes the ability to resize windows with the resize handles on
the "low bar" ends.  The default is \fIHandles\fP implicitly for all
windows.

.IP "\fIWindowListSkip\fP | \fIWindowListHit\fP"
Specifies that the app name will be omitted from both the internal Window
List (default click of mouse buttons 2 & 3 on the root window), and the
\fBWinList(1)\fP module bar.  The default is \fIWindowListHit\fP implicitly
for all windows.

.IP "\fICirculateSkip\fP | \fICirculateHit\fP"
Causes windows to be skipped over when the ChangeWindowUp, ChangeWindowDown or
Warp (also called alt-tabbing) functions are invoked.  The default is
\fICirculateHit\fP implicitly for all windows.

.IP "\fIStaysOnTop\fP | \fIStaysPut\fP | \fIStaysOnBack\fP"
\fIStaysOnTop\fP causes the window to always try to stay above all other
open windows.  If the window was explicitly lowered, it will loose this
charateristic until explicitly told to stay on top again by calling the
\fIBuit-in Function\fP \fIPutOnTop\fP. \fIStaysOnBack\fP causes a window to
always try to remain behind all open windows. The default is \fIStaysPut\fP
implicitly for all windows, which doesn't specify any specific stacking
order of open windows.

\fINOTE: deprecated, use Layer instead.\fP

.IP "Layer \fIlayer\fP"
Specifies what layer this window should be in.  \fIlayer\fP may be any 
integer (positive, negative, or zero).  Windows are grouped according to 
their layer, and may not be moved out of their layer.  Windows in higher 
layers will be above windows in lower layers.  By default, windows are 
placed in layer 0.  \fIStaysOnBack\fP corresponds to \fILayer -1\fP, and 
\fIStaysOnTop\fP corresponds to \fILayer 1\fP.

.IP "\fISticky\fP | \fISlippery\fP"
Causes the app window to stick to it's location for each desktop that
becomes current, allowing the window to "follow" while changings desks/
views.  The default is \fISlippery\fP implicitly for all windows.

.IP "\fIStartIconic\fP | \fIStartNormal\fP" 
Causes the app to start and immediately iconify itself to the \fIIconBox\fP.
The default is \fIStartNormal\fP implicitly for all windows.

.IP "\fIStartsOnDesk number\fP | \fIStartsAnyWhere\fP"
Causes the app window to start on the specified \fIdesk\fP number. If
\fISmartPlacement\fP is used in the \fIfeel.name\fP file, the window will
appear on the specified \fIdesk\fP number, but will require interaction to
place it; unless it was called with geometry settings. Specific
\fIViewports\fP are also allowed, refer to them below.  The default is
\fIStartsAnyWhere\fP implicitly for all windows.

.IP "\fIVerticalTitle\fP | \fIHorizontalTitle\fP"
Causes the window titlebar to be placed vertically along the left side of 
the window, instead of horizontally across the top.

.IP "\fIViewportX number\fP"
Specifies the coordinate along the x-axis that \fIafterstep\fP should
place a window.  This allows opening a window on a particular desk and view.
\fInumber\fP is measured in pixels and the screen resolution is the outline
of a desk's particular boundaries; where it will then place it upon another
desk or view.  Combined with \fIViewportY\fP, a window can be given geometry
by \fIafterstep\fP and be placed in the desired desktop and view.

.IP "\fIViewportY number\fP"
Specifies the coordinate along the y-axis that \fIafterstep\fP should
place a window.  This allows opening a window on a particular desk and view.
\fInumber\fP is measured in pixels and the screen resolution is the outline
of a desk's particular boundaries; where it will then place it upon another
desk or view.  Combined with \fIViewportX\fP, a window can be given geometry
by \fIafterstep\fP and be placed in the desired desktop and view.

.IP "\fINoButton number\fP | \fIButton number\fP
Specifing a \fInumber\fP to each use of \fINoButton\fP will cause that
buttons number to not be displayed in the title bar. See \fITitleButtons\fP
above for the \fInumber\fP and their location on the title bar.  The default
is to display all buttons defined in the \fIlook.name\fP file if the
following conditions are met: there is a valid bitmap or pixmap specified
for the button in the \fIlook.name\fP file; and the button has not been
forced not to display by the use of Motif WM hints specified (set on) in
the \fIfeel.name\fP file. The default is \fIButton number\fP implicitly for
all windows.

.IP "\fISuppressIcons\fP"
Specifies that no icon should be shown for any window being iconified,
similar to NoIcon.
.RE

.SH CONFIGURATION OPTIONS - \fIfeel.name\fP

.IP "\fIAutoReverse 0|1|2\fP"
Specifies the window Warping (also called alt-tabbing) style. \fI0\fP (the
default) causes switching among windows in one direction.  \fI1\fP causes a 
closed loop switching \- #1->#2->#3->#4 then #4->#3->#2->#1. \fI2\fP causes 
an open loop switching \- #1->#2->#3->#4 then #4->#1->#2->#3 etc.

.IP "\fIAutoTabThroughDesks\fP"
In conjunction with \fIAutoReverse\fP, this will Warp (alt-tab) through
windows on all desks.

.IP "\fIAutoRaise delay\fP"
Specifies the \fIdelay\fP in milliseconds of focus a window must attain
before being raised.

.IP "\fIMWMFunctionHints\fP"
Adds support for Motif window manager function hints.

.IP "\fIMWMDecorHints\fP"
Adds support for Motif window manager decoration hints.

.IP "\fIMWMHintOverride\fP"
Allows Motif window manager function hints to be overridden by 
\fBafterstep\fP window styles.

.IP "\fIXzap number\fP"
Specifies the horizontal offset of the cursor when warping. This offset 
is relative to the upper-left corner of the window being warped to. 

.IP "\fIYzap number\fP"
Specifies the vertical offset of the cursor when warping. This offset is 
relative to the upper-left corner of the window being warped to.

.IP "\fIKeepIconWindows\fP"
Specifies that applications should be allowed to specify their own icon 
windows.

.IP "\fITitlebarnopush\fP"
Specifying this will disable the illusion that the title bars are being
pressed when clicked upon.  Without this option, clicking the title bar will
cause it to invert its colors, making it appear to be a 3D button being
pressed in.

.IP "\fIClickToFocus\fP"
Specifies that the keyboard input (aka focus) stays with one window
until a new window's TitleBar is clicked on, or gains focus through
Warping or de-iconification.  

.IP "\fIClickToRaise\fP \fIbuttons\fP"
Specifies that windows should be raised when a button is clicked in the 
titlebar, handle (low bar), or application area.  \fIbuttons\fP specifies 
the list of buttons which triggers this function.

In \fIAutoRaise\fP mode  this will simply raise the window if the click
is before the delay  specified in \fIAutoRaise\fP.  In 
\fIClickToFocus\fP mode, this will raise the window and give it focus.  

.IP "\fISloppyFocus\fP"
Specifies that windows retain focus until the mouse moves to another window,
or Warping causes another window to gain focus.

\fISloppyFocus\fP has no effect if \fIClickToFocus\fP is also specified.

.IP "\fIStubbornIcons\fP"
Specifies that icons should uniconify to their original desk. By default, 
icons uniconify to the current desk.

.IP "\fIStubbornPlacement\fP"
Specifies that new windows should avoid being placed over icons. 

.\" \fIStubbornIconPlacement\fP has no effect unless \fISmartPlacement\fP is 
.\" also specified. ?

.IP "\fIStubbornIconPlacement\fP"
Specifies that icons should avoid being hidden behind windows placed over the
\fIIconBox\fP by moving themselves around (dancing icons). 

.IP "\fIIconTitle\fP"
Specifies that a title should be displayed under an iconified app.  The
colors used are the \fIForeColor\fP and \fIBackColor\fP of the
\fIButtonTitleFocus\fP in the \fIlook.name\fP file. Note: less space
is left for the app's icon, so it will be resized acordingly.  Only a
portion of the icon title will be displayed until the icon gains focus, and
then the title "box" will expand to reveal the window's entire name.

.IP "\fIStickyIcons\fP"
Specifies that icons should stick to the screen's glass and follow it from
desk/view to desk/view.

.IP "\fICirculateSkipIcons\fP"
Specifies that all icons should be skipped when Warping (alt-tabbing)
between windows.

.IP "\fICenterOnCirculate\fP"
Specifies that when Warping (alt-tabbing), the desktop page containing the
window to which the pointer is moving will be automatically selected and
\fIafterstep\fP will attempt to center the target window in the desktop
viewport, rather than just flipping to the desktop the window resides in.

.IP "\fIClickTime delay\fP"
Specifies that \fBafterstep\fP should consider two mouse clicks made within 
\fIdelay\fP milliseconds to be a double mouse click, and not two single 
mouse clicks. The default delay is 150 milliseconds.

.IP "\fIOpaqueMove %\fP"
Specifies the maximum size window where opaque window movement should be
used.  \fI%\fP is percent of the total screen area.  Set to \fI0\fP, all
windows will be moved using the traditional rubber-band outline.  Set to
\fI100\fP, all windows will be move as solid windows. The default is
\fI5\fP which allows small windows to be moved in an opaque manner, but
large windows to be moved as rubber-bands.  Using this option with
large values can slow down video response on slower systems.

.IP "\fIOpaqueResize %\fP"
Specifies the maximum size window where opaque resizing should be used.
\fI%\fP is percent of the total screen area.  Set to \fI0\fP, all
windows will be resized using the traditional rubber-band outline.  Set to
\fI100\fP, all windows will be resized as solid windows. The default is
\fI5\fP which allows small windows to be resized in an opaque manner, but
large windows to be resized as rubber-bands.  Using this option with
large values can slow down video response on slower systems.

.IP "\fIEdgeScroll horizontal vertical\fP"
Specifies the percentage of a page to scroll when the cursor hits the edge
of a page. Setting \fIEdgeScroll\fP to \fI0 0\fP will disable scrolling.  
Setting this option to \fI100 100\fP will scroll whole pages. Set to 
\fI1000 1000\fP, scrolling will wrap around at the edge of the desktop. 
Both \fIhorizontal\fP and \fIvertical\fP should be positive numbers.

.IP "\fIEdgeResistance delay pixels\fP"
Specifies how hard it should be to change views within a desktop by moving
the mouse over the edge of the screen, and how hard it should be to move a
window over the edge of a screen.

The \fIdelay\fP in milliseconds, defines how long the pointer must spend at
the screen edge before that view becomes current.  This is useful in
conjunction with \fIEdgeScroll 100 100\fP, so the views don't get switched
accidently.

The \fIpixels\fP defines how far over the edge a window must "appear" to
move before it actually moves partially off the screen.

Note that with \fIEdgeScroll 0 0\fP, it is still possible to move or resize
windows across the edge of the current screen. By setting the \fIpixels\fP 
parameter of \fIEdgeResistance\fP to 10000, this type of motion is 
impossible. However, with \fIEdgeResistances\fP less than 10000, but 
greater than 0, moving over pages becomes difficult but not impossible.

.IP "\fISmartPlacement\fP"
Specifies that windows be placed in areas that no other windows occupy,
otherwise user intervention becomes required for placement.  Have fun, try
specifying both. :-)

.IP "\fIRandomPlacement\fP"
Specifies that windows which would normally require user intervention for
placement be automagically placed in ever-so-slightly random locations.

.IP "\fINoPPosition\fP"
Species that \fBafterstep\fP should ignore the PPosition field when placing
new windows, in other words, windows can't choose where to place themselves.
Adherence to the PPosition field is required for some applications.

.IP "\fIDecorateTransients\fP"
Specifies that transient windows (pop-up dialog boxes), which are normally
not decorated, should be given the usual title and low bars.  Note: some 
pop-up windows and menus are not managed by the window manager, so do not 
get these decorations.

.IP "\fIAppsBackingStore\fP"
Specifies that app windows should request backing store.  X-terminals and low
memory systems should avoid this as redrawing will be quicker than pulling
the saved image from swap space.  Backing store will always be faster than
redraw on machines that have enough memory. This causes non-ICCCM compliance.

.IP "\fIBackingStore\fP"
Specifies that decorations should request backing store.  Refer to
\fIAppsBackingStore\fP above for further details.

.IP "\fISaveUnders\fP"
Specifies that \fBafterstep\fP frames should request saveunders.  This will
cause \fBafterstep\fP to save those portions of windows that are not visible
to system memory.  This can significantly improve the performance during
opaque moves, but it causes a significant increase in memory usage.
This can also cause garbled display with some applications.

.IP "\fIDontMoveOff\fP"
Specifies that windows should not be moved off or initially placed off of
the desktop.  A few programs will not work correctly if you use this option.
This only keeps windows from being completely lost off the edge of the
desktop. It insists on keeping 16 pixels on the desktop, but does not
attempt to keep the entire window on the desk.

.IP "\fIXorValue value\fP"
Specifies the \fIvalue\fP with which bits are XOR'ed when doing rubber-band
window moving or resizing. Setting this value is a trial-and-error process.

.IP "\fIMenusHigh\fP"
Specifies that any pop-up menu's submenu should appear at the top of the
parent menu instead of starting at the point in the parent window where
the submenu item lies.

.IP "\fIPagingDefault 0|1\fP"
Specifies if Paging should be enabled (\fI1\fP) or disabled (\fI0\fP).
Paging is set to enabled by default.

.IP "Cursor \fIcursor_number cursor_type\fP"
Specifies the \fIcursor_type\fP for the given \fIcursor_number\fP.  Valid
\fIcursor_numbers\fP are 0 though 10 and listed in all the shipped
\fIfeel.name\fP files. The \fIcursor_types\fP are listed in the
 /usr/include/X11/cursorfont.h file.

.IP Functions
Specifies a function definition and is covered in the BUILT-IN
COMMAND/FUNCTION below.

.IP Popup
Specifies a menu popup definition and is covered in the BUILT-IN
COMMAND/FUNCTION below.

.IP "Mouse \fIbutton\fP \fIcontext\fP \fImodifier\fP \fICommand\fP"
Specifies a mouse binding definition. \fIbutton\fP is the mouse button
number [0, 1, 2, or 3]. If \fIbutton\fP is zero, then any mouse button
invoked issues the \fICommand\fP.  \fIcontext\fP describes where the
mouse click occurred and can be any combination of the following:

.nf
   R = Root window (main background)
   F = Window Frame (the BottomBar handle corners)
   S = Window TitleBar or BottomBar
   I = Iconified Button (minimized window icon)
   T = Window TitleBar
   W = Application Window
   A = Any of the above except for TitleButtons
1-10 = TitleButton number of the TitleBar, corresponds to the
       entry in the \fIlook.name\fP file
.fi

The action to be taken by the defined TitleButton is defined in the
\fIfeel.name\fP file.  Defining a TitleButton without having a corresponding
entry in the \fIfeel.name\fP file will cause the TitleButton icon to be
displayed, but not react when pressed.

\fImodifier\fP is the key-stroke combination associated with the
\fIcontext\fP entry, to issue the \fICommand\fP. Valid \fImodifier\fP's
are:

.nf
   N = No modifiers
   C = Control
   S = Shift
   M = Meta
   A = Any modifier
.fi

\fICommand\fP can be any \fBafterstep\fP \fIBuilt-in\fP command/
function, \fIPopup\fP or user defined \fIFunction\fP.

.IP "Key \fIkeyname\fP \fIcontext\fP \fImodifier\fP \fICommand\fP"
Specifies a key-stroke binding definition, similar to \fIMouse\fP above.
\fIkeyname\fP is the keyboard key name. Valid \fIkeyname\fP's are found in
the /usr/X11/include/X11/keysymdef.h file and are specified here without
the leading "XK_".  The \fIcontext\fP describes where the mouse is resting
when the \fIkeyname\fP is pressed and can be any combinationof the 
following:

.nf
   R = Root window (main background)
   F = Window Frame (the BottomBar handle corners)
   S = Window TitleBar or BottomBar
   I = Iconified Button (minimized window icon)
   T = Window TitleBar
   W = Application Window
   A = Any of the above except for TitleButtons
1-10 = TitleButton number of the TitleBar [ not very useful here ]
.fi

\fImodifier\fP is the key-stroke combination associated with the
\fIcontext\fP entry, to issue the \fICommand\fP. Valid \fImodifier\fP's
are:

.nf
   N = No modifiers
   C = Control
   S = Shift
   M = Meta
   A = Any modifier
.fi

\fICommand\fP can be any \fBafterstep\fP \fIBuilt-in\fP command/
function, \fIPopup\fP or user defined \fIFunction\fP.

.SH CONFIGURATION OPTIONS - \fIlook.name\fP

.IP "ButtonTextureType \fItype\fP"
Deprecated.  Use MyStyle "ButtonPixmap" instead.

.IP "ButtonMaxColors \fImaximum\fP"
Deprecated.  Use MyStyle "ButtonPixmap" instead.

.IP "ButtonBgColor \fIcolor\fP"
Deprecated.  Use MyStyle "ButtonPixmap" instead.

.IP "ButtonTextureColor \fIfrom\fP \fIto\fP"
Deprecated.  Use MyStyle "ButtonPixmap" instead.

.IP "ButtonPixmap \fIpixmap_name\fP"
Deprecated.  Use MyStyle "ButtonPixmap" instead.

.IP "DecorateFrames [\fI0|1\fP]"
Specifies that windows should not have a lowbar, and should have a frame.  
The frame width and height are defined by the width and height of the 
associated pixmaps (see \fIFrameNorth\fP, \fIFrameSouth\fP, etc).

.IP "FrameNorth \fIpixmap_name\fP"
Specifies the pixmap to be displayed in the top border of the window frame,  
\fIDecorateFrames\fP is set. See \fIBackPixmap\fP below for details on 
what \fIpixmap_name\fPs are allowed.

.IP "FrameSouth \fIpixmap_name\fP"
Specifies the pixmap to be displayed in the bottom border of the window 
frame, if \fIDecorateFrames\fP is set. See \fIBackPixmap\fP below for 
details on what \fIpixmap_name\fPs are allowed.

.IP "FrameEast \fIpixmap_name\fP"
Specifies the pixmap to be displayed in the right border of the window 
frame, if \fIDecorateFrames\fP is set. See \fIBackPixmap\fP below for 
details on what \fIpixmap_name\fPs are allowed.

.IP "FrameWest \fIpixmap_name\fP"
Specifies the pixmap to be displayed in the left border of the window 
frame, if \fIDecorateFrames\fP is set. See \fIBackPixmap\fP below for 
details on what \fIpixmap_name\fPs are allowed.

.IP "FrameNE \fIpixmap_name\fP"
Specifies the pixmap to be displayed in the top right corner of the window
frame, if \fIDecorateFrames\fP is set. See \fIBackPixmap\fP below for 
details on what \fIpixmap_name\fPs are allowed.

.IP "FrameSE \fIpixmap_name\fP"
Specifies the pixmap to be displayed in the bottom right corner of the 
window frame, if \fIDecorateFrames\fP is set. See \fIBackPixmap\fP below
for details on what \fIpixmap_name\fPs are allowed.

.IP "FrameNW \fIpixmap_name\fP"
Specifies the pixmap to be displayed in the top left corner of the window
frame, if \fIDecorateFrames\fP is set. See \fIBackPixmap\fP below for
details on what \fIpixmap_name\fPs are allowed.

.IP "FrameSW \fIpixmap_name\fP"
Specifies the pixmap to be displayed in the bottom left corner of the 
window frame, if \fIDecorateFrames\fP is set. See \fIBackPixmap\fP below
for details on what \fIpixmap_name\fPs are allowed.

.IP "MArrowPixmap \fIpixmap_name\fP"
Specifies a pixmap to use as the submenu indicator in popup menus. See 
\fIBackPixmap\fP below for details on what \fIpixmap_name\fPs are 
allowed.

.IP "MenuPinOn \fIpixmap_name\fP"
Specifies a pixmap to use as the pinned menu indicator in popup menus. 
See \fIBackPixmap\fP below for details on what \fIpixmap_name\fPs are 
allowed.

.IP "MenuPinOff \fIpixmap_name\fP"
Specifies a pixmap to use as the unpinned menu indicator in popup menus. 
See \fIBackPixmap\fP below for details on what \fIpixmap_name\fPs are 
allowed.

.IP "TexturedHandle"
Specifies that the resize handles on the bottom of windows should be 
textured. The titlebar texture will be used.

.IP "TextGradientColor \fIfrom\fP \fIto\fP"
Specifies a gradient to be applied to the focused window titlebar text. 
\fITextGradientColor\fP is ignored unless \fIGradientText\fP is also 
given. The gradient colors start at \fIfrom\fP and end at \fIto\fP. 
\fIfrom\fP and \fIto\fP are standard X11 color definitions.

.IP "GradientText"
Specifies that the gradient specified by \fITextGradientColor\fP should 
be applied to the focused window titlebar text.

.IP "ButtonNoBorder"
Specifies that the border normally drawn around iconified windows should 
be omitted.

.IP "DrawMenuBorders \fIborder_style\fP"
Specifies the menu border style. \fIborder_style\fP can be one of the 
following:

.nf
0: no borders
1: borders around each title and each item
2: borders around each title and all items
3: borders around each title, all items, and the hilighted item
.fi

.IP "TextureMenuItemsIndividually \fItexture_style\fP"
Specifies how textures should be applied to menu items. If 
\fItexture_style\fP is 0, menu items are textured as a group. If 
\fItexture_style\fP is 1, menu items are textured individually.  This 
option is ignored if the menu item MyStyle background uses a 
transparency effect.

.IP "SeparateButtonTitle \fIonoff\fP"
Specifies where iconified window titles should be drawn.  If \fIonoff\fP 
is 0, the title will be drawn at the top of the icon.  If \fIonoff\fP is 
1, the title will be drawn in a separate window at the below the icon.  
The default value of \fIonoff\fP is 1.

.IP "ButtonSize \fIwidth\fP \fIheight\fP"
Specifies the size of iconified windows.  Every iconified window button 
will be exactly \fIwidth\fP pixels wide and \fIheight\fP pixels high.  
This includes titles drawn at the top, but not the separate title window 
created by \fISeparateButtonTitle\fP.  If either \fIwidth\fP or 
\fIheight\fP is less than one, that dimension will not be fixed.  The 
default is ButtonSize 0 0.

.IP "ResizeMoveGeometry \fIgeom\fP"
Specifies the location of the resize/move window. If this option is not 
specified, the move/resize window will be centered on the screen. 
\fIgeom\fP may be any one of the following:

.nf
++: upper-left corner
-+: upper-right corner
+-: lower-left corner
--: lower-right corner
.fi

.IP "MenuMiniPixmaps \fIminis\fP"
Specifies whether mini pixmaps should be included in menus. If 
\fIminis\fP is 0, mini pixmaps are not included. If \fIminis\fP is 1, 
mini pixmaps are included. Note that mini pixmaps will not be added to 
menus until the next time menus are updated. Mini pixmaps can cause AS 
to take much longer to load over a network.

.IP "IconFont \fIfont\fP"
Deprecated.  Use MyStyle "ButtonPixmap", "ButtonTitleFocus", 
"ButtonTitleSticky", and "ButtonTitleUnfocus" instead.

.IP "IconBox \fIleft\fP \fItop\fP \fIright\fP \fIbottom\fP"
Specifies a region of the screen in which to place iconified windows. Up 
to four icon boxes can be defined. If an \fIIconBox\fP is provided, 
icons will automatically be placed in them, if possible. Otherwise, they 
will be placed in the upper left corner of the screen. Each time a
window is iconified, a new place is found for it, unless the icon has 
been moved manually. An available space is searched for from left to
right, then top to bottom. Icons will not be automatically placed on top 
of other icons, but they may be placed underneath application windows if 
\fIStubbornIconPlacement\fP has not been specified. If left or right is 
negative, then \fBAfterStep\fP will add the screen width to it.  If top 
or bottom is negative, then \fBAfterStep\fP will add the screen height 
to it. Note that -0 is not parsed as the right or bottom pixel on the
screen. Use -1 instead. The \fIIconBox\fP will normally be filled from 
left to right, then top to bottom.  However, if the right edge of the 
\fIIconBox\fP is closer to the right edge of the screen than the left 
edge of the \fIIconBox\fP is to the left edge of the screen, then it 
will be filled from right to left.  Similarly for top to bottom.  For 
example, "2 2 -1 -1" will result in an \fIIconBox\fP which fills from 
right to left, then bottom to top.

.IP "RubberBand \fItype\fP"
Specifies the \fIRubberBand\fP type to use when moving or resizing 
non-opaque windows.  There are 3 styles:

.nf
0: the window is represented as a number of rectangles
1: one rectangle the size of the window
2: one crossed-out rectangle the size of the window.

.IP "TitleTextAlign \fIalignment\fP"
Specifies the alignment of the window title in the titlebar.  The 
allowable values for \fIalignment\fP are as follows:

.nf
1: left aligned
2: right aligned
3: center aligned (default)
.fi

.IP "TitlebarNoPush"
Specifies that the titlebar should not to appear to be "pushed in" when 
clicked with a mouse button. This is useful to reduce video strain or if 
textured pixmaps that do not look good "pushed in" are used.

.IP "TitleButton \fInum\fP \fIpixmap_name\fP"
Specifies a pixmap to use as a titlebar button.  Up to 10 buttons are 
possible. \fInum\fP specifies the position of the button on the window 
and is an integer from 1 to 10. The positions are indicated as below:
.nf
[1] [3] [5] [7] [9] TitleBarText [10] [8] [6] [4] [2]
.fi

The action to be taken by the defined TitleButton is defined in the
\fIfeel.name\fP file.  Defining a TitleButton without having a corresponding
entry in the \fIfeel.name\fP file will cause the TitleButton icon to be
displayed, but not react when pressed.

.IP "TitleButtonStyle \fInum\fP"
Specifies how much space is put between leftmost and rightmost titlebar 
buttons, and the edges of the titlebar. If \fInum\fP is 0, there is a 
two pixel buffer the buttons and the edge. If \fInum\fP is 1, there is 
no space between the buttons and the edge.

.IP "TitleButtonSpacing \fInum\fP"
Specifies how much space (in pixels) to put between titlebar buttons.

.IP "TitleButtonBalloons"
Turns on the balloon feature. A "balloon" is displayed showing the 
function(s) bound to a titlebar button. The balloon background and text 
are configured with the MyStyle "TitleButtonBalloon".

.IP "TitleButtonBalloonBorderWidth \fInumber\fP"
Sets the width of the balloon window's border. Defaults to 1.

.IP "TitleButtonBalloonBorderColor \fIcolor\fP"
Sets the color of the balloon window's border. Defaults to black.

.IP "TitleButtonBalloonYOffset \fInumber\fP"
The balloon window is positioned to be horizontally centered against
the titlebar button it is describing. The vertical position may be
set as an offset. Negative offsets of \fI-N\fP are placed \fIN\fP
pixels above the pager window, positive offsets of \fI+N\fP are placed
\fIN\fP pixels below. Defaults to +2.

.IP "TitleButtonBalloonDelay \fInumber\fP"
Specifies the period in milliseconds to delay the appearance of the
balloon.

.IP "DefaultStyle ""\fIstyle_name\fP"""
Specifies the \fIMyStyle\fP to use when no style has been specifically 
defined for a given situation. Note that if a style named "default" has 
been defined and DefaultStyle has not, the "default" style will be used 
as the default.

.IP "FWindowStyle ""\fIstyle_name\fP"""
Specifies the \fIMyStyle\fP to use for the focused window decorations.

.IP "UWindowStyle ""\fIstyle_name\fP"""
Specifies the \fIMyStyle\fP to use for the unfocused window decorations.

.IP "SWindowStyle ""\fIstyle_name\fP"""
Specifies the \fIMyStyle\fP to use for the sticky window decorations.

.IP "MenuItemStyle ""\fIstyle_name\fP"""
Specifies the \fIMyStyle\fP to use for menu items.

.IP "MenuTitleStyle ""\fIstyle_name\fP"""
Specifies the \fIMyStyle\fP to use for menu titles.

.IP "MenuHiliteStyle ""\fIstyle_name\fP"""
Specifies the \fIMyStyle\fP to use for hilighted menu items.

.IP "MenuStippleStyle ""\fIstyle_name\fP"""
Specifies the \fIMyStyle\fP to use for stippled menu items.

.IP "MyStyle ""ButtonPixmap"""
Specifies the background tile of iconified windows.  Inherits from the 
old ButtonPixmap, IconFont, ButtonTextureType, ButtonMaxColors, 
ButtonBgColor, and ButtonTextureColor options, and also inherits from 
FWindowStyle.

.IP "MyStyle ""ButtonTitleFocus"""
Specifies how focused iconified window titles should look.  Inherits from 
FWindowStyle.

.IP "MyStyle ""ButtonTitleSticky"""
Specifies how sticky iconified window titles should look.  Inherits from 
SWindowStyle.

.IP "MyStyle ""ButtonTitleUnfocus"""
Specifies how unfocused iconified window titles should look.  Inherits from 
UWindowStyle.

.IP "MyStyle ""\fIstyle_name\fP"""
.IP "  \fIstyle_option\fP"
.IP "~MyStyle"
Specifies the beginning of a look style definition. The style can be 
referred to later by \fIstyle_name\fP. \fI~MyStyle\fP ends a look style 
definition. The possible \fIstyle_option\fPs follow:

.RS
.IP "Font \fIfont\fP"
Specifies the font associated with this style. \fIfont\fP is a standard 
X11 font definition.

.IP "ForeColor \fIcolor\fP"
Specifies the text color associated with this style. \fIcolor\fP is a 
standard X11 color definition.

.IP "BackColor \fIcolor\fP"
Specifies the background color associated with this style. \fIcolor\fP 
is a standard X11 color definition.

.IP "TextStyle \fIstyle\fP"
Specifies the text \fIstyle\fP associated with this style. \fIstyle\fP 
can be 0, 1, or 2:

.nf
0: normal text
1: 3d effect #1
2: 3d effect #2
.fi

.IP "DrawTextBackground [\fI0|1\fP]"
Specifies that the area behind text drawn in this style should be cleared 
to \fIBackColor\fP.  The argument is optional.  If the argument is 0, 
this option is turned off; if it is omitted or is nonzero, the option is 
turned on.

.IP "MaxColors \fImaximum\fP"
Specifies the \fImaximum\fP number of colors that the \fIBackGradient\fP 
can use. jpegs specified with \fIBackPixmap\fP will also be limited to 
this number of colors.

.IP "BackGradient \fItype\fP \fIfrom\fP \fIto\fP"
Specifies that a gradient should be used as a background instead of a 
solid color. The gradient colors start at \fIfrom\fP and end at \fIto\fP. 
\fIfrom\fP and \fIto\fP are standard X11 color definitions. \fItype\fP 
can be 1, 2, 3, 4, or 5:

.nf
1: Wharf-style diagonal gradient
2: Horizontal from top to bottom
3: Horizontal from top/bottom to center
4: Vertical from left to right
5: Vertical from left/right to center
.fi

.IP "BackMultiGradient \fItype\fP \fIoffset1\fP \fIcolor1\fP ... \fIoffsetN\fP \fP colorN\fP"
Specifies that a gradient should be used as a background instead of a 
solid color. The gradient colors start at \fIcolor1\fP and end at 
\fIcolorN\fP. Each color has an \fIoffset\fP associated with it. The 
\fIoffset\fP is a number between 0.0 and 1.0, and specifies where in 
the gradient the colors are to be placed.  The colors are standard X11 
color definitions. At least two colors must be given. The offsets are 
non-decreasing numbers between 0.0 and 1.0. If the first offset is not 
0.0, it will be set to 0.0. If the last offset is not 1.0, it will be 
set to 1.0. \fItype\fP may be any of the following:

.nf
6: diagonal from top-left to bottom-right
7: diagonal from bottom-left to top-right
8: top to bottom
9: left to right
.fi

.IP "BackPixmap \fItype\fP \fIpixmap_name|color_name\fP"
Specifies that a pixmap should be used as a background instead of a 
solid color. This option has two forms, depending on the value of 
\fItype\fP. If \fItype\fP is 128, the second parameter, \fIpixmap_name\fP 
must be the name of an xpm, jpeg, or png image which can be found in 
\fIPixmapPath\fP. If \fItype\fP is 129, the root pixmap (desktop 
background) will be used, and the optional second parameter must be a 
color with which the root pixmap will be shaded.  If \fItype\fP is 130, 
the root pixmap will be averaged with the specified pixmap, and the 
result will be used as the background.  In order for \fItype\fP 129 
or \fItype\fP 130 to work properly, your desktop background must be set 
by a program that also sets the _XROOTPMAP_ID property on the root 
window, such as asetroot or Esetroot.

.nf
128: tiled pixmap from the upper left
129: "transparent" (or tinted with color)
130: translucent pixmap
.fi

.IP "Inherit ""\fIstyle_name\fP"""
Specifies a \fIMyStyle\fP to inherit options from. Options from 
\fIstyle_name\fP will override previously specified options for this 
style. \fIInherit\fP is a good way to save memory and network bandwidth 
if the same \fIBackPixmap\fP is used for several styles, as the pixmap 
will only be loaded for the inherited style.

.SH CONFIGURATION OPTIONS - \fIstartmenu\fP
The \fIstartmenu\fP is built from the \fIstart/\fP tree by utilizing files
which have the menu items as command strings within them.  The basic
structure of a command string is as follows:
.nf
.sp
\fIExec\fP \fI"name"\fP exec command [-options]
.fi
.sp
Where \fIExec\fP is a built-in command (see below); \fI"name"\fP is what
will appear as the entry in the created \fIstartmenu\fP; exec invokes a
subprocess (via \fBexec(3)\fP) for the given "command"; and "command" is 
whatever program is to be invoked along with any "-options" that might be 
desired.

.IP \fI.include\fP

Any directory in the \fIstart/\fP directory tree may have an \fI.include\fP
file. Also, any directory which is subsequently included (via this
\fIinclude\fP directive) may also have an \fI.include\fP file.  Valid
entries for an \fI.include\fP file are as follows:

.RS
.IP "Command \fIcommand\fP [\fIargs\fP]"
Specifies an AfterStep function to apply to all items in this directory.
Does not apply to subdirectories or included directories. The resulting 
function will be: 

\fIcommand\fP "menu name" \fIargs\fP /menu/item/full/path

.IP "Extension \fIext\fP"
Specifies an extension to strip from all filenames in this directory
prior to placing them in the menu as menu item names.  For example, an
\fIext\fP of "look." will cause the file "look.DEFAULT" to show up as 
"DEFAULT" in the menu, and an \fIext\fP of ".tar.gz" will cause the file
"theme.tar.gz" to show up as "theme" in the menu.

.IP "Include ""\fIpath\fP"" [\fIcommand\fP [\fIargs\fP]]"
Specifies the path to another directory, whose contents will be included
in this menu. If \fIcommand\fP is given, it will be applied to all items
in the included directory as if a \fICommand\fP directive (see above) 
had been given, except that subdirectories of the included directory are
also affected.

.IP "KeepName"
Specifies that the directory name should be retained when creating the
distilled menu, so that it can be referred to by name in a \fIPopUp\fP
statement (see BUILT-IN COMMANDS/FUNCTIONS, below). The toplevel menu 
(start) has this option on by default.

.IP "MiniPixmap \fIpixmap\fP"
Specifies a pixmap to display to the left of the menu item which invokes
this menu, and in the title of this menu.

.IP "Name \fIname\fP"
Specifies the \fIname\fP of this folder in the final menu displayed to
the user. This name will be overridden if the folder's filename includes
an order; use the order command (below), instead.

.IP "Order \fIorder\fP"
Specifies where in its parent menu the item which invokes this menu should
appear. A menu without this option will be given an order of 10000 by
default.

.SH BUILT-IN COMMANDS/FUNCTIONS
\fBafterstep\fP supports a small set of built in functions which can be
bound to key-stroke combinations or mouse buttons.  These can also be
embeded within \fIFunction\fP statements or within menu statements in a
\fIfeel.name\fP file. NOTE: [\fI"name"\fP] in the following is used in a
popup or menu item entry to define the name which will appear in said
pop-up or menu.

.IP "Nop """""
Inserts a horizontal line (<HR> type html line) in a menu entry list.

.IP "Nop ""name"""
Inserts a \fIname\fP in the menu, stippled (disabled and grayed-out).

.IP "Title \fI""name""\fP"
Insert a title line of heading \fIname\fP into a popup or menu.

.IP "Beep"
Make the window manager issue a beep - pretty useful eh? :)

.IP "Quit [\fI""name""\fP]"
Exits \fIafterstep\fP, generally causing X to exit too.

.IP "Restart \fI""name""\fP \fIWindowManagerName\fP"
Restarts \fBX(1)\fP with the given \fIWindowManagerName\fP.  If 
\fIWindowManagerName\fP is\fBafterstep\fP, then this forces 
\fBafterstep\fP to reread all of its configuration files and reinitiate 
the session.  If \fIWindowManagerName\fP is not in the default search 
path, then the full path name should be given.

.IP "Refresh [\fI""name""\fP]"
Causes all windows on the screen to re-draw themselves.

.IP "Move [\fI""name""\fP]"
Allows the user to move a window or iconified app.

.IP "Resize [\fI""name""\fP]"
Allows the user to resize a window.

.IP "Raise [\fI""name""\fP]"
Allows the user to raise a window.

.IP "Lower [\fI""name""\fP]"
Allows the user to lower a window.

.IP "RaiseLower [\fI""name""\fP]"
Alternately raises and lowers a window; i.e. if it's raised, the window 
will lower, and vice versa.

.IP "PutOnTop"
Moves the target window to the top of its layer, or up one layer if it 
is already at the top.

.IP "PutOnBack"
Moves the target window to the bottom of its layer, or down one layer if 
it is already at the bottom.

.IP "SetLayer \fIlayer\fP"
Moves the target window to layer \fIlayer\fP.

.IP "ToggleLayer \fIlayer1\fP \fIlayer2\fP"
Specifies that if the window is in \fIlayer1\fP, it should be placed in 
\fIlayer2\fP.  Otherwise, it is placed in \fIlayer1\fP.  In either case, 
the window will be placed on top of other windows in the target layer.

.IP "Shade [\fI""name""\fP]"
Emulates the MacOS WindowShade feature.  Once activated the window will
become a titlebar only.

.IP "Delete [\fI""name""\fP]" 
Sends a WM_DELETE message to a window asking that it remove itself,
frequently causing the application to exit.

.IP "Destroy [\fI""name""\fP]"
Sends the \fBXKillClient(3)\fP to a window. Guaranteed to get rid of the 
window.

.IP "Close [\fI""name""\fP]"
First sends the WM_DELETE message, if this is not understood, then the
\fBXKillClient(3)\fP is sent to the window.

.IP "Iconify [\fI""name""\fP] [\fIvalue\fP]"
Iconifies a window if it is not already iconified, or de-iconifies it if
it is already iconified. If the optional argument \fIvalue\fP is positive,
then only iconification will be allowed, and de-iconification will be
inhibited. If the optional argument is negative, only de-iconification will
be allowed.

.IP "Maximize [\fI""name""\fP] [\fIhorizontal vertical\fP]"
Causes the window to alternately switch from a full-screen size to its
normal size.  Specifying the optional arguments of \fIhorizontal\fP and
\fIvertical\fP, control can be attained as to the percentage of the full
screen that the new size of the window becomes.  If \fIhorizontal\fP > 0,
then the horizontal dimension of the window will be set to
horizontal*screen_width/100. The vertical resizing is similar. Values
larger than 100 can be used with caution.  The defaults for \fIhorizontal\fP 
and \fIvertical\fP are 100s (ie, fullscreen).

.IP "Stick [\fI""name""\fP]"
Makes a window sticky (stays on screen when desks/views are switched) if it
is not already sticky, or non-sticky if it is already sticky.

.IP "Scroll \fIhorizontal vertical\fP"
Scrolls the desktop's view by \fIhorizontal\fP pages in the x-direction,
and \fIvertical\fP pages in the y-direction. Either or both entries may be
negative. Both \fIhorizontal\fP and \fIvertical\fP values are expressed
in percent of pages, so 100 would be one full page. Normally, scrolling
stops at the edge of the desktop.  If the \fIhorizontal\fP and
\fIvertical\fP values are multiplied by 1000, then scrolling will wrap
around at the edge of the desktop.

The scroll function should not be called from pop-up menus.

.IP "TogglePage [\fI""name""\fP]"
Temporarily disables \fIEdgeScroll\fP.  Edge scrolling can be re-enabled by
calling this again.

.IP "CursorMove \fIhorizontal vertical\fP"
Moves the mouse pointer by \fIhorizontal\fP views in the x-direction, and
\fIvertical\fP views in the y-direction. Either or both entries may be
negative. Both \fIhorizontal\fP and \fIvertical\fP values are expressed in
percent of pages, so 100 would be one full view.

The CursorMove function should not be called from pop-up menus.

.IP "ChangeWindowUp [\fI""name"" window_name\fP]"
Causes the pointer to move to the previous window in the list of windows
for which \fICirculateSkip\fP has not not been specified.

The mouse will jump to the first window whose name (or icon name or class)
matches \fIwindow_name\fP. The \fI"name"\fP entry then becomes required,
but serves no purpose if the function is not called from a menu or popup.

.IP "ChangeWindowDown [\fI""name"" window_name\fP]"
Causes the pointer to move to the previous window in the list of windows for
which \fICirculateSkip\fP has not not been specified.

The mouse will jump (going backwards) to the first window whose name (or
icon name or class) matches \fIwindow_name\fP. The \fI"name"\fP entry
then becomes required, but serves no purpose if the function is not called
from a menu or popup.

.IP "WarpFore [\fI""name"" window_name\fP]"
Same as \fIChangeWindowUp\fP, but uniconifies any iconified windows as it
focuses on them.

.IP "WarpBack [\fI""name"" window_name\fP]"
Same as \fIChangeWindowDown\fP, but uniconifies any iconified windows as it
focuses on them.

.IP "Wait \fIapp_name\fP"
This is intended to be used in \fBafterstep\fP functions only. It causes
execution of a function to pause until a new window named \fIapp_name\fP
appears.  \fBafterstep\fP remains fully functional during a wait. This is
particularly useful in the InitFunction and RestartFunction, if you are
trying to start windows on specific desktops.

.IP "Focus"
Moves the view or window as needed to make the selected window visible.
Sets the keyboard focus to the selected window. Raises the window if 
needed to make it visible. Warps the pointer into the selected window in
focus-follows-mouse  mode.  Does not de-iconify.  This function is
primarily handy when used with a module such as the WinList.

.IP "Desk \fIarg1\fP [\fIarg2\fP]"
Changes current desk to another desk as surmised from the arguments
supplied.  If only \fIarg1\fP is specified and is non-zero, then the 
current desk will become "desk + arg1" and \fIarg2\fP is ignored.  
If \fIarg1\fP is zero, then \fIarg2\fP must be specified or no desk 
change will occur; and \fIarg2\fP will specify the desk to switch to.  
Desk numbers are determined dynamically and must be between 2147483647
and -2147483648; meaning they can also be negative.

.IP "WindowsDesk \fInew_desk\fP"
Moves the selected window to the desktop specified as \fInew_desk\fP.

.IP "GotoPage \fIx y\fP"
Moves the desktop view to page \fIx y\fP. The upper left page is (0,0),
the upper right is (N,0), where N is one less than the current number of
horizontal pages specified in the \fIDeskTopSize\fP command detailed in the
\fBPager(1)\fP man page. The lower left page is (0,M), and the lower right 
page is (N,M), where M is the desktop's vertical size as specified in the 
\fIDeskTopSize\fP command.

The GotoPage function should not be used in a pop-up menu.

.IP "WindowList [\fIarg1 arg2\fP]"
Specifies the internal popup menu in which the titles of each open
application are displayed, should be popped up.  Selecting an item from the
list will cause the current desk to switch to the application's desk, and
will raise it if it's behind other windows.  If the application is currently
iconified, then it will be de-iconified normally.  

Generally, if \fIarg1\fP is an even number, then the windows will be listed
using the window name (the name that shows up in the title-bar); if
\fIarg1\fP is an odd number, then the window's icon name is used.

Specifically, if \fIarg1\fP is 0, 1 or 2, then all windows on all desks
will be shown.  If \fIarg1\fP is 2 or 3, then only windows on the current
desk will be shown.  If \fIarg1\fP is 4 or 5, then only windows on the
desk number specified with \fIarg2\fP, will be shown.  Windows which have
WindowListSkip specified in their style will not be listed in the window
list.

.IP "Exec \fI""name""\fP \fIcommand\fP [\fI-options\fP]"
Specifies a sub process to initiate.  The \fI"name"\fP is required for
ease of parsing.  The \fIcommand\fP is the command or application to be
invoked along with any desired \fI-options\fP.

.IP "PopUp \fI""popup_name""\fP"
There are two situations where this might occur; as a popup menu stanza
definition, or in calling a previously defined menu declaration.

.nf
Popup \fI"popup_name"\fP
    built-in_command  \fI"name"\fP [\fIargument\fP]
EndPopup
.fi

Specfies the definition of a complex menu popup \fI"popup_name"\fP, which
can be bound to a mouse button or key using \fI"popup_name"\fP to recall
this declaration.  \fIbuilt-in_command\fP specifies which command will be
performed, utilizing it's syntax from this list of Built-In
Commands/Functions. \fI"name"\fP specifies the name which will appear
within the menu for the given item, and additionally any \fIarguments\fP
needed by the \fIbuilt-in_command\fP.  The Popup definition ends with the
keyword EndPopup. Sub-menus can be created by calling the Popup built-in
within another Popup declaration, as long as that sub-menu was defined
earlier in the configuration file.

Shortcut keys may be specified in the menu definition by preceding a
character with an ampersand. The ampersand will not be displayed, but the
character after it will be displayed at the right side of the same entry.
.\" and if the user presses the corresponding key, then that item will be
.\" activated as if it had been clicked upon.  
Only alphanumeric characters
may be used as shortcut keys.  The shift state of the keyboard is ignored
when testing shortcut characters.
.\" Shortcut keys are not operative unless MENU_HOTKEYS was defined when
.\" building AfterStep. If WINDOWLIST_HOTKETS was also defined, then hot
.\" keys are automatically added to the WindowList when it is displayed.

When calling a previously defined menu or a menu from a key-stroke
combination, Popup is simply used as a built-in command with the
\fI"name"\fP referring to the previously defined Popup definitions name.

Popups can be bound to keys through the use of the key modifier. Popups
can be operated without using the mouse by binding to keys, and operating
via the up arrow, down arrow, and enter keys.  Refer to the \fIfeel.name\fP
files and below in EXAMPLES for examples.

.IP "Function \fI""function_name""\fP"
There are also two situations where this might occur as well; as a function
definition stanza, or in calling a previously defined function decleration.

.nf
Function \fI"function_name"\fP
    built-in_command \fI"action"\fP [\fIargument\fP]
EndFunction
.fi

Specifies the definition of a complex function \fI"function_name"\fP,
which can later be bound to a mouse button or key using
\fI"function_name"\fP to recall this declaration.  \fIbuilt-in_command\fP
specifies which command will be performed, taking its syntax from this
list of Built-In Commands/Functions. \fI"action"\fP specifies the action
to take followed by any additional \fIarguments\fP needed by the
\fIbuilt-in_command\fP. Menus can be specified by using the \fIPopup\fP
command, as long as the menu was defined earlier in the configuration file.

The trigger \fIactions\fP which are recognized are Immediate (can be
shortened to "I"), Motion, Click, DoubleClick and TripleClick. Immediate
actions are executed as soon as the function is activated, even if a window
has not been selected. If there are actions other than immediate ones,
\fIafterstep\fP will wait to see if the user is clicking, double-clicking,
triple-clicking or dragging the mouse; then will execute only the built-ins
from the function definition whose trigger action matches the action
performed by the user.  The clicking, double-clicking and triple-clicking
concepts do not carry through to using keyboard shortcuts.

Two special functions exist: InitFunction and RestartFunction. The
InitFunction will be called when \fBafterstep\fP is started for the first
time in any X session, and can be used to start modules and begin programs.
The RestartFunction will be called when \fBafterstep\fP is restarted. It can
be used to re-start modules but probably should not be used to start
programs.  These two functions are defined in the \fIautoexec\fP file.

When calling a previously defined Function or a Function from a key-stroke
combination, Function is simply used as a built-in command using the
previously defined \fI"action"\fP from the same \fIfunction_name\fP.

.nf
Function \fIbuilt-in_command\fP \fI"action"\fP \fIfunction_name\fP
.fi

Refer to the \fIfeel.name\fP files and below in EXAMPLES for examples.

.IP "Module \fIModuleName\fP [\fIarguments\fP]"
Specifies that \fIModuleName\fP should be spawned.

Currently, many modules are included with \fBafterstep\fP. \fBWharf(1x)\fP 
and \fBPager(1x)\fP are two of the more popular ones. Wharf will normally 
be spawned during initialization instead of in response to a mouse binding 
or menu action. Modules can be short lived transient programs, or, like 
Wharf, can be intended to remain for the duration of the X session. 
Modules will be terminated by \fBafterstep\fP prior to restarts and quits, 
if possible.

.SH FILES

.IP "\fI/usr/local/share/afterstep/.workspace_state\fP"
The global empty file which is copied, upon the first invocation of
\fBafterstep\fP, into that users newly created
$HOME/GNUstep/Library/AfterStep tree.

.IP "\fI$HOME/GNUstep/Library/AfterStep/.workspace_state\fP"
The global file where applications still running are saved, including
geometry (if possible) and options, when AfterStep is exitted normally.
This ability can be disabled during configure or by closing all running
applications before exiting AfterStep.

.IP "\fI/usr/local/share/afterstep/autoexec\fP"
The global configuration file that specifies which modules and/or programs
to start upon \fBafterstep's\fP invocation or restart.

.IP "\fI$HOME/GNUstep/Library/AfterStep/autoexec\fP"
This file should be copied from the
\fI/usr/local/share/afterstep/autoexec\fP and edited to suit the user's
specific requirements.  This file, if it exists, will override the system
wide default file.

.IP "\fI/usr/local/share/afterstep/base.[8|15|16|24|32]bpp\fP"
The global configuration file setting the paths and a few \fBPager(1)\fP 
options for the desired colordepth.

.IP "\fI$HOME/GNUstep/Library/AfterStep/base.[8|15|16|24|32]bpp\fP"
This file should be copied from the
\fI/usr/local/share/afterstep/base.[8|15|16|24|32]bpp\fP and edited to suit
the user's specific requirements. This file, if it exists, will override the
system wide default file.

.IP "\fI/usr/local/share/afterstep/compatibility\fP"
The global configuration file to be used in conjunction with the \fI-f
steprc_file\fP to gain a limited amount of compatiblity with the ancient
steprc file structure.

.IP "\fI$HOME/GNUstep/Library/AfterStep/compatibility\fP"
This file should be copied from the
\fI/usr/local/share/afterstep/compatibility\fP and edited to suit the
user's specific requirements. This file, if it exists, will override the
system wide default file.

.IP "\fI/usr/local/share/afterstep/database\fP"
The global configuration file containing entries for \fIstyles\fP of
some applications.

.IP "\fI$HOME/GNUstep/Library/AfterStep/database\fP"
This file should be copied from the
\fI/usr/local/share/afterstep/database\fP and edited to suit the
user's specific requirements. This file, if it exists, will override the
system wide default file.

.IP "\fI/usr/local/share/afterstep/non-configurable/[0|1|2|3]_background\fP"
The default background for each desk shipped with AfterStep.  These files
will be copied, upon the first invocation of \fBafterstep\fP, into that
user's newly created $HOME/GNUstep/Library/AfterStep/non-configurable/ tree.

.IP "\fI/usr/local/share/afterstep/non-configurable/[0|1|2|3]_feel.[8|15|16|24|32]bpp\fP"
The "feel.DEFAULT" for each desktop as shipped with AfterStep.  These files
will be copied, upon the first invocation of \fBafterstep\fP, into that
user's newly created $HOME/GNUstep/Library/AfterStep/non-configurable/ tree.

.IP "\fI/usr/local/share/afterstep/non-configurable/[0|1|2|3]_look.[8|15|16|24|32]bpp\fP"
The "look.DEFAULT" for each desktop as shipped with AfterStep.  These files
will be copied, upon the first invocation of \fBafterstep\fP, into that
user's newly created $HOME/GNUstep/Library/AfterStep/non-configurable/ tree.

.IP "\fI/usr/local/share/afterstep/start/.include\fP"
An include directive which controls various things in the startmenu; for
instance the version number that appears on the menu.  If this file is
copied to the $HOME directory, then the version number will not increment
upon subsequent upgrades.

.IP "\fI/usr/local/share/afterstep/start/Desktop/Look/.include\fP"
A file that is required for Look menu operations
(\fI$HOME/GNUstep/Library/AfterStep/start/Desktop/Look/.include\fP
overrides this file).

.IP "\fI/usr/local/share/afterstep/start/Desktop/Feel/.include\fP"
A file that is required for Feel menu operations
(\fI$HOME/GNUstep/Library/AfterStep/start/Desktop/Feel/.include\fP
overrides this file).

.IP "\fI/usr/local/share/afterstep/start/Desktop/Theme/.include\fP"
A file that is required for Theme menu operations
(\fI$HOME/GNUstep/Library/AfterStep/start/Desktop/Theme/.include\fP
overrides this file).


.SH EXAMPLES
AfterStep ships with the configuration files themeselves as examples.  A
few examples from various configuration files are below to show those that
are possible, but not in the default files.

.IP database file examples \-

To have all iconified apps "disappear" (not be displayed as an icon:

.nf
Style	"*"	NoIcon
.fi

To have an app which has a small TitleBar area not display the 1,2 and 4
TitleButtons, and stick to each desk, as well as using the icq.xpm icon
when iconified:

.nf
Style	"ICQ"	Icon icq.xpm, Sticky, NoButton 1, NoButton 2, NoButton 4
.fi

.IP feel.name file examples \-

To have a right click menu which has some Window Operands:

.nf
Popup "Window-Ops"
	Title	 "Window Ops"
	Function "Move"          Shade-or-Raise
	Function "Resize"        Resize-or-Raise
	Raise	 "Raise"
	Lower	 "Lower"
	PutOnTop "(Un)PutOnTop"
	Stick	 "(Un)Stick"
	Function "(Un)Maximize"  Maximize_Function
	Destroy	 "Destroy"
	Close	 "Close"
	Refresh	 "Refresh Screen"
	Exec	 "Window Properties" exec xprop | xmessage -center -title 'xprop' -file -
EndPopup

	...then assign this Popup the right mouse button click on the
	desktop:

.nf
Mouse 3         R       A       PopUp "Window-Ops"
.fi

.SH KEYBOARD SHORTCUTS
All window-manager operations can be performed from the keyboard, so
mouse-less operation should not be difficult. In addition to scrolling 
around the desktop by binding the Scroll built-in to appropriate keys,
Pop-ups, move, resize and most other built-ins can be bound to keys. Once
a built-in function is started, the pointer is moved by using the up, down,
left, and right arrows, and the action is terminated by pressing return.  
Holding down the shift key will cause the pointer movement to go in larger
steps, and holding down the control key will cause the cursor movement to
go in smaller steps. Standard emacs and vi cursor movement controls (^n,
^p, ^f, ^b, and ^j, ^k, ^h, ^l) can be used instead of the arrow keys.

.SH SPECIAL NOTE FOR XFREE86 USERS
XFree86 provides a virtual screen whose operation can be confusing when
used in conjunction with this virtual window manager. With XFree86, windows
which appear on the virtual screen actually get drawn into video memory, so
the virtual screen size is limited by available video memory.

With AfterStep's virtual desktop manager, \fBPager(1)\fP, windows which do 
not appear on the screen do not actually get drawn into video RAM. The size 
of the virtual desktop is limited to about 32,000 by 32,000 pixels. It is 
probably impractical to use a virtual desktop more than about 5 times the 
visible screen in each direction. Note that memory usage with the virtual 
desktop is a function of the number of windows which exist. The size of the 
desktop makes no difference.

When becoming familiar with AfterStep, it is recommended that you
disable XFree86's virtual screen, by setting the virtual screen size to
the physical screen size. When familiar with AfterStep, you may want
to re-enable XFree86's virtual screen.

.SH AUTHORS
.nf
Frank Fejes (frank@canweb.net)
Alfredo Kenji Kojima (kojima@inf.ufrgs.br)
Dan Weeks (dan@mango.sfasu.edu)
Guylhem Aznar (guylhem@oeil.qc.ca)
Chris Ridd (C.Ridd@isode.com)
Rob Malda (malda@imagegroup.com)
Ethan Fischer <allanon@crystaltokyo.com>
David Mihm <dmihm@swbell.net> [Man page]
Sasha Vasko <sashav@sprintmail.com>
.fi

.SH SEE ALSO
.BR X (1),
.BR Animate (1),
.BR Audio (1),
.BR Banner (1),
.BR Cascade (1),
.BR Clean (1),
.BR Form (1),
.BR Ident (1),
.BR Pager (1),
.BR Save (1),
.BR Script (1),
.BR Scroll (1),
.BR Tile (1),
.BR Wharf (1),
.BR WinList (1),
.BR Zharf (1)

.SH BUGS
Bugs? we don't see no stinking bugs! :) Seriously, they are only bugs if
you report them - then they can be fixed.

.SH COPYRIGHTS
AfterStep is distributed under GNU GPL v2; however, AfterStep
was based on BowMan which derived from Fvwm code, which is in
turn derived from twm code, thus some C source files from
AfterStep share copyrights with twm.

AfterStep is copyright 1996 by Frank Fejes, Alfredo Kojima,
and Dan Weeks.

AfterStep is copyright 1998 by Guylhem Aznar, Raphael Goulais,
and Rob Malda.

AfterStep is copyright 1999 by Ethan Fischer, Sasha Vasko.

Please see the file COPYING included with the AfterStep distribution
for the conditions that are incumbent on the users of AfterStep due
to its relations to fvwm and twm.

AUTHORS AND ALL OTHER CONTRIBUTERS DISCLAIM ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

.SH HISTORY
AfterStep is a continuation of the BowMan window manager which was
originally put together by Bo Yang.  BowMan was based on the fvwm window 
manager, written by Robert Nation.  Fvwm was based on code from twm.  And 
so on....  It is designed not only to emulate some of the look and feel of
the NEXTSTEP(tm) user interface, but also to add useful, requested, and neat 
features.  The changes which comprise AfterStep's personality were
originally part of BowMan development, but due to a desire to move past
SIMPLE EMULATION and into a niche as its OWN valuable window manager, the
previous designers decided to change the project name and move on.

Some major changes from \fBfvwm(1)\fP 1.24 include:
.nf
.sp
1. NEXTSTEP(tm)-alike title bar, title buttons, borders 
   and corners.
2. AfterStep's \fBWharf(1)\fP. To avoid copyright 
   complications it is not called a "Dock".
3. NEXTSTEP(tm) style menus. However the menus are not 
   controlled by applications, they are more like pop-up 
   service lists on the root window.
4. NEXTSTEP(tm) style icons. The default icons are 
   consistent with those in the NEXTSTEP(tm) interface, 
   but they are configurable.
5. Dissociation of \fBPager(1)\fP desktops for background 
   pixmaps and configuration: each desktop can have its 
   own configuration, its own look, its own background 
   picture and all this can be changed on fly with the 
   Start/Desktop menu.
.fi
.sp
However, flexibility was not traded off. Initiation files, in
\fI~/GNUstep/Library/AfterStep\fP, recognize most of the \fBfvwm(1)\fP 
commands.

.SH ICCCM COMPLIANCE
AfterStep attempts to be ICCCM 2.0 compliant.  As of this release,
colormap handling is not completely ICCCM compliant. In addition, ICCCM
states that it should be possible for applications to receive ANY keystroke,
which is not consistent with the keyboard shortcut approach used in
AfterStep and most other window managers.  The user can disable any
AfterStep keystroke that should be passed to the application and not
intercepted by the window manager.  An ICCCM compliant \fIfeel\fP file
is included - feel.ICCCM from the \fIstartmenu\fP.
