// bbkeys.hh for bbkeys - a tool for playing with keygrabs
//
//  Copyright (c) 1998-1999 by John Kennis, jkennis@chello.nl
//  (bits thrown in by vanRijn here and there.  =:)
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//


#ifndef __MAIN_HH
#define __MAIN_HH

/* bbkeys -- Ye Olde Keystroke Grabber for Blackbox */
#include <X11/Xlib.h>
#include <X11/keysym.h>

#define MaxInstructions 50

typedef struct {
    unsigned long modMask;
    KeyCode keycode;
    int action;
    char *execCommand;
} KEY_ACTION_MAP;

typedef struct {
    int instructCount;
    KEY_ACTION_MAP KeyMap[MaxInstructions];
} KEY_GRAB_INSTRUCTION;

#define grabIconify 1
#define grabRaise 2
#define grabLower 3
#define grabClose 4
#define grabWorkspace1 5
#define grabWorkspace2 6
#define grabWorkspace3 7
#define grabWorkspace4 8
#define grabWorkspace5 9
#define grabWorkspace6 10
#define grabWorkspace7 11
#define grabWorkspace8 12
#define grabWorkspace9 13
#define grabWorkspace10 14
#define grabWorkspace11 15
#define grabWorkspace12 16
#define grabNextWorkspace 17
#define grabPrevWorkspace 18
#define grabNextWindow 19
#define grabPrevWindow 20
#define grabShade 21
#define grabMaximize 22
#define grabStick 23
#define grabExecute 24
#define grabVertMax 25
#define grabHorizMax 26

/* end bbkeys-specifics */

#include "Image.hh"
#include "Basewindow.hh"
#include "resource.hh"
#include "wminterface.hh"

class Resource;
class BaseResource;
class Basewindow;
class WMInterface;

struct PIXMAP {
  Pixmap  frame;
  Pixmap  window;
  Pixmap  focusedDesktop;
  Pixmap  focusedWindow;
  Pixmap  desktop;

  Pixmap  pix_title;
  Pixmap  pix_back;
  Pixmap  pix_closeBtn;
  Pixmap  pix_configBtn;
  Pixmap  pix_pressedBtn;
};

struct GEOM {
  int height;
  int width;
  int x;
  int y;
};

struct WindowList {
  Window win;
  int x_position;
  int y_position;
  unsigned int width;
  unsigned int height;
  bool icon;
  bool focused;
  bool shaded;
  Window pager_win;
  int pager_x;
  int pager_y;
  int pager_width;
  int pager_height;
  int desktop_nr;
  bool sticky;
};

struct DesktopList {
    Window win;
    int desktop_nr;
    int x;
    int y;
    int width;
    int height;
  };


class ToolWindow : public Basewindow, public TimeoutHandler {

public:
  ToolWindow(int argc,char **argv,struct CMDOPTIONS *);
  ~ToolWindow(void);

  XGCValues gcv;
  GC frameGC;

  Window framewin;
  Resource *resource;
  int desktop_nr;

    /* bbkeys */
    Window win_title;
    Window win_back;
    Window win_closeBtn;
    Window win_configBtn;

    KEY_GRAB_INSTRUCTION grabSet;
    unsigned int ValidModMask;
    unsigned int _NumLockMask;
    unsigned int _ScrollLockMask;
    char *bbkeys_rcfile;
    time_t bbkeys_rcTime;
    void loadKeygrabs(void);
    void setKeygrabs(void);
    void activateKeygrabs(void);
    void getOffendingModifiers(void);
    void wHackedGrabKey(int, unsigned int, Window, Bool, int, int);
    int translateAction(char *);
    int translateModifier(char *);
    char *index_to_name(int);
    void x_reset_modifier_mapping(Display *);
    void InitializeModifiers(void);
    void Redraw(void);
    virtual void timeout(void);
    void CycleWindowFocus(bool);
    void execCommand(char *);

/* end bbkeys */

  LinkedList<WindowList> *windowList;
  LinkedList<DesktopList> *desktopList;

  void MakeWindow(bool);
  void addDesktopWindow(struct DesktopList *,bool);
  void addFrameWindow(struct WindowList *,Window,bool);
  void removeDesktopWindow(void);
  void reconfigure(void);
  int getDesktop(Window);
  int getWindowGeometry(struct WindowList *);
  void changeDesktop(int);
  void sendClientMessage(int);
  void removeWindow(Window);
  void changeWindow(Window);
  void raiseWindow(Window);
  void lowerWindow(Window);
  void focusWindow(Window);
  void desktopChange(int );
  int winOnDesktop(Window);
  bool isIcon(Window);
  void changeWinDesktop(Window,int);
  void moveWinToDesktop(Window,DesktopList *);
  int getCurrentDesktopNr(void) { return current_desktop_nr; }
  int getNumberOfDesktops(void) { return number_of_desktops; }
  void setNumberOfDesktops(int n) { number_of_desktops=n; }

  void setNETInit(void) { wm_init = True; }
  struct PIXMAP getPixmap(void) { return pixmap; }
  Resource *getResource(void) { return resource; }

protected:
  virtual void process_event(XEvent *);
  virtual void CheckConfig(void);
  
private:

  bool raised;
  bool lower;
  bool wm_init;
  int day,month,year;
  int number_of_desktops;
  int current_desktop_nr;
  PIXMAP  pixmap;
  GEOM frame;
  GEOM label;
  GEOM lbutton;
  GEOM rbutton;
/* bbkeys */
    Window focus_window;
    GEOM geom_title;
    GEOM geom_back;
    GEOM geom_closeBtn;
    GEOM geom_configBtn;
    BTimer *timer;
/* end bbkeys */

  fd_set rfds;
  char **iargv;
  int iargc;
  int row_last,column_last;
  
  Window focuswin;
  
  WMInterface *wminterface;


};

#endif /* __MAIN_HH */



