/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef BOXCHECK_H
#define BOXCHECK_H


#include "global.h"
#include "senddata.h"

#include <qobject.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qaccel.h>
#include <qheader.h>
#include <qpushbutton.h>
#include <qlist.h>
#include <qglist.h>
#include <qlistbox.h>
#include <qlistview.h>
#include <qcombobox.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlineedit.h>



class KIntLineEdit;
class Channel;


class DlgTransfer : public QDialog
{
   Q_OBJECT;
public:
   DlgTransfer( const QString & board, int nr);
   ~DlgTransfer();

	void getInfo( QString & board, QString & mbx, int & lt );

private:
   QLineEdit *le_board, *le_mbx;
   KIntLineEdit *eLt;
   QLabel *lAt, *lTInfo, *lLt;
   QPushButton *btnSend, *btnAbort;
};


class DlgSetLT : public QDialog
{
   Q_OBJECT;
public:
   DlgSetLT( const char *board, int nr );
   ~DlgSetLT();

   int getLT();

public slots:
   void slotReturn();

private:
   KIntLineEdit *eNewLt;
   QLabel *lNewLt, *lLtInfo;
   QPushButton *btnSend, *btnAbort;

   int newlt;
};


class BoxCheckEntry : public QListViewItem
{
public:
   BoxCheckEntry( QListView *parent, const QString & line, const QString & sender, const QString & rubrik, int nr, int bytes, int lt );
   ~BoxCheckEntry();

   QString key( int col, bool absteigend ) const;

   const QString & getBoardName();
   const QString & getSender();
   int getMailNr();
	int getLifetime();

private:
	QString board, sender;
   int nr;
   int lt;
   int size;
};


class BoxCheckWin : public QDialog, SendData
{
   Q_OBJECT;

public:
   BoxCheckWin( Channel *chan );
   ~BoxCheckWin();

	void setFields( int fields );
	void setNewFont();

   void addEntry( const QString & line, const QString & sender, const QString & rubrik, int nr, int bytes, int lt );
   void clear();
	void setData( s_boxcheck *data );
	void setData( int type, char *title );

   // Interface fuer das Hauptprogramm
	void showWindow();
	void proceed( char *rxdata, int len );
	void readData( const char *desc );

public slots:
	void slotSend();
	void slotReadCmd(QListViewItem *item);
   void slotChangeSorting( const QString & string );
	void slotTransClicked();
	void slotSetLTClicked();
	void slotReadClicked();
	void slotEraseClicked();
   void slotReplyClicked();
   void slotCommentClicked();

private:
	QListView *liste;
   QComboBox *cmbSort;
   QLabel *lSort;
   QAccel *aLt, *aTr, *aR, *aE;
   Channel *chan;

   int status;
   int wronglines;
   bool titelFound;
   bool checkAll;

   int type;
   s_boxcheck *data;

   QPushButton *btnSend, *btnAbort;
   QPushButton *btnTrans, *btnSetLT, *btnRead, *btnErase, *btnReply, *btnComment;
};



/*class BoxCheck : QObject
{
   Q_OBJECT;
public:
   BoxCheck( Channel *widget );
   ~BoxCheck();

   void readData( const char *desc );
   void proceed( char *str, int len );
   void showWindow();
	void setNewFont();

public slots:
   void sendString( char *str );
   void sendString( const QString & str );

private:
   s_boxcheck *data;
   int status;
   bool checkAll;
   int wronglines;
   bool titelFound;
   Channel *chan;

   BoxCheckWin *win;
};

*/


#endif

