/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *                                                                              
 * As a special exception, you have permission to link this program             
 * with the Qt library and distribute executables, as long as you               
 * follow the requirements of the GNU GPL in regard to all of the               
 * software in the executable aside from Qt.                                    
 */
//---------------------------------------------------------------------------
#include "cfg.h"
#include "global.h"
#include "toolbox.h"
//---------------------------------------------------------------------------
#include <kconfig.h>
#include <kglobal.h>

#include <qfile.h>
#include <qtextstream.h>

#include <stdlib.h>
#include <stdio.h>
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
AwayInfo::AwayInfo()
{
	sAction = "";
   sText = "";
}
//---------------------------------------------------------------------------
AwayInfo::AwayInfo( const QString & action, const QString & text )
{
	sAction = action;
   sText = text;
}
//---------------------------------------------------------------------------
AwayInfo::~AwayInfo()
{
}
//---------------------------------------------------------------------------
const QString & AwayInfo::getAction()
{
	return sAction;
}
//---------------------------------------------------------------------------
const QString & AwayInfo::getText()
{
	return sText;
}
//---------------------------------------------------------------------------
void AwayInfo::setAction( const QString & action )
{
	sAction = action;
}
//---------------------------------------------------------------------------
void AwayInfo::setText( const QString & text )
{
	sText= text;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
Config::Config( KConfig *kconfig )
{
   int i;


	// Alle Varialben initialisieren
	qso_font = QFont( "courier", 12 );
	tx_font = QFont( "courier", 12 );
	bc_font = QFont( "courier", 12 );
   gpg_font = QFont( "courier", 12 );
   flags = CFG_STANDARD;
   ports = "";
   txMycall = "";
	listenCalls = NULL;
	discCalls = NULL;
   rxBuffer = 1000;
   txBuffer = 100;
   colornr[CFG_COLOR_RX] = COLOR_DARKGREEN;
	colornr[CFG_COLOR_TX] = COLOR_BLUE;
	colornr[CFG_COLOR_STATUS] = COLOR_RED;
	colornr[CFG_COLOR_GPG] = COLOR_DARKMAGENTA;
	colornr[CFG_COLOR_BG] = COLOR_WHITE;
	colornr[CFG_COLOR_TXWIN] = COLOR_BLACK;
	colornr[CFG_COLOR_TXWINBG] = COLOR_WHITE;
   colornr[CFG_COLOR_MARKBACK] = COLOR_DARKBLUE;
   colornr[CFG_COLOR_MARKFORE] = COLOR_WHITE;
	colornr[CFG_COLOR_CL_INF] = COLOR_BLACK;
	colornr[CFG_COLOR_CL_SETUP] = COLOR_DARKGREEN;
	colornr[CFG_COLOR_CL_DISC] = COLOR_RED;
	colornr[CFG_COLOR_CL_FILETRANS] = COLOR_BLACK;

   lastpref = -1;
   txwinsize = 30;
	umbruchpos = 78;
	tbarflg = BARFLG_SHOW;
	tbarpos = BARPOS_LEFT;
   rblocksize = 2;		// 2kbyte Blocksize
   gpgId = NULL;
   sign = "";
   conncalls.clear();

   for (i=0; i<10; i++)
		callKey[i] = NULL;

 	// 10 leere Strings einfuegen.
	shortcuts << "" << "" << "" << "" << "" << "" << "" << "" << "" << "";



   // Verzeichnisse festlegen
   doDirectories();


	// Schriften einlesen
   cfgReadFonts( kconfig );
	cfgReadTerminal( kconfig );
	cfgReadAX25( kconfig );
   cfgReadBuffersizes( kconfig );
	cfgReadColors( kconfig );
   cfgReadSounds( kconfig );
	cfgReadScreen( kconfig );
	cfgReadFiletransfer( kconfig );
	cfgReadShortcuts( kconfig );
   cfgReadCallkey( kconfig );
	cfgReadDirectories( kconfig );

	// Verzeichnisse setzen
   lastDirUp = dirUp;
   lastDirDown = dirDown;
   lastDir7plus = dir7plus;
   lastDirABin = dirABin;

   cfgReadGnuPG( kconfig );
   cfgReadLastConn( kconfig );
   cfgReadAway( kconfig );
}
//---------------------------------------------------------------------------
Config::~Config()
{
}
//---------------------------------------------------------------------------
// Setzt die Standard-Verzeichnisse.
//
// Neu: Der Standard ist nicht mehr .kde/share/apps/linkt sondern .linkt
// im Home-Verzeichnis. Das ist wohl doch etwas einfacher zu merken denke
// ich.
void Config::doDirectories()
{
   localdir = getenv("HOME")+QString("/.linkt");

	globaldir = "";

   dirUp = localdir + "/up";
   dirDown = localdir + "/down";
   dir7plus = localdir + "/7plus";
   dirABin = localdir + "/abin";
}
//---------------------------------------------------------------------------
void Config::cfgReadFonts( KConfig *kconfig )
{
	QString tmp;
	QFont fTmp;
   bool ok;


	kconfig->setGroup( "Fonts" );

	tmp = kconfig->readEntry("qsoWin");
   if (!tmp.isEmpty())
   {
		fTmp = decodeFontInfo( tmp, ok );
      if (ok)
      	qso_font = fTmp;
	}

	tmp = kconfig->readEntry("txWin");
   if (!tmp.isEmpty())
   {
		fTmp = decodeFontInfo( tmp, ok );
      if (ok)
      	tx_font = fTmp;
	}

	tmp = kconfig->readEntry("boxCheck");
   if (!tmp.isEmpty())
   {
		fTmp = decodeFontInfo( tmp, ok );
      if (ok)
      	bc_font = fTmp;
	}

	tmp = kconfig->readEntry("gpgWindow");
   if (!tmp.isEmpty())
   {
		fTmp = decodeFontInfo( tmp, ok );
      if (ok)
      	gpg_font = fTmp;
	}
}
//---------------------------------------------------------------------------
void Config::cfgReadTerminal( KConfig *kconfig )
{
	QString tmp;


	kconfig->setGroup( "Terminal" );

   // Terminal-SID anzeigen (true) oder verstecken (false)?
	tmp = kconfig->readEntry("showTSID");
   if (!tmp.isEmpty())
   {
		if (tmp.toInt() != 0)
			flags |= CFG_SHOWTSID;
		else
			flags &= ~CFG_SHOWTSID;
	}

	tmp = kconfig->readEntry("useLogbook");
   if (!tmp.isEmpty())
   {
		if (tmp.toInt() != 0)
			flags |= CFG_USELOG;
		else
			flags &= ~CFG_USELOG;
	}
}
//---------------------------------------------------------------------------
void Config::cfgReadAX25( KConfig *kconfig )
{
	QString tmp;


	kconfig->setGroup( "AX.25" );

	tmp = kconfig->readEntry("sendcall");
   if (!tmp.isEmpty())
		txMycall = tmp;

	tmp = kconfig->readEntry("ports");
	if (!tmp.isEmpty())
		ports = tmp;

	tmp = kconfig->readEntry("listenToCalls");
   if (!tmp.isEmpty())
		listenCalls = decodeCallList( tmp, listenCalls );

	tmp = kconfig->readEntry("disconCalls");
   if (!tmp.isEmpty())
		discCalls = decodeCallList( tmp, discCalls );

	tmp = kconfig->readEntry("autoIncSSID");
   if (!tmp.isEmpty())
   {
		if (tmp.toInt() != 0)
			flags |= CFG_INCSSID;
		else
			flags &= ~CFG_INCSSID;
	}
}
//---------------------------------------------------------------------------
void Config::cfgReadBuffersizes( KConfig *kconfig )
{
	QString tmp;


	kconfig->setGroup("Buffersizes" );

	tmp = kconfig->readEntry("receive");
   if (!tmp.isEmpty())
		rxBuffer = tmp.toInt();

	tmp = kconfig->readEntry("transmit");
   if (!tmp.isEmpty())
		txBuffer = tmp.toInt();
}
//---------------------------------------------------------------------------
void Config::cfgReadColors( KConfig *kconfig )
{
	QString tmp;
   bool ok;
   int i;


	kconfig->setGroup( "Colors" );


	tmp = kconfig->readEntry("receive");
   if (!tmp.isEmpty())
   {
   	i = tmp.toInt( &ok );
      if (ok) setColor( CFG_COLOR_RX, i );
	}

	tmp = kconfig->readEntry("transmit");
   if (!tmp.isEmpty())
   {
   	i = tmp.toInt( &ok );
      if (ok) setColor( CFG_COLOR_TX, i );
	}

	tmp = kconfig->readEntry("status");
   if (!tmp.isEmpty())
   {
   	i = tmp.toInt( &ok );
      if (ok) setColor( CFG_COLOR_STATUS, i );
	}

	tmp = kconfig->readEntry("gpg");
   if (!tmp.isEmpty())
   {
   	i = tmp.toInt( &ok );
      if (ok) setColor( CFG_COLOR_GPG, i );
	}

	tmp = kconfig->readEntry("background");
   if (!tmp.isEmpty())
   {
   	i = tmp.toInt( &ok );
      if (ok) setColor( CFG_COLOR_BG, i );
	}

	tmp = kconfig->readEntry("txwin");
   if (!tmp.isEmpty())
   {
   	i = tmp.toInt( &ok );
      if (ok) setColor( CFG_COLOR_TXWIN, i );
	}

	tmp = kconfig->readEntry("txbackground");
   if (!tmp.isEmpty())
   {
   	i = tmp.toInt( &ok );
      if (ok) setColor( CFG_COLOR_TXWINBG, i );
	}

	tmp = kconfig->readEntry("qsoMarkColor");
   if (!tmp.isEmpty())
   {
   	i = tmp.toInt( &ok );
      if (ok) setColor( CFG_COLOR_MARKFORE, i );
	}

	tmp = kconfig->readEntry("qsoMarkBackground");
   if (!tmp.isEmpty())
   {
   	i = tmp.toInt( &ok );
      if (ok) setColor( CFG_COLOR_MARKBACK, i );
	}
}
//---------------------------------------------------------------------------
void Config::cfgReadSounds( KConfig *kconfig )
{
	int i;
   QString tmp;


   for (i=0; i<SOUNDCOUNT; i++)
   	sounds.append("");

	kconfig->setGroup( "Sound" );

	tmp = kconfig->readEntry( "connSetup" );
   if (!tmp.isEmpty())
		setSound( SOUND_CONN_SETUP, tmp );

	tmp = kconfig->readEntry( "connIn" );
   if (!tmp.isEmpty())
		setSound( SOUND_CONN_IN, tmp );

	tmp = kconfig->readEntry( "connOut" );
   if (!tmp.isEmpty())
		setSound( SOUND_CONN_OUT, tmp );

	tmp = kconfig->readEntry( "connClosed" );
   if (!tmp.isEmpty())
		setSound( SOUND_CONN_CLOSED, tmp );

	tmp = kconfig->readEntry( "ring" );
   if (!tmp.isEmpty())
		setSound( SOUND_RING, tmp );

	tmp = kconfig->readEntry( "fileStart" );
   if (!tmp.isEmpty())
		setSound( SOUND_FILE_START, tmp );

	tmp = kconfig->readEntry( "fileReady" );
   if (!tmp.isEmpty())
		setSound( SOUND_FILE_READY, tmp );

	tmp = kconfig->readEntry( "fileAbort" );
   if (!tmp.isEmpty())
		setSound( SOUND_FILE_ABORT, tmp );
}
//---------------------------------------------------------------------------
void Config::cfgReadScreen( KConfig *kconfig )
{
	QString tmp;
   bool ok;


	kconfig->setGroup( "Screen" );

	tmp = kconfig->readEntry("LastPref");
   if (!tmp.isEmpty())
   {
		lastpref = tmp.toInt( &ok );
		if (!ok) lastpref = -1;
	}

	tmp = kconfig->readEntry("allowANSI");
   if (!tmp.isEmpty())
	{
		if (tmp.toInt() != 0)
      	flags |= CFG_ALLOWANSI;
		else
			flags &= ~CFG_ALLOWANSI;
	}

	tmp = kconfig->readEntry("txWinOben");
   if (!tmp.isEmpty())
   {
		if (tmp.toInt() != 0)
			flags |= CFG_TXWINOBEN;
		else
      	flags &= ~CFG_TXWINOBEN;
	}

	tmp = kconfig->readEntry("txWinSize");
   if (!tmp.isEmpty())
	{
		txwinsize = tmp.toInt( &ok );
		if (txwinsize == 0 || txwinsize > 100 || !ok)
			txwinsize = 30;
	}

	// Kanal-Fenster beim Disconnect schliessen?
	tmp = kconfig->readEntry("closeWinOnDisc");
   if (!tmp.isEmpty())
	{
		if (tmp.toInt() != 0)
			flags |= CFG_CLOSEWINDISC;
		else
			flags &= ~CFG_CLOSEWINDISC;
	}

	// Kanal-Fenster beim Kanalwechsel verstecken?
	tmp = kconfig->readEntry("hideWinOnSwitch");
   if (!tmp.isEmpty())
   {
		if (tmp.toInt() != 0)
      	flags |= CFG_HIDEWINSWITCH;
		else
			flags &= ~CFG_HIDEWINSWITCH;
	}

	// Neue Connects sofort anzeigen?
	tmp = kconfig->readEntry("openChannelWin");
   if (!tmp.isEmpty())
	{
		if (tmp.toInt() != 0)
			flags |= CFG_OPENCHANWIN;
		else
			flags &= ~CFG_OPENCHANWIN;
	}

	// Lokales Echo?
	tmp = kconfig->readEntry("localEcho");
   if (!tmp.isEmpty())
	{
		if (tmp.toInt() != 0)
      	flags |= CFG_LOCALECHO;
		else
			flags &= ~CFG_LOCALECHO;
	}

	// Piepen, wenn CTRL-G empfangen wurde?
	tmp = kconfig->readEntry("beepCtrlG");
   if (!tmp.isEmpty())
	{
		if (tmp.toInt() != 0)
			flags |= CFG_BEEPCTRLG;
		else
         flags &= ~CFG_BEEPCTRLG;
	}

	// Zeilenumbruch
	tmp = kconfig->readEntry("lineBreak");
   if (!tmp.isEmpty())
	{
		if (tmp.toInt() != 0)
         flags |= CFG_UMBRUCH;
		else
			flags &= ~CFG_UMBRUCH;
	}

	// Position des Zeilenumbruchs
	tmp = kconfig->readEntry("lineBreakPos");
   if (!tmp.isEmpty())
	{
   	umbruchpos = tmp.toInt( &ok );
      if (umbruchpos == 0 || !ok)
			umbruchpos = 78;
	}

	// Buttonbar
	tmp = kconfig->readEntry("tbarFlg");
   if (!tmp.isEmpty())
		tbarflg = tmp.toInt();

	tmp = kconfig->readEntry("tbarPos");
   if (!tmp.isEmpty())
		tbarpos = tmp.toInt();
}
//---------------------------------------------------------------------------
void Config::cfgReadFiletransfer( KConfig *kconfig )
{
	QString tmp;
   bool ok;


	kconfig->setGroup( "Filetransfer" );

	// Schon vorhandene Files ueberschreiben?
	tmp = kconfig->readEntry("overwriteExisting");
   if (!tmp.isEmpty())
   {
		if (tmp.toInt() != 0)
      	flags |= CFG_OVERWRITEXIST;
		else
      	flags &= ~CFG_OVERWRITEXIST;
	}

	tmp = kconfig->readEntry("yappResume");
   if (!tmp.isEmpty())
   {
		if (tmp.toInt() != 0)
			flags |= CFG_YAPPRESUME;
		else
			flags &= ~CFG_YAPPRESUME;
	}

	tmp = kconfig->readEntry("didaditBlocksize");
   if (!tmp.isEmpty())
	{
		rblocksize = tmp.toInt( &ok );
		if (rblocksize < 1 || rblocksize > 8 || !ok)
			rblocksize = 2;
	}
}
//---------------------------------------------------------------------------
void Config::cfgReadShortcuts( KConfig *kconfig )
{
	int i;
   QString tmp;


   kconfig->setGroup( "Shortcuts" );

   for (i=0;i<10;i++)
   {
      tmp.sprintf("CTRL%i", i);
      shortcuts[i] = kconfig->readEntry(tmp);
   }
}
//---------------------------------------------------------------------------
void Config::cfgReadCallkey( KConfig *kconfig )
{
	int i;
   QString tmp;


   kconfig->setGroup("CallKey");

   for (i=0;i<10;i++)
   {
   	tmp.sprintf("F%i", i);
      tmp = kconfig->readEntry(tmp);
      if (!tmp.isEmpty())
      {
			callKey[i] = (s_callKey *) malloc(sizeof(s_callKey));
			strcpy(callKey[i]->call, tmp.latin1());
         tmp.sprintf("ssid%i", i);
			tmp = kconfig->readEntry(tmp);
         if (!tmp.isEmpty())
				callKey[i]->ssid = tmp.toInt() != 0;
			else
				callKey[i]->ssid = false;
		}
   }
}
//---------------------------------------------------------------------------
void Config::cfgReadDirectories( KConfig *kconfig )
{
	QString tmp;


   kconfig->setGroup("Directories");

   tmp = kconfig->readEntry("7plus");
   if (!tmp.isEmpty())
      dir7plus = tmp;

   tmp = kconfig->readEntry("abin");
   if (!tmp.isEmpty())
      dirABin = tmp;

	tmp = kconfig->readEntry("down");
   if (!tmp.isEmpty())
		dirDown = tmp;

   tmp = kconfig->readEntry("up");
   if (!tmp.isEmpty())
      dirUp = tmp;
}
//---------------------------------------------------------------------------
void Config::cfgReadGnuPG( KConfig *kconfig )
{
	QString tmp;


   kconfig->setGroup("GnuPG");

	tmp = kconfig->readEntry("enable");
	if (!tmp.isEmpty())
 	{
		if (tmp.toInt() != 0)
			flags |= CFG_GPGSUPPORT;
		else
			flags &= ~CFG_GPGSUPPORT;
	}

	tmp = kconfig->readEntry("import");
   if (!tmp.isEmpty())
	{
		if (tmp.toInt() != 0)
			flags |= CFG_GPGIMPORTKEYS;
		else
			flags &= CFG_GPGIMPORTKEYS;
	}

	tmp = kconfig->readEntry("askImport");
   if (!tmp.isEmpty())
	{
		if (tmp.toInt() != 0)
			flags |= CFG_GPGASKIMPORTKEYS;
		else
			flags &= ~CFG_GPGASKIMPORTKEYS;
	}

	tmp = kconfig->readEntry("useKey");
   if (!tmp.isEmpty())
		gpgId = (char *) strdup( tmp.latin1() );
	if (gpgId == NULL)
		gpgId = (char *) strdup( "" );

	tmp = kconfig->readEntry("addSignature");
   if (!tmp.isEmpty())
		if (tmp.toInt() != 0)
			flags |= CFG_GPGADDSIG;
		else
			flags &= ~CFG_GPGADDSIG;

	tmp = kconfig->readEntry("signature");
   if (!tmp.isEmpty())
		sign = tmp;
}
//---------------------------------------------------------------------------
void Config::cfgReadLastConn( KConfig *kconfig )
{
	int i;
   bool ready=false;
   QString tmp;


   kconfig->setGroup( "LastConnectCalls" );

   i = 0;
   do
   {
	   tmp.sprintf("%i", i);
      i++;

      tmp = kconfig->readEntry(tmp);
      if (tmp.isEmpty())
      	ready = true;
 		else
		   conncalls.append( tmp.upper() );
 	} while (!ready);
}
//---------------------------------------------------------------------------
// Away-Texte aus localDir+"/away.dat" auslesen (Format: UTF-8)
void Config::cfgReadAway( KConfig * )
{
	QFile f(localdir+"/away.dat");
   QString str, action;
   unsigned int i;


   if (f.open(IO_ReadOnly))
   {
      QTextStream t( &f );
      while ( !t.eof() )
      {
      	str = t.readLine();
         if (str[0] == '#') continue;

         if (str[0] == ' ')
         {
            if (!action.isEmpty())
				   awaylist.append( AwayInfo(action.stripWhiteSpace().utf8(), str.stripWhiteSpace().utf8()) );
				action = "";
         }

         action = str;
      }
   }

   if (awaylist.count() == 0)
   {
	   awaylist.append( AwayInfo(i18n("here"), i18n("I'm back again... [%a]")) );
	   awaylist.append( AwayInfo(i18n("essen"), i18n("Ich bin mal eben essen... [%a]")) );
	   awaylist.append( AwayInfo(i18n("telefon"), i18n("Mal eben telefonieren... [%a]")) );
	}

   // "here" muss vorhanden sein.
   for (i=0; i<awaylist.count(); i++)
   	if (awaylist[i].getAction() == i18n("here"))
      	break;

   if (i == awaylist.count())
	   awaylist.insert( awaylist.begin(), AwayInfo(i18n("here"), i18n("I'm back again... [%a]")) );
}

//---------------------------------------------------------------------------
QFont Config::decodeFontInfo( QString & str, bool & ok )
{
	char family[500], flags[100];
   int size;
   char *tmp, tmp2[500];
   int i, len;
   static QFont font;


   ok = false;

   tmp = (char *) strdup( str.latin1() );

   if ((i = POS(',', tmp)) == -1)
   {
		free( tmp );
      return QFont();
   }

   len = strlen( tmp );
   memcpy( family, tmp, i );
   family[i] = '\0';
   len -= i+1;
   memmove( tmp, tmp+i+1, len );
   tmp[len] = '\0';

   if ((i = POS(',', tmp)) == -1)
   {
   	free( tmp );
      return QFont();
   }

   memcpy( tmp2, tmp, i );
   tmp2[i] = '\0';
   size = atoi( tmp2 );
   len -= i+1;
   memmove( flags, tmp+i+1, len );
   flags[len] = '\0';

   free( tmp );


   font = QFont( family, size );

   if (POS('B', flags) != -1)
   	font.setBold( true );
	if (POS('I', flags) != -1)
   	font.setItalic( true );
   if (POS('U', flags) != -1)
      font.setUnderline( true );
	if (POS('S', flags) != -1)
   	font.setStrikeOut( true );

 	ok = true;
   return font;
}
//---------------------------------------------------------------------------
s_listCalls * Config::decodeCallList( QString & text, s_listCalls * list )
{	// TODO: Neu mit QString
   char tmp[500], str[500];
   int i;
   s_listCalls *tmpcall;


   strcpy(str, text.latin1());
   while (str[0] != '\0')
   {
      if ((i = POS(',',str)) != -1)
      {
         COPY(tmp, str, 0, i);
         COPY(str, str, i+1, strlen(str)-i-1);
      }
      else
      {
         strcpy(tmp,str);
         str[0] = '\0';
      }

      // Neuer Eintrag in die Liste
      if (list == NULL)
      {
         list = (s_listCalls *)malloc(sizeof(s_listCalls));
         tmpcall = list;
      }
      else
      {
         tmpcall = list;
         while (tmpcall->next != NULL) tmpcall = tmpcall->next;
         tmpcall->next = (s_listCalls *)malloc(sizeof(s_listCalls));
         tmpcall = tmpcall->next;
      }

      tmpcall->next = NULL;
      tmpcall->call = (char *) strdup(tmp);
   }

   return list;
}
//---------------------------------------------------------------------------
QFont Config::qsoFont()
{
	return qso_font;
}
//---------------------------------------------------------------------------
QFont Config::txFont()
{
	return tx_font;
}
//---------------------------------------------------------------------------
QFont Config::bcFont()
{
	return bc_font;
}
//---------------------------------------------------------------------------
QFont Config::gpgFont()
{
	return gpg_font;
}
//---------------------------------------------------------------------------
void Config::setQsoFont( const QFont & font )
{
	qso_font = font;
}
//---------------------------------------------------------------------------
void Config::setTxFont( const QFont & font )
{
	tx_font = font;
}
//---------------------------------------------------------------------------
void Config::setBcFont( const QFont & font )
{
	bc_font = font;
}
//---------------------------------------------------------------------------
void Config::setGpgFont( const QFont & font )
{
	gpg_font = font;
}
//---------------------------------------------------------------------------
QString Config::localDir()
{
	return localdir;
}
//---------------------------------------------------------------------------
void Config::setLocalDir( QString dir )
{
	localdir = dir;
}
//---------------------------------------------------------------------------
QString Config::globalDir()
{
	return globaldir;
}
//---------------------------------------------------------------------------
void Config::setGlobalDir( QString dir )
{
	globaldir = dir;
}
//---------------------------------------------------------------------------
const QString & Config::getStartDirUp()
{
	return dirUp;
}
//---------------------------------------------------------------------------
const QString & Config::getDirUp()
{
	return lastDirUp;
}
//---------------------------------------------------------------------------
void Config::setDirUp( const QString & dir )
{
	lastDirUp = dir;
}
//---------------------------------------------------------------------------
const QString & Config::getStartDirDown()
{
	return dirDown;
}
//---------------------------------------------------------------------------
const QString & Config::getDirDown()
{
	return lastDirDown;
}
//---------------------------------------------------------------------------
void Config::setDirDown( const QString & dir )
{
	lastDirDown = dir;
}
//---------------------------------------------------------------------------
const QString & Config::getStartDir7plus()
{
	return dir7plus;
}
//---------------------------------------------------------------------------
const QString & Config::getDir7plus()
{
	return lastDir7plus;
}
//---------------------------------------------------------------------------
void Config::setDir7plus( const QString & dir )
{
	lastDir7plus = dir;
}
//---------------------------------------------------------------------------
const QString & Config::getStartDirABin()
{
	return dirABin;
}
//---------------------------------------------------------------------------
const QString & Config::getDirABin()
{
	return lastDirABin;
}
//---------------------------------------------------------------------------
void Config::setDirABin( const QString & dir )
{
	lastDirABin = dir;
}
//---------------------------------------------------------------------------
const char * Config::getGpgID()
{
	return gpgId;
}
//---------------------------------------------------------------------------
void Config::setGpgID( const char *key )
{
	if (gpgId != NULL)
   	free( gpgId );
	gpgId = (char *) strdup( key );
}
//---------------------------------------------------------------------------
QString Config::getSig()
{
	return sign;
}
//---------------------------------------------------------------------------
void Config::setSig( QString sig )
{
	sign = sig;
}
//---------------------------------------------------------------------------
void Config::setListenCalls( s_listCalls *calls )
{
	listenCalls = calls;
}
//---------------------------------------------------------------------------
void Config::setDiscCalls( s_listCalls *calls )
{
   discCalls = calls;
}
//---------------------------------------------------------------------------
s_listCalls * Config::getListenCalls()
{
	return listenCalls;
}
//---------------------------------------------------------------------------
s_listCalls * Config::getDiscCalls()
{
	return discCalls;
}
//---------------------------------------------------------------------------
void Config::setStartDirUp( const QString & dir )
{
	dirUp = dir;
	lastDirUp = dir;
}
//---------------------------------------------------------------------------
void Config::setStartDirDown( const QString & dir )
{
	dirDown = dir;
	lastDirDown = dir;
}
//---------------------------------------------------------------------------
void Config::setStartDir7plus( const QString & dir )
{
	dir7plus = dir;
	lastDir7plus = dir;
}
//---------------------------------------------------------------------------
void Config::setStartDirABin( const QString & dir )
{
	dirABin = dir;
	lastDirABin = dir;
}
//---------------------------------------------------------------------------
void Config::setSound( int id, const QString & file )
{
   sounds[id] = file;
}
//---------------------------------------------------------------------------
const QString & Config::getSound( int id )
{
	if (id > (int)sounds.count()-1)
   	return QString::null;

   QStringList::Iterator it = sounds.at( id );

   return *it;
}
//---------------------------------------------------------------------------
bool Config::getFlag( int flag )
{
   return (flags & flag);
}
//---------------------------------------------------------------------------
void Config::setFlag( int flag, bool enable )
{
	if (enable)
   	flags |= flag;
	else
   	flags &= ~flag;
}
//---------------------------------------------------------------------------
int Config::getTxWinSize()
{
	return txwinsize;
}
//---------------------------------------------------------------------------
void Config::setTxWinSize( int size )
{
	txwinsize = size;
}
//---------------------------------------------------------------------------
int Config::getColor( int nr )
{
	if (nr < 0 || nr >= CFG_COLORCOUNT)
   	return -1;
	return colornr[nr];
}
//---------------------------------------------------------------------------
void Config::setColor( int nr, int id )
{
	if (nr < 0 || nr >= CFG_COLORCOUNT)
   	return;

	colornr[nr] = id;
}
//---------------------------------------------------------------------------
int Config::getTbarPos()
{
	return tbarpos;
}
//---------------------------------------------------------------------------
void Config::setTbarPos( int pos )
{
	tbarpos = pos;
}
//---------------------------------------------------------------------------
int Config::getTbarFlg()
{
	return tbarflg;
}
//---------------------------------------------------------------------------
void Config::setTbarFlg( int flg )
{
	tbarflg = flg;
}
//---------------------------------------------------------------------------
int Config::getRBlocksize()
{
	return rblocksize;
}
//---------------------------------------------------------------------------
void Config::setRBlocksize( int size )
{
	rblocksize = size;
}
//---------------------------------------------------------------------------
s_callKey * Config::getCallKey( int id )
{
	return callKey[id];
}
//---------------------------------------------------------------------------
void Config::setCallKey( int id, const QString & ccall, bool ssid )
{
	int i;
   QString call = ccall;


	if (callKey[id] == NULL)
		callKey[id] = (s_callKey *) malloc(sizeof(s_callKey));

	if (!ssid)
   	if ((i = call.find('-')) > -1)
      	call.truncate(i);

	strncpy( callKey[id]->call, call.latin1(), 9 );
	callKey[id]->ssid = ssid;
}
//---------------------------------------------------------------------------
void Config::delCallKey( int id )
{
	if (callKey[id] == NULL) return;

   free( callKey[id] );
   callKey[id] = NULL;
}
//---------------------------------------------------------------------------
const QString & Config::getPorts()
{
	return ports;
}
//---------------------------------------------------------------------------
void Config::setPorts( const QString & p )
{
	ports = p;
}
//---------------------------------------------------------------------------
const QString & Config::getTxMycall()
{
	return txMycall;
}
//---------------------------------------------------------------------------
void Config::setTxMycall( const QString & m )
{
	txMycall = m;
}
//---------------------------------------------------------------------------
int Config::getRxBuffersize()
{
	return rxBuffer;
}
//---------------------------------------------------------------------------
void Config::setRxBuffersize( int size )
{
	rxBuffer = size;
}
//---------------------------------------------------------------------------
int Config::getTxBuffersize()
{
	return txBuffer;
}
//---------------------------------------------------------------------------
void Config::setTxBuffersize( int size )
{
	txBuffer = size;
}
//---------------------------------------------------------------------------
const QString & Config::getShortcut( int id )
{
	return shortcuts[id];
}
//---------------------------------------------------------------------------
void Config::setShortcut( int id, const QString & string )
{
	shortcuts[id] = string;
}
//---------------------------------------------------------------------------
int Config::getUmbruchPos()
{
	return umbruchpos;
}
//---------------------------------------------------------------------------
void Config::setUmbruchPos( int pos )
{
   umbruchpos = pos;
}
//---------------------------------------------------------------------------
void Config::saveFlagToFile( KConfig *kconfig, int flag, const QString & key, bool enable )
{
	if (enable)
		kconfig->writeEntry( key, "1" );
	else
		kconfig->writeEntry( key, "0" );

   setFlag( flag, enable );
}
//---------------------------------------------------------------------------
void Config::saveColorToFile( KConfig *kconfig, int flag, const QString & key, int value )
{
	QString tmp;

printf("save color %s to %i\n", key.latin1(), value);

   tmp.sprintf("%i", value );
	kconfig->writeEntry( key, tmp );

   setColor( flag, value );
}
//---------------------------------------------------------------------------
int Config::getLastPref()
{
	return lastpref;
}
//---------------------------------------------------------------------------
void Config::setLastPref( int pref )
{
	lastpref = pref;
}
//---------------------------------------------------------------------------
const QStringList & Config::getConnList()
{
	return conncalls;
}
//---------------------------------------------------------------------------
void Config::saveConnList()
{
	KConfig *kconfig = KGlobal::config();
	QString tmp;
   int i;


   kconfig->setGroup( "LastConnectCalls" );

   i = 0;
   for (QStringList::Iterator it = conncalls.begin(); it != conncalls.end(); it++)
   {
   	tmp.sprintf("%i", i);
      i++;
      kconfig->writeEntry( tmp, (*it) );
   }

   kconfig->sync();
}
//---------------------------------------------------------------------------
void Config::addConnEntry( const QString & call )
{
	if (conncalls.contains(call) > 0)
      conncalls.remove( call );

   conncalls.insert( conncalls.begin(), call );

   if (conncalls.count() > 30) conncalls.remove( conncalls.at(29) );
}
//---------------------------------------------------------------------------
const QValueList<AwayInfo> & Config::getAway()
{
	return awaylist;
}
//---------------------------------------------------------------------------
void Config::setAway( const QValueList<AwayInfo> & list )
{
	awaylist = list;
}
//---------------------------------------------------------------------------
const QString & Config::getAwayText( int id )
{
	if (id > (int)awaylist.count())
   	return "";

	return awaylist[id].getText();
}
//---------------------------------------------------------------------------

