 /*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "dialog.h"
#include "dialog.moc"

#include <qfiledialog.h>
#include <qbuttongroup.h>

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <time.h>

#include "version.h"
#include "ax25k.h"
#include "bin.h"
#include "toolbox.h"
#include "global.h"
#include "cfg.h"

#include <qtimer.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qframe.h>
#include <qlayout.h>
#include <qaccel.h>

#include <kmessagebox.h>
#include <kiconloader.h>
#include <kstddirs.h>
#include <kapp.h>
//---------------------------------------------------------------------------
#define BTNWIDTH 80
#define BTNHEIGHT 30
//---------------------------------------------------------------------------
#define CREDIT_COUNT 7
char credit_data[][500] = {"<center><b>Robert, DL1NC</b><p>German documentation, icons, betatest, ...</center>",
									"<center><b>Hans-Peter, DG4IAD</b><p>English documentation, autoconf-stuff<br>faq, betatest, ...</center>",
									"<center><b>Jonny, DH3MB</b><p>//COMP-Code</center>",
									"<center><b>Arno, PE1ICQ</b><p>Dutch language-file</center>",
									"<center><b>Jose, EA5SW</b><p>Spanish language-file</center>",
									"<center><b>Benedict, KB2QZV</b><p>Polski language-file</center>",
									"<center><b>Holger, DG3OBU</b><p>LinKT-logo</center>"};
//---------------------------------------------------------------------------
#define ABOUT_SCROLLTIME 20
#define ABOUT_WAITTIME 5000
#define ABOUT_EMPTYTIME 500
#define ABOUT_STEP 2
//---------------------------------------------------------------------------
ConnDlgValidator::ConnDlgValidator( QWidget *parent, const char *name )
		: QValidator( parent, name )
{
}
//---------------------------------------------------------------------------
ConnDlgValidator::~ConnDlgValidator()
{
}
//---------------------------------------------------------------------------
QValidator::State ConnDlgValidator::validate( QString & str, int & ) const
{
	str = str.upper();

   return QValidator::Acceptable;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
Connect::Connect( QWidget *parent ) : QDialog(parent, "ConnectDlg", true)
{
	s_ports *tmp;
	QStringList conncalls;
   QVBoxLayout *vboxmain, *vbox;
   QHBoxLayout *hbox;
	QLabel *l;
   ConnDlgValidator *validator;


	resize(300, 130);
//	setFixedSize( size() );

	vboxmain = new QVBoxLayout( this );
   vboxmain->setMargin( 5 );

	setCaption(i18n("LinKT: Connect..."));



	l = new QLabel(i18n("Call"), this);
	l->setAlignment(AlignLeft);
   vboxmain->addWidget( l );

	cmbCall = new QComboBox( true, this );
	cmbCall->setFocus();
   cmbCall->setAutoCompletion( true );
   vboxmain->addWidget( cmbCall );

   validator = new ConnDlgValidator( this );
   cmbCall->setValidator( validator );

	// Die zuletzt connecteten Rufzeichen in die Call-Combobox eintragen
	conncalls = conf->getConnList();
	for (QStringList::Iterator it = conncalls.begin(); it != conncalls.end(); ++it)
		cmbCall->insertItem( *it );
	cmbCall->setEditText( "" );

   vboxmain->addSpacing( 10 );

   hbox = new QHBoxLayout( vboxmain );
   vbox = new QVBoxLayout( hbox );


	l = new QLabel("MyCall", this);
	l->setAlignment( AlignLeft );
   vbox->addWidget( l );

	edMyCall = new QLineEdit( this );
	edMyCall->setText( conf->getTxMycall() );
   vbox->addWidget( edMyCall );


   hbox->addStretch( 1 );
   vbox = new QVBoxLayout( hbox );


	l = new QLabel("Port", this);
	l->setAlignment( AlignLeft );
   vbox->addWidget( l );


	cmbPorts = new QComboBox( this );
	// Hier werden alle vorhandenen Portnamen in die Combobox eingetragen
	tmp = portlist;
	while (tmp != NULL)
	{
		if (tmp->ax25 != NULL)
			cmbPorts->insertItem(tmp->name);
		tmp = tmp->next;
	}
	vbox->addWidget( cmbPorts );



	vboxmain->addSpacing( 20 );
   vboxmain->addStretch( 1 );

	hbox = new QHBoxLayout( vboxmain );

   hbox->addStretch( 1 );

	btnOk = new QPushButton(i18n("&Ok"), this);
	btnOk->resize( BTNWIDTH, BTNHEIGHT );
	connect( btnOk, SIGNAL(clicked()), this, SLOT(accept()) );
	btnOk->setDefault( true );
   hbox->addWidget( btnOk );

   hbox->addStretch( 1 );


	btnAbort = new QPushButton(i18n("&Abort"), this);
	btnAbort->resize( BTNWIDTH, BTNHEIGHT );
	connect( btnAbort, SIGNAL(clicked()), this, SLOT(reject()) );
   hbox->addWidget( btnAbort );

   hbox->addStretch( 1 );


	a = new QAccel( this );
	a->connectItem( a->insertItem(Key_Return), this, SLOT(accept()) );


   // TODO:
   // QWhatsThis-Eintraege fuer diesen Dialog

   // Port-QComboBox
//   QWhatsThis::add( cmbPorts, i18n("Bla blub <i>enter</i>.") );
	// Zielcall-QComboBox
//   QWhatsThis::add( cmbCall, i18n("Bla blub <i>enter</i>.") );
	// MyCall-QLineEdit
//   QWhatsThis::add( edMyCall, i18n("Bla blub <i>enter</i>.") );
}
//---------------------------------------------------------------------------
const QString Connect::getText()
{
   return cmbCall->currentText().upper();
}
//---------------------------------------------------------------------------
const QString Connect::getPort()
{
	return cmbPorts->currentText();
}
//---------------------------------------------------------------------------
const QString Connect::getMycall()
{
   return edMyCall->text();
}
//---------------------------------------------------------------------------
Connect::~Connect()
{
   delete a;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
AboutDlg::AboutDlg(QWidget *parent) : QDialog(parent, i18n("About"), TRUE)
{
	QPixmap pm;
	QLabel *l;
	QString s;
   QVBoxLayout *vbox = new QVBoxLayout( this );
   QHBoxLayout *hbox;
   QString logo = locate("data", "linkt/pics/linktlogo.jpg");


	resize( 380, 245 );
   if (logo.isEmpty())
		resize( 380, 200 );
   else
   	resize( 380, 350 );

	setCaption(i18n("About LinKT..."));


	l = new QLabel("XX", this);
	l->setPixmap( QPixmap(logo) );

   vbox->addWidget( l, 0, Qt::AlignCenter );

   if (logo.isEmpty())
		l = new QLabel("LinKT V" LINKT_VERSION " (" DATE ")", this);
	else
		l = new QLabel("V" LINKT_VERSION " (" DATE ")", this);
	l->setFont( QFont("Helvetica", 18, QFont::Normal) );

	vbox->addWidget( l, 0, Qt::AlignCenter );
	vbox->addSpacing( 10 );

   l = new QLabel( "Copyright (C) 1997-2001 Jochen T.- Sarrazin, DG6VJ", this );

   vbox->addWidget( l, 0, Qt::AlignCenter );
   vbox->setMargin( 5 );


   hbox = new QHBoxLayout( vbox );

   hbox->addStretch( 1 );

   url = new KURLLabel( this );
   url->setText("jochen@1409.org");
   connect( url, SIGNAL(leftClickedURL()), SLOT(slotSendEMail()) );

   hbox->addWidget( url );

   l = new QLabel( ", dg6vj@db0nos.#nrw.deu.eu", this );

   hbox->addWidget( l, 0, Qt::AlignCenter );

   hbox->addStretch( 1 );


   QFrame *frame = new QFrame( this );
   frame->setFixedSize( 300, 70 );
   frame->setFrameStyle( QFrame::Box | QFrame::Plain );

   vbox->addWidget( frame, 0, Qt::AlignCenter );

   frameWidget = new QWidget( frame );
   frameWidget->setGeometry( 1, 1, frame->width()-2, frame->height()-2 );


   credit = new QLabel( frameWidget );
   credit->resize( frameWidget->width(), frameWidget->height() );
   credit->setAlignment( Qt::AlignVCenter );

   creditid = 0;
   displayCreditID( creditid );


   timer = new QTimer( this );
   connect( timer, SIGNAL(timeout()), SLOT(slotDataShow()) );
   timer->start( ABOUT_SCROLLTIME, false);

	vbox->addSpacing( 10 );

	QPushButton *b_ok = new QPushButton(i18n("&Ok"), this);

	b_ok->setDefault(true);
	connect(b_ok, SIGNAL(clicked()), this, SLOT(accept()));
	b_ok->setFocus();

	vbox->addWidget( b_ok, 0, Qt::AlignCenter );


   resize( vbox->minimumSize() );
}
//---------------------------------------------------------------------------
void AboutDlg::slotSendEMail()
{
   kapp->invokeMailer( url->text(), QString::null );
}
//---------------------------------------------------------------------------
void AboutDlg::slotDataShow()
{
	if (credit->y() >= 0)
   {
      timer->stop();

	   disconnect( timer, SIGNAL(timeout()), this, SLOT(slotDataShow()) );
		connect( timer, SIGNAL(timeout()), SLOT(slotDataWait()) );

      // Den Text 5 Sekunden anzeigen
      timer->start( ABOUT_WAITTIME, true );
      return;
	}

   credit->move( 0, credit->y()+ABOUT_STEP );
}
//---------------------------------------------------------------------------
void AboutDlg::slotDataWait()
{
	timer->stop();

	// Ok, Text ist lange genug angezeigt worden. Wieder ausblenden
	disconnect( timer, SIGNAL(timeout()), this, SLOT(slotDataWait()) );
	connect( timer, SIGNAL(timeout()), SLOT(slotDataAway()) );

	timer->start( ABOUT_SCROLLTIME, false );
}
//---------------------------------------------------------------------------
void AboutDlg::slotDataAway()
{
	if (credit->y() >= credit->height())
   {
      timer->stop();

		disconnect( timer, SIGNAL(timeout()), this, SLOT(slotDataAway()) );
		connect( timer, SIGNAL(timeout()), SLOT(slotDataEmpty()) );

      // Eine 3/4 Sekunde keinen Text anzeigen
      timer->start( ABOUT_EMPTYTIME, true );
      return;
	}

   credit->move( 0, credit->y()+ABOUT_STEP );
}
//---------------------------------------------------------------------------
void AboutDlg::slotDataEmpty()
{
	timer->stop();

	// Ok, naechster Text
	creditid++;
   if (creditid >= CREDIT_COUNT)
   	creditid = 0;

   displayCreditID( creditid );

	disconnect( timer, SIGNAL(timeout()), this, SLOT(slotDataEmpty()) );
	connect( timer, SIGNAL(timeout()), SLOT(slotDataShow()) );
   timer->start( ABOUT_SCROLLTIME, false);
}
//---------------------------------------------------------------------------
void AboutDlg::displayCreditID( int id )
{
   credit->setText( credit_data[id] );
   credit->move( 0, -credit->height()  );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
AwayDlg::AwayDlg( QWidget *parent ) : QDialog( parent, "AwayDlg", true )
{
   QButtonGroup *tmpbtngrp;
   QVBoxLayout *vboxMain, *vbox;
   QHBoxLayout *hbox;
   unsigned int i;
   QValueList<AwayInfo> away;


   setCaption( "LinKT: Away" );
   resize( 200, 250 );

   vboxMain = new QVBoxLayout( this );
   vboxMain->setMargin( 5 );

   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(i18n ("You are"));

   vboxMain->addWidget( tmpbtngrp, 1 );
   vboxMain->addSpacing( 10 );

   vbox = new QVBoxLayout( tmpbtngrp );
   vbox->setMargin( 5 );
   vbox->addSpacing( 10 );

   lbAction = new QListBox( tmpbtngrp );
   vbox->addWidget( lbAction );

   away = conf->getAway();
   for (i=0; i<away.count(); i++)
		lbAction->insertItem( away[i].getAction() );

   hbox = new QHBoxLayout( vboxMain );

   hbox->addStretch( 1 );

   btnOk = new QPushButton( i18n("&Ok"), this );
   btnOk->setDefault( true );
   connect( btnOk, SIGNAL(clicked()), SLOT(slotOkClicked()) );
   hbox->addWidget( btnOk );

   hbox->addStretch( 1 );

   btnAbort = new QPushButton( i18n("&Abort"), this );
   connect( btnAbort, SIGNAL(clicked()), SLOT(reject()) );
   hbox->addWidget( btnAbort );

   hbox->addStretch( 1 );

	QAccel *a = new QAccel( this );
	a->connectItem( a->insertItem(Key_Return), this, SLOT(slotOkClicked()) );

   lbAction->setCurrentItem( config->awayStatus );
   lbAction->setFocus();
}
//---------------------------------------------------------------------------
AwayDlg::~AwayDlg()
{
}
//---------------------------------------------------------------------------
void AwayDlg::slotOkClicked()
{
	if (config->awayStatus != lbAction->currentItem())
   {
		config->awayStatus = lbAction->currentItem();
		config->awayTime = time( NULL );
		emit awayDataChanged();
	}
	accept();
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
DlgYAPP::DlgYAPP( QWidget *parent, const char *name ) : QDialog( parent, name, true )
{
	QLabel *l;
   QVBoxLayout *vboxMain = new QVBoxLayout( this );
   QHBoxLayout *hbox;


   setCaption( i18n("YAPP-RX") );

   vboxMain->setMargin( 10 );

   l = new QLabel( this );
   l->setText( i18n("You can enter a filename for the received file. If you don't enter one, the received name will be use.<br>Please note: Not every station will send one!") );
   vboxMain->addWidget( l );

   vboxMain->addSpacing( 5 );

   lFName = new QLabel( i18n("Filename"), this );
   vboxMain->addWidget( lFName );

   hbox = new QHBoxLayout( vboxMain );

   filename = new QLineEdit( this );
   hbox->addWidget( filename, 1 );

   browse = new QPushButton( this );
   browse->setText( i18n("browse...") );
   connect( browse, SIGNAL(clicked()), this, SLOT(slotBrowseFile()) );
   hbox->addWidget( browse );

   vboxMain->addSpacing( 10 );

   hbox = new QHBoxLayout( vboxMain );

   hbox->addStretch( 1 );

   btnok = new QPushButton( this );
   btnok->setText( i18n("&Ok") );
   btnok->setFocus();
   connect(btnok, SIGNAL(clicked()), this, SLOT(accept()));
   hbox->addWidget( btnok );

   hbox->addStretch ( 1 );

   btnabort = new QPushButton( this );
   btnabort->setText( i18n("&Abort") );
   connect(btnabort, SIGNAL(clicked()), this, SLOT(reject()));
   hbox->addWidget( btnabort );

   hbox->addStretch( 1 );

   resize( vboxMain->sizeHint() );
}
//---------------------------------------------------------------------------
DlgYAPP::~DlgYAPP()
{
}
//---------------------------------------------------------------------------
void DlgYAPP::getFilename( QString & name )
{
	name = filename->text();
}
//---------------------------------------------------------------------------
void DlgYAPP::slotBrowseFile()
{
   char tmp[2000];


	strcpy(tmp, conf->getDirABin());
	QString f = QFileDialog::getSaveFileName(tmp);

	strcpy(tmp, (const char *)f);

	// Cancel
	if (f.isEmpty()) return;

	if (file_exist(tmp))
	{
		if (KMessageBox::warningYesNo( this,
											i18n("The specified file already exists. Overwrite?"),
        									i18n("Overwrite?"),
											i18n("&Yes"),
											i18n("&No")) != KMessageBox::Yes)
		return;
	}

	filename->setText( tmp );
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
DlgPasswordAdd::DlgPasswordAdd( QWidget *parent )
			: QDialog( parent, "DlgPasswordAdd", true )
{
	QVBoxLayout *vboxmain = new QVBoxLayout( this );
	QHBoxLayout *hbox;
	QButtonGroup *tmpbtngrp;
	QGridLayout *grid;
	QLabel *l;


   vboxmain->setMargin( 5 );
   vboxmain->setSpacing( 5 );

	tmpbtngrp = new QButtonGroup( this );
	tmpbtngrp->setFrameStyle( 49 );
	tmpbtngrp->setAlignment( 1 );
	tmpbtngrp->lower();
//	tmpbtngrp->setTitle(i18n ("You are"));
	vboxmain->addWidget( tmpbtngrp );


	grid = new QGridLayout( tmpbtngrp, 2, 2 );

	l = new QLabel( i18n("Type"), tmpbtngrp );
   grid->addWidget( l, 0, 0 );
	l = new QLabel( i18n("Command"), tmpbtngrp );
   grid->addWidget( l, 0, 1 );
   cmbType = new QComboBox( tmpbtngrp );
   grid->addWidget( cmbType, 1, 0 );
   edCmd = new QLineEdit( tmpbtngrp );
   grid->addWidget( edCmd, 1, 1 );


   // Das eigentliche Passwort
   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle( i18n("Password") );
	vboxmain->addWidget( tmpbtngrp );

   grid = new QGridLayout( tmpbtngrp, 3, 2 );
   grid->addRowSpacing( 0, 15 );
   grid->addRowSpacing( 2, 10 );
   grid->setMargin( 5 );

   edPwd = new QLineEdit( tmpbtngrp );
   grid->addWidget( edPwd, 1, 0 );
   btnImport = new QPushButton( i18n("Import"), tmpbtngrp );
   grid->addWidget( btnImport, 1, 1 );



   hbox = new QHBoxLayout( vboxmain );

   // Buttons am unteren Ende
   btnOk = new QPushButton( i18n("&Ok"), this, "btnOk" );
   connect( btnOk, SIGNAL(clicked()), SLOT(btnOkClicked()) );
   btnAbort = new QPushButton( i18n("&Cancel"), this, "btnAbort" );
   connect( btnAbort, SIGNAL(clicked()), SLOT(reject()) );
   btnHelp = new QPushButton( i18n("&Help"), this, "btnHelp" );
   connect( btnHelp, SIGNAL(clicked()), SLOT(btnHelpClicked()) );

	hbox->addStretch( 1 );
   hbox->addWidget( btnHelp );
   hbox->addSpacing( 10 );
   hbox->addWidget( btnOk );
   hbox->addWidget( btnAbort );
}
//---------------------------------------------------------------------------
DlgPasswordAdd::~DlgPasswordAdd()
{
}
//---------------------------------------------------------------------------
void DlgPasswordAdd::btnOkClicked()
{
}
//---------------------------------------------------------------------------
void DlgPasswordAdd::btnHelpClicked()
{
}
//---------------------------------------------------------------------------

