/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef PREF_H
#define PREF_H

#include "global.h"
#include "ax25k.h"
#include "toolbox.h"
#include "gpg.h"

#include <qdialog.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qtabwidget.h>
#include <qradiobutton.h>
#include <qstring.h>
#include <qlabel.h>
#include <qslider.h>
#include <qmultilineedit.h>

#include <kconfig.h>

//---------------------------------------------------------------------------
class AwayInfo;
class TopLevel;
//---------------------------------------------------------------------------
// Basis-Klasse fuer alle Preferences-Klassen
class PrefWidget : public QWidget
{
	Q_OBJECT;
public:
	PrefWidget( QWidget *parent, const QString & caption );
   ~PrefWidget();

	virtual void save( KConfig *kconfig ) = 0;
   virtual void createPrefWidget() = 0;
   bool isCreated();
   void setCreated();

   const QString & getCaption();

signals:
	void awayDataChanged();

private:
	QString caption;
   bool created;
};
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
class PrefAway : public PrefWidget
{
	Q_OBJECT;
public:
   PrefAway( QWidget *parent, const QString & caption );
   ~PrefAway();

	void save( KConfig * );
	void createPrefWidget();

public slots:
	void slotSetText( int id );
   void slotReturnPressed();
	void slotNewEntry();
   void slotDeleteEntry();

private:
	QValueList<AwayInfo> texte;
   QComboBox *cmbAction;
   QLineEdit *edText;
   QPushButton *btnDelete, *btnNew;
   int currentEntry;
   QString startAction;
};
//---------------------------------------------------------------------------
class PrefSound : public PrefWidget
{
	Q_OBJECT;
public:
   PrefSound( QWidget *parent, const QString & caption );
   ~PrefSound();

	void save( KConfig *kconfig );
   void createPrefWidget();

public slots:
	void slotSelEvent( int id );
	void slotSelSound( QListBoxItem *item );
   void slotTest();

private:
	QComboBox *cmbEvent;
   QListBox *lbFiles;
   QPushButton *btnTest;
   int eventSound[SOUNDCOUNT];
};
//---------------------------------------------------------------------------
class PrefFiles : public PrefWidget
{
	Q_OBJECT;
public:
   PrefFiles( QWidget *parent, const QString & caption );
   ~PrefFiles();

	void save( KConfig * );
   void createPrefWidget();

public slots:
   void slotImportCText();
   void slotImportQText();
   void slotImportHelp();
   void slotImportInfo();
   void slotImportNews();
   void slotCTextChanged();
   void slotQTextChanged();
   void slotHelpChanged();
   void slotInfoChanged();
   void slotNewsChanged();

private:
   QMultiLineEdit *ctext, *qtext, *info, *help, *news;
   QPushButton *ctext_imp, *qtext_imp, *info_imp, *help_imp, *news_imp;
   QWidget *ctext_widg, *qtext_widg, *info_widg, *help_widg, *news_widg;
   bool ctextChanged, qtextChanged, infoChanged, helpChanged, newsChanged;
};
//---------------------------------------------------------------------------
class PrefCallKey : public PrefWidget
{
	Q_OBJECT;
public:
   PrefCallKey( QWidget *parent, const QString & caption );
   ~PrefCallKey();

	void save( KConfig *kconfig );
   void createPrefWidget();

private:
   QLineEdit *f_keys[10];
   QCheckBox *ssid[10];
};
//---------------------------------------------------------------------------
class PrefDirs : public PrefWidget
{
	Q_OBJECT;
public:
   PrefDirs( QWidget *parent, const QString & caption );
   ~PrefDirs();

	void save( KConfig *kconfig );
   void createPrefWidget();

private:
   QLineEdit *abin, *splus, *down, *up;
};
//---------------------------------------------------------------------------
class PrefTerminal : public PrefWidget
{
	Q_OBJECT;
public:
   PrefTerminal( QWidget *parent, const QString & caption );
   ~PrefTerminal();

	void save( KConfig *kconfig );
   void createPrefWidget();

private:
	QCheckBox *cmbLog, *cmbShowTSID;
};
//---------------------------------------------------------------------------
class PrefQSOWin : public PrefWidget
{
	Q_OBJECT;
public:
   PrefQSOWin( QWidget *parent, const QString & caption );
   ~PrefQSOWin();

	void save( KConfig *kconfig );
   void createPrefWidget();

public slots:
	void slotSliderMoved( int value );
	void slotToggleUmbruch( bool active );


private:
   KIntLineEdit *rxSize, *txSize;
   QRadioButton *rxTop, *rxBottom;
   QLabel *lPercent;
   QSlider *slider;
   QCheckBox *chkbUmbruch;
   KIntLineEdit *ledPos;
};
//---------------------------------------------------------------------------
class PrefShortcuts : public PrefWidget
{
	Q_OBJECT;
public:
   PrefShortcuts( QWidget *parent, const QString & caption );
   ~PrefShortcuts();

	void save( KConfig *kconfig );
   void createPrefWidget();

private:
   QLineEdit *f_keys[12];
};
//---------------------------------------------------------------------------
class PrefScreen : public PrefWidget
{
	Q_OBJECT;
public:
   PrefScreen( QWidget *parent, const QString & caption );
   ~PrefScreen();

	void save( KConfig *kconfig );
   void createPrefWidget();

private:
	QCheckBox *chkbCloseWin, *chkbHideWin, *chkbLocalEcho, *chkbBeep;
   QCheckBox *chkbOpenWin;
};
//---------------------------------------------------------------------------
class PrefGnuPG : public PrefWidget
{
	Q_OBJECT;
public:
   PrefGnuPG( QWidget *parent, const QString & caption );
   ~PrefGnuPG();

	void save( KConfig *kconfig );
   void createPrefWidget();

public slots:
	void slotEnableToggled( bool toggled );
	void slotImportToggled( bool toggled );
   void slotSigToggled( bool toggled );
	void slotGpgKey( s_GPGKey *gkey );

private:
	QCheckBox *enable, *import, *askImport, *addSig;
   QLineEdit *edSig;
   QComboBox *cmbSecKey;
   GPGKeys *gpgkey;
   const char *key;
};
//---------------------------------------------------------------------------
class PrefFonts : public PrefWidget
{
	Q_OBJECT;
public:
   PrefFonts( QWidget *parent, const QString & caption );
   ~PrefFonts();

	void save( KConfig *kconfig );
   void createPrefWidget();

public slots:
	void slotQsoFontChange();
	void slotTxFontChange();
	void slotBCheckFontChange();
   void slotGPGFontChange();

private:
	char * getFontString( const QFont & font );

	QLabel *lQso, *lTx, *lBcheck, *lGPG;
   QPushButton *btnQso, *btnTx, *btnBcheck, *btnGPG;
   QFont fQso, fTx, fBcheck, fGPG;
};
//---------------------------------------------------------------------------
class PrefColors : public PrefWidget
{
	Q_OBJECT;
public:
   PrefColors( QWidget *parent, const QString & caption );
   ~PrefColors();

	void save( KConfig *kconfig );
   void createPrefWidget();

private:
   QTabWidget *tabs;

   QWidget *qso, *tx, *marked, *chanlist;

   QComboBox *rxwin_color, *txwin_color, *status_color, *background_color;
   QComboBox *gpg_color;
   QCheckBox *qsowin_bold, *txwin_bold, *mark_bold;
   QComboBox *txtext_color, *txbackground_color;
   QComboBox *mark_color, *mark_background;
   QCheckBox *allowANSI;
   QComboBox *chanlistInf, *chanlistSetup, *chanlistDisc, *chanlistFiletrans;
};
//---------------------------------------------------------------------------
class PrefFiletransfer : public PrefWidget
{
	Q_OBJECT;
public:
   PrefFiletransfer( QWidget *parent, const QString & caption );
   ~PrefFiletransfer();

	void save( KConfig *kconfig );
   void createPrefWidget();

private:
   QCheckBox *overwriteExisting, *allowYappResume;
   QComboBox *RBlocksize;
};
//---------------------------------------------------------------------------
class MyIfaceCheckItem : public QCheckListItem
{
public:
	MyIfaceCheckItem( QListView *parent, s_ports *port );
   ~MyIfaceCheckItem();

   QString getBaud();
   QString getMaxframe();
   QString getDesc();
   s_ports * getPort();

private:
	QString sBaud, sMaxframe, sDesc;
   s_ports *port;
};
//---------------------------------------------------------------------------
class PrefInterfaces : public PrefWidget
{
	Q_OBJECT;
public:
	PrefInterfaces( QWidget *parent, const QString & caption );
   ~PrefInterfaces();

   void save( KConfig *kconfig );
   void createPrefWidget();

public slots:
	void slotSelChanged( QListViewItem *item );

private:
	QListView *list;
   QLabel *lSpeed, *lMaxframe, *lDesc;
};
//---------------------------------------------------------------------------
class PrefCalls : public PrefWidget
{
	Q_OBJECT;
public:
   PrefCalls( QWidget *parent, const QString & caption );
   ~PrefCalls();

   void save( KConfig *kconfig );
   void createPrefWidget();

private:
   QLineEdit *sendcall, *listencall, *disconcall;
   QListBox *listencalls, *disconcalls;
   QPushButton *addlistenbtn, *dellistenbtn, *adddisconbtn, *deldisconbtn;
   QCheckBox *incrementssid;

	void addListenCallToPorts(const char *call);
	bool callIsInList(const char *call, s_listCalls *list);
	void deleteDroppedCalls(s_listCalls *akt, s_listCalls *old);
	void deleteListenCallToPorts(const char *call);

public slots:
	void addListenCall();
	void delListenCall();
	void addDisconCall();
	void delDisconCall();
	void slotChangeDiscCall( QListBoxItem *item );
	void slotChangeListenCall( QListBoxItem *item );
	void saveListenToCalls(KConfig *kconfig);
	void saveIgnoredCalls(KConfig *kconfig);
};
//---------------------------------------------------------------------------
class ListCategory : public QListViewItem
{
public:
   ListCategory( QListViewItem *parent, QString text, PrefWidget *window, int id );
   ListCategory( QListView *parent, QString text, PrefWidget *window, int id );
   ~ListCategory();

	PrefWidget *win;
   int id;
};
//---------------------------------------------------------------------------
class Preferences : public QDialog
{
	Q_OBJECT;
public:
	Preferences( TopLevel *parent );
   ~Preferences();

public slots:
	void slotSave();
	void slotCategoryChanged( QListViewItem *item );
	void slotHelp();

private:
	QListView *category;
   QPushButton *cancel, *ok, *help;
   PrefWidget *currentWidget;

   PrefCalls *calls;
   PrefInterfaces *ifaces;
   PrefFiletransfer *filetrans;
   PrefColors *colors;
   PrefFonts *fonts;
   PrefShortcuts *shortcuts;
   PrefGnuPG *gpg;
   PrefScreen *screen;
   PrefQSOWin *qsoWin;
   PrefTerminal *terminal;
   PrefDirs *dirs;
   PrefCallKey *callkey;
   PrefFiles *files;
   PrefSound *sound;
   PrefAway *away;
};




#endif

