/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "queuelist.h"
#include "queuelist.moc"

#include "filetransfer.h"
#include "channel.h"

#include <kmessagebox.h>

#include <qlayout.h>
//---------------------------------------------------------------------------
#define BTNWIDTH 90
#define BTNHEIGHT 30
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
SendQueueListItem::SendQueueListItem( QListView *listview, QListViewItem *after, s_sqentry *entry, s_sqentry *last )
				: QListViewItem( listview, after )
{
	char tmp[50];


	this->entry = entry;
   this->last = last;

	switch (entry->type)
	{
		case SQTYPE_FILE:
         setText( 0, ((s_sqfile *)entry->data)->fname );
         sprintf( tmp, "%i", ((s_sqfile *)entry->data)->size );
         setText( 1, tmp );
         setText( 2, i18n("Textfile") );
      	break;
		case SQTYPE_FTRANS:
      	setText( 0, ((s_sqtrprot *)entry->data)->fname );
         sprintf( tmp, "%i", ((s_sqtrprot *)entry->data)->size );
         setText( 1, tmp );
         switch (((s_sqtrprot *)entry->data)->proto)
         {
         	case FTPROT_ABIN:
         		setText( 2, i18n("AutoBIN") );
					break;
				case FTPROT_DIDADIT:
         		setText( 2, i18n("DIDADIT") );
					break;
				case FTPROT_7PLUS:
         		setText( 2, i18n("7plus-Autosend") );
					break;
				case FTPROT_YAPP:
         		setText( 2, i18n("YAPP") );
					break;
				default:
         		setText( 2, i18n("Unknown protocol") );
         }
			break;
	}
}
//---------------------------------------------------------------------------
SendQueueListItem::~SendQueueListItem()
{
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
SendQueueList::SendQueueList( QWidget *parent, Channel *chan ) : QDialog( parent, 0, true )
{
	s_sqentry *sqtmp, *sqlast=NULL;
   QListViewItem *last=NULL;
   QHBoxLayout *hbox;
   QVBoxLayout *vbox;


   setCaption( i18n("LinKT: Sendqueue") );

   this->chan = chan;

   vbox = new QVBoxLayout( this );
   vbox->setMargin( 5 );
   vbox->setSpacing( 5 );

	liste = new QListView( this );
   liste->setAllColumnsShowFocus( true );

   liste->addColumn( i18n("Filename"), 300 );
   liste->addColumn( i18n("Size"), 50 );
   liste->addColumn( i18n("Format"), 80 );

   liste->setSorting( -1 );

   vbox->addWidget( liste );

   hbox = new QHBoxLayout( vbox );

	del = new QPushButton( this );
   del->setText( i18n("&Delete") );
   connect( del, SIGNAL(clicked()), SLOT(slotDelButton()));

	ready = new QPushButton( this );
   ready->setText( i18n("&Ready") );
   connect( ready, SIGNAL(clicked()), SLOT(accept()));

	hbox->addWidget( del );
   hbox->addStretch( 1 );
   hbox->addWidget( ready );

   // Daten einlesen
   for (sqtmp = chan->sendQueue->getRoot(); sqtmp; sqtmp = sqtmp->next)
   {
   	switch (sqtmp->type)
      {
      	case SQTYPE_FILE:
			case SQTYPE_FTRANS:
         	last = new SendQueueListItem( liste, last, sqtmp, sqlast );
         	break;
      }
      sqlast = sqtmp;
   }
}
//---------------------------------------------------------------------------
SendQueueList::SendQueueList()
{
}
//---------------------------------------------------------------------------
void SendQueueList::slotDelButton()
{
	QListViewItem *item;
   s_sqentry *entry;


	if ((item = liste->currentItem()) == NULL) return;

   entry = ((SendQueueListItem *)item)->entry;
	if (((SendQueueListItem *)item)->last == NULL)
   {
		if (KMessageBox::warningYesNoCancel( this,
					i18n("Do you really want to abort the selected transmission?"),
					i18n("Abort Transmission")) == KMessageBox::No)
			return;
	   ((SendQueueListItem *)item)->entry = ((SendQueueListItem *)item)->entry->next;
   }
   else
	   ((SendQueueListItem *)item)->last->next = ((SendQueueListItem *)item)->entry->next;

   chan->sendQueue->deleteEntry( entry );

   delete item;
}
//---------------------------------------------------------------------------

