/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef SETTINGSDLG_H
#define SETTINGSDLG_H


#include <qobject.h>
#include <qwidget.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qtabdialog.h>
#include <qcombobox.h>
#include <qcheckbox.h>

#include "toolbox.h"


class SettingsDlg : public QTabDialog
{
   Q_OBJECT;

public:
   SettingsDlg(QWidget *parent);

public slots:
   void saveEntries();
   void toggleRemoteSettings(bool status);
   void slotPwBrowse();

   void slotPwaSpecToggled(bool active);
   void slotPwaToggled(bool);
   void slotPwBayBoxToggled(bool active);
   void slotPwTheboxOldToggled(bool active);
   void slotPwFlexnetToggled(bool active);
   void slotPwMD5Toggled(bool active);
   void slotToggleUmbruch(bool active);
   void slotPwAK1AToggled(bool active);
   void slotHufAllowToggled( bool active );

   void slotIncPwLen();
   void slotDecPwLen();

private:
   QWidget *chan;
   QWidget *conf_settings, *conf_remotes, *conf_password, *winOthers;

   int saveWithSsidFlag;

   void generateConfSettingsWidget();
   void generateConfRemotesWidget();
   void generateConfPasswordWidget();
   void generateOthersWindow();

   void setSettings();

   // conf_remotes
   QCheckBox *quit, *version, *cs, *setname, *comp, *write, *read, *info, *help;
   QCheckBox *ring, *echo, *rtt, *dir, *news, *talk, *date, *ddate, *cookie, *activity;

   // conf_settings
   QCheckBox *seven_autosave, *bin_autosave, *rec_con, *rec_discon;
   QCheckBox *autosend_pw, *remotes, *huf_allowed, *onlinecomp, *hufcomptx;
   QCheckBox *hufcomprx, *didadit, *allowANSI;
   QLineEdit *call, *name;
   QRadioButton *type_term, *type_digi, *type_bbs, *type_convers;
   QComboBox *swtype;
   // conf_password
   QRadioButton *pw_baybox, *pw_flexnet, *pw_thebox, *pw_theboxold, *pw_md5, *pw_ak1a;
   QLineEdit *pw_cmd;
   QCheckBox *pwa_pwchars, *pwa_spec, *pwa_AZ, *pwa_az, *pwa_09;
   QLineEdit *pwa_string;
   QLabel *pw_label;
   QLineEdit *pw_password;
   QPushButton *pw_browse;
   QPushButton *incAnswLen, *decAnswLen;
   KIntLineEdit *pw_answlen;
   // Others
   QCheckBox *zeilenumbruch;
   KIntLineEdit *position;
   QLabel *lUmbruch, *lBoxCheck;
   QComboBox *boxcheck_soft;
};




#endif /* SETTINGSDLG_H */
