/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * main : gnome plugin main file.
 *
 */

/* includes */

#include <gnome_gui.h> 

/* variables */

typedef struct {
  
  GtkWidget *gnome_window;
  int        inited;

} gnome_t;

/*
 * get_gui_info : MANDATORY
 *
 * Used by the plugin_center to get a pointer to the gui object.
 *
 */

xmps_gui_plugin_t *get_gui_info(void)
{
  xmps_gui_plugin_t *gui;

  gui = (xmps_gui_plugin_t *) malloc(sizeof(xmps_gui_plugin_t));
  
  gui->name = "GNOME Player";
  gui->data = malloc(sizeof(gnome_t));

  gui->init  = gnome_gui_init;
  gui->main  = gnome_gui_main;
  gui->close = gnome_gui_close;

  ((gnome_t *) gui->data)->inited = 0;

  return gui;
}

/* functions */

int gnome_gui_init(xmps_gui_plugin_t *gui, void *arg)
{
  gnome_t         *data;
  xmps_gui_data_t *gui_data;

  if(gui == NULL) {
    return 0;
  }

  data = (gnome_t *) gui->data;

  if(data == NULL) {
    return 0;
  }

  gui_data = (xmps_gui_data_t *) arg;

  XMPS_DEBUG("gnome_gui_init : argc = %d", gui_data->argc);
  
  add_pixmap_directory (SKIN_PATH);     
  add_pixmap_directory (PIXMAPS_PATH);     
 
  //bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  //textdomain(PACKAGE);

  if(!data->inited)
    { 
      XMPS_DEBUG("intitalizing GNOME with version %s", VERSION);

      gnome_init("xmps", VERSION, gui_data->argc, gui_data->argv);
      data->inited = 1;
    }

  gdk_rgb_init();

  config.session  = gui_data->session;
  config.playlist = gui_data->playlist;
  config.cfgfile  = gui_data->cfgfile;
  
  gnome_load_options();

  data->gnome_window  = gnome_window_new(gui_data->cfgfile, gui_data->shared_menu);
  config.window       = data->gnome_window;

  xmps_playback_setup_video(config.session, 1, 0, 26, ((GdkWindowPrivate *)(config.window->window))->xwindow, "SDL");
  xmps_playback_setup_audio(config.session, 1, "SDL");

  if(xmps_playlist_get_nbr_items(config.playlist))
    config.has_to_play = 1;
  else
    config.has_to_play = 0;

  return 1;
}

int gnome_gui_main(xmps_gui_plugin_t *gui)
{
  gtk_widget_show(((gnome_t *) gui->data)->gnome_window);
  
  XMPS_DEBUG("adding timeout idle func");

  gtk_timeout_add(50, gnome_gui_idle, NULL);

  gtk_main();
  return 1;
}

int gnome_gui_close(xmps_gui_plugin_t *gui)
{
 gnome_t *data;

  if(gui == NULL) {
    return 0;
  }

  data = (gnome_t *) gui->data;

  if(data == NULL) {
    return 0;
  }  

  if(data->gnome_window != NULL)
    {
      gtk_widget_hide(data->gnome_window);
      gtk_main_quit();
    }
  return 1;
}




