/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  skins_draw_playlist.c
 *
 *  Functions for handling the playlist.xpm
 *  @Author : Damien Chavarria (1999)
 *
 */

/* INCLUDES */

#include "skins_draw_playlist.h"

/* FUNCTIONS */

void draw_playlist_main(GtkWidget *widget)
{
  gint dx, i;
  GdkGC *gc;
            
  dx = xmps_config.playlist_size_x - 275;

#ifdef HAVE_GDKPIXBUF

 /* le coin */  
   gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
	          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
	          2, 58,
               	  0, 26,
	          11, 18,GDK_RGB_DITHER_NONE, 0, 0);
 /* le haut */
  gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
	          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
	          15, 58,
               	  11, 26,
	          238, 18,GDK_RGB_DITHER_NONE, 0, 0);
 for (i=0; i<dx; i++)
   gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
	          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
               	  
	          15, 58,
               	  249+i, 26,
 	          1, 18,GDK_RGB_DITHER_NONE, 0, 0);
 /* les lignes */
 for (i=0; i < (xmps_config.playlist_playlist_nbr_lines - 2); i++)
   gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
	          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
               	  
	          110, 128,
               	  0, 44+(i*15),
 	          11, 15,GDK_RGB_DITHER_NONE, 0, 0);
 /* le milieu */
 /* made by draw_playlist_items */ 
 
   /* le bas */
  gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
	          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
               	  
	          2, 78,
               	  0, 44+(15*(xmps_config.playlist_playlist_nbr_lines - 2)),
	          11, 17,GDK_RGB_DITHER_NONE, 0, 0);
  gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
	          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
               	  
	          15, 78,
               	  11, 44+(15*(xmps_config.playlist_nbr_lines - 2)),
	          238, 17,GDK_RGB_DITHER_NONE, 0, 0);
 for (i=0; i<dx; i++)
   gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
	          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
               	  
	          15, 78,
               	  249+i, 44+(15*(xmps_config.playlist_nbr_lines - 2)),
 	          1, 17,GDK_RGB_DITHER_NONE, 0, 0);

  /* the buttons */

  gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
	          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
               	  
	          2, 97,
               	  0, 61+(15*(xmps_config.playlist_nbr_lines - 2)),
	          245, 29,GDK_RGB_DITHER_NONE, 0, 0);
 for (i=0; i<dx; i++)
   gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
	          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
               	  
	          247, 97,
               	  245+i, 61+(15*(xmps_config.playlist_nbr_lines - 2)),
 	          1, 29,GDK_RGB_DITHER_NONE, 0, 0);
  gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
	          widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
               	  
	          247, 97,
               	  245+dx, 61+(15*(xmps_config.playlist_nbr_lines - 2)),
	          30, 29,GDK_RGB_DITHER_NONE, 0, 0);

#else

 /* le coin */
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  2, 58,
                  0, 26,
                  11, 18);
 /* le haut */
 gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  15, 58,
                  11, 26,
                  238, 18);
 for (i=0; i<dx; i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  15, 58,
                  249+i, 26,
                  1, 18);
 /* les lignes */
 for (i=0; i<(xmps_config.playlist_nbr_lines - 2); i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  110, 128,
                  0, 44+(i*15),
                  11, 15);
 /* le milieu */
 /* made by draw_playlist_items */

   /* le bas */
 gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  2, 78,
                  0, 44+(15*(xmps_config.playlist_nbr_lines - 2)),
                  11, 17);
 gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  15, 78,
                  11, 44+(15*(xmps_config.playlist_nbr_lines - 2)),
                  238, 17);
 for (i=0; i<dx; i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  15, 78,
                  249+i, 44+(15*(xmps_config.playlist_nbr_lines - 2)),
                  1, 17);

  /* the buttons */
 
 gdk_draw_pixmap(widget->window,
		 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		 playlist_pixmap,
		 2, 97,
		 0, 61+(15*(xmps_config.playlist_nbr_lines - 2)),
		 245, 29);
 for (i=0; i<dx; i++)
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  247, 97,
                  245+i, 61+(15*(xmps_config.playlist_nbr_lines - 2)),
                  1, 29);
 gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  247, 97,
                  245+dx, 61+(15*(xmps_config.playlist_nbr_lines - 2)),
                  30, 29);

#endif

 gc = gdk_gc_new(widget->window);

 gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_bgcolor.red*65536 + 
			   xmps_config.current_skin->playlist_bgcolor.green*256 + 
			   xmps_config.current_skin->playlist_bgcolor.blue);

 gdk_draw_rectangle(widget->window, gc, TRUE, 11, 44, 239+dx, 15+15*(xmps_config.playlist_nbr_lines-3));
 gdk_gc_destroy(gc);
}

void draw_playlist_titlebar(GtkWidget *widget, gint state)
{
  gint dx, i;
  
  dx = xmps_config.playlist_size_x - 275;
  switch (state)
  {
  case ACTIVE :
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   2, 2,
				   0, 0,
				   245, 26,GDK_RGB_DITHER_NONE, 0, 0);

    for (i=0; i<dx; i++)
      gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     247, 2,
				     245+i, 0,
				     1, 26,GDK_RGB_DITHER_NONE, 0, 0);

    gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   247, 2,
				   245+dx, 0,
				   30, 26,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    playlist_pixmap,
		    2, 2,
		    0, 0,
		    245, 26);
    for (i=0; i<dx; i++)
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      playlist_pixmap,
		      247, 2,
		      245+i, 0,
		      1, 26);
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    playlist_pixmap,
		    247, 2,
		    245+dx, 0,
		    30, 26);
#endif
    break;

  case INACTIVE :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   2, 30,
				   0, 0,
				   245, 26,GDK_RGB_DITHER_NONE, 0, 0);
   
    for (i=0; i<dx; i++)
      gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     247, 30,
				     245+i, 0,
				     1, 26,GDK_RGB_DITHER_NONE, 0, 0);

    gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   247, 30,
				   245+dx, 0,
				   30, 26,GDK_RGB_DITHER_NONE, 0, 0);
#else
    
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    playlist_pixmap,
		    2, 30,
		    0, 0,
		    245, 26);
    for (i=0; i<dx; i++)
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      playlist_pixmap,
		      247, 30,
		      245+i, 0,
		      1, 26);
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    playlist_pixmap,
		    247, 30,
		    245+dx, 0,
		    30, 26);
#endif
    break;
  }		 
}

void draw_playlist_progress_bar(GtkWidget *widget)
{
 gint dy, dx, i;
 dy = xmps_config.playlist_nbr_lines - 2; 
 dx = xmps_config.playlist_size_x - 275;

#ifdef HAVE_GDKPIXBUF 
 
 /* la barre */
 gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				255, 58,
				249+dx, 26,
				26, 18,GDK_RGB_DITHER_NONE, 0, 0);

 for (i=0; i<dy; i++)
   {
     gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				    123, 128,
				    249+dx,44+(15*i),
				    26, 15,GDK_RGB_DITHER_NONE, 0, 0);
   }
 
 gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				255, 78,
				249+dx, 44+15*dy,
				26, 17,GDK_RGB_DITHER_NONE, 0, 0);

#else

 /* la barre */
 gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  255, 58,
                  249+dx, 26,
                  26, 18);

 for (i=0; i<dy; i++)
  {
   gdk_draw_pixmap(widget->window,
                   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                   playlist_pixmap,
                   123, 128,
                   249+dx,44+(15*i),
                   26, 15);
  }
 gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  255, 78,
                  249+dx, 44+15*dy,
                  26, 17);


#endif
}

void draw_playlist_add_button(GtkWidget *widget, gint state)
{
 gint dy;
 
 dy = 15*(xmps_config.playlist_nbr_lines - 3); 

 switch (state)
  {
    case NORMAL :
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     2, 128,
				     5, 81+dy,
				     25, 20,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      playlist_pixmap,
		      2, 128,
		      5, 81+dy,
		      25, 20);
#endif
      break;
  case PUSHED :  
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   2, 150,
				   5, 81+dy,
				   25, 20,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    playlist_pixmap,
		    2, 150,
		    5, 81+dy,
		    25, 20);
#endif
    break;
  }
}

void draw_playlist_remove_button(GtkWidget *widget, gint state)
{
 gint dy;
 
 dy = 15*(xmps_config.playlist_nbr_lines - 3); 

 switch (state)
  {
    case NORMAL : 
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     29, 128,
				     40, 81+dy,
				     25, 20,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      playlist_pixmap,
		      29, 128,
		      40, 81+dy,
		      25, 20);
#endif
      break;
  case PUSHED : 
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   29, 150,
				   40, 81+dy,
				   25, 20,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    playlist_pixmap,
		    29, 150,
		    40, 81+dy,
		    25, 20);
#endif
    break;
  }
}

void draw_playlist_sort_button(GtkWidget *widget, gint state)
{
 gint dy;
 
 dy = 15*(xmps_config.playlist_nbr_lines - 3); 

 switch (state)
  {
  case NORMAL : 
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   56, 128,
				   75, 81+dy,
				   25, 20,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    playlist_pixmap,
		    56, 128,
		    75, 81+dy,
		    25, 20);
#endif
    break;
  case PUSHED : 
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   56, 150,
				   75, 81+dy,
				   25, 20,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    playlist_pixmap,
		    56, 150,
		    75, 81+dy,
		    25, 20);
#endif
    break;
  }
}

void draw_playlist_rand_button(GtkWidget *widget, gint state)
{
 gint dy;
 
 dy = 15*(xmps_config.playlist_nbr_lines - 3); 

 switch (state)
  {
    case NORMAL :
#ifdef HAVE_GDKPIXBUF
      gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				     widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				     83, 128,
				     110, 81+dy,
				     25, 20,GDK_RGB_DITHER_NONE, 0, 0);
#else
      gdk_draw_pixmap(widget->window,
		      widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		      playlist_pixmap,
		      83, 128,
		      110, 81+dy,
		      25, 20);
#endif
      break;
  case PUSHED :
#ifdef HAVE_GDKPIXBUF
    gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				   widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				   83, 150,
				   110, 81+dy,
				   25, 20,GDK_RGB_DITHER_NONE, 0, 0);
#else
    gdk_draw_pixmap(widget->window,
		    widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
		    playlist_pixmap,
		    83, 150,
		    110, 81+dy,
		    25, 20);
#endif
    break;
  }
}

void draw_playlist_resize(GtkWidget *widget)
{
 gint dx;
  
 dx = xmps_config.playlist_size_x - 275;

#ifdef HAVE_GDKPIXBUF
 
 gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
				151, 128,
				255 + dx, 85 +(15*(xmps_config.playlist_nbr_lines - 3)),
				15, 15,GDK_RGB_DITHER_NONE, 0, 0);
#else
 gdk_draw_pixmap(widget->window,
                 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                 playlist_pixmap,
                 151, 128,
                 255 + dx, 85 +(15*(xmps_config.playlist_nbr_lines - 3)),
                 15, 15);
#endif
}


void draw_playlist_cursor(GtkWidget *widget)
{
 gint nbr_pos, dy, dx;

 dx = xmps_config.playlist_size_x - 275;

 if (xmps_playlist_get_nbr_items(xmps_config.playlist) > xmps_config.playlist_nbr_lines)
   {
     nbr_pos = (xmps_playlist_get_nbr_items(xmps_config.playlist) - xmps_config.playlist_nbr_lines ) +1;
     
     if ((xmps_config.playlist_current_display_position == nbr_pos) || (xmps_config.playlist_nbr_lines > (xmps_playlist_get_nbr_items(xmps_config.playlist) - xmps_config.playlist_current_display_position)))
       {
#ifdef HAVE_GDKPIXBUF
	 gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
					widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
					110, 145,
					257 + dx, PLAYLIST_PROGRESS_BAR_RECT.size_y-1,
					12, 25,GDK_RGB_DITHER_NONE, 0, 0);
#else
	 gdk_draw_pixmap(widget->window,
			 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
			 playlist_pixmap,
			 110, 145,
			 257 + dx, PLAYLIST_PROGRESS_BAR_RECT.size_y-1,
			 12, 25);
#endif
       }
     else
       {
	 dy = (PLAYLIST_PROGRESS_BAR_RECT.size_y - 25) / (nbr_pos - 1);
	 
#ifdef HAVE_GDKPIXBUF
	 
	 gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
					widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
					110, 145,
					257 + dx, 26+(dy*(xmps_config.playlist_current_display_position -1)),
					12, 25,GDK_RGB_DITHER_NONE, 0, 0);
#else
	 gdk_draw_pixmap(widget->window,
			 widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
			 playlist_pixmap,
			 110, 145,
			 257 + dx, 26+(dy*(xmps_config.playlist_current_display_position -1)),
			 12, 25);
#endif
       }
   }
 else
#ifdef HAVE_GDKPIXBUF
   gdk_pixbuf_render_to_drawable (playlist_pixbuf,widget->window,
				  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
               	  	          110, 145,
				  257 + dx, 26,
				  12, 25,GDK_RGB_DITHER_NONE, 0, 0);
#else
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
                  playlist_pixmap,
                  110, 145,
                  257 + dx, 26,
                  12, 25);
#endif

}

void draw_playlist_items(GtkWidget *widget)
{
  GdkFont *font;
  gint i, dx;
  GdkGC *gc;
  gint st_length;
  
  dx = xmps_config.playlist_size_x - 275;
			
  gc = gdk_gc_new(widget->window);

  gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_bgcolor.red*65536 + 
			    xmps_config.current_skin->playlist_bgcolor.green*256 + 
			    xmps_config.current_skin->playlist_bgcolor.blue);
  
  font = gdk_font_load(g_strdup("-adobe-helvetica-bold-r-*-*-10-*"));
    
  if (xmps_config.playlist->nbr_items > xmps_config.playlist_nbr_lines)
    {
      for (i = xmps_config.playlist_current_display_position - 1; i < xmps_config.playlist_current_display_position + xmps_config.playlist_nbr_lines -1; i++)
	{
	  if (i < xmps_config.playlist->nbr_items)
	    {
	      if (xmps_playlist_get_item_at(xmps_config.playlist, i)->selected)
		{
		  gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_selected.red*65536 + 
					    xmps_config.current_skin->playlist_selected.green*256 + 
					    xmps_config.current_skin->playlist_selected.blue);
		  
		  gdk_draw_rectangle(widget->window, gc, TRUE, 10, 30+15*(i - (xmps_config.playlist_current_display_position - 1)), 242 + dx, 15);
		  
		  gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_bgcolor.red*65536 + 
					    xmps_config.current_skin->playlist_bgcolor.green*256 + 
					    xmps_config.current_skin->playlist_bgcolor.blue);
		}
	      else {
		gdk_draw_rectangle(widget->window, gc, TRUE, 10, 30+15*(i - (xmps_config.playlist_current_display_position - 1)), 242+dx, 15);
	      }
	      
	      st_length = strlen(xmps_playlist_get_item_at(xmps_config.playlist, i)->display_name) < 40 ? 
		strlen(xmps_playlist_get_item_at(xmps_config.playlist, i)->display_name) : 40;
	      
	      gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_font_color.red*65536 + 
					xmps_config.current_skin->playlist_font_color.green*256 + 
					xmps_config.current_skin->playlist_font_color.blue);
	      
	      gdk_draw_text(widget->window, font, gc, 12, 41+(i - xmps_config.playlist_current_display_position + 1)*15,
			    xmps_playlist_get_item_at(xmps_config.playlist, i)->display_name, st_length);
	      
	      gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_bgcolor.red*65536 + 
					xmps_config.current_skin->playlist_bgcolor.green*256 + 
					xmps_config.current_skin->playlist_bgcolor.blue);
	    }
	}
    }
  else
    {
      i = 0;
  
    while ((i < xmps_config.playlist->nbr_items))
      {
	
	if (xmps_playlist_get_item_at(xmps_config.playlist, i) != NULL)
	  {
	    if (xmps_playlist_get_item_at(xmps_config.playlist, i)->selected)
	      {
		gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_selected.red * 65536 + 
					  xmps_config.current_skin->playlist_selected.green * 256 + 
					  xmps_config.current_skin->playlist_selected.blue);

		gdk_draw_rectangle(widget->window, gc, TRUE, 10, 30+15*i, 242+dx, 15);
		
		gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_bgcolor.red*65536 + 
					  xmps_config.current_skin->playlist_bgcolor.green*256 + 
					  xmps_config.current_skin->playlist_bgcolor.blue);
	      }
	    else {
	      gdk_draw_rectangle(widget->window, gc, TRUE, 10, 30+15*i, 242+dx, 15);
	    }
	    
	    st_length = strlen(xmps_playlist_get_item_at(xmps_config.playlist, i)->display_name) < 40 ? 
	      strlen(xmps_playlist_get_item_at(xmps_config.playlist, i)->display_name) : 40;
	    
	    gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_font_color.red*65536 + 
				      xmps_config.current_skin->playlist_font_color.green*256 + 
				      xmps_config.current_skin->playlist_font_color.blue);
	    
	    gdk_draw_text(widget->window, font, gc, 12, 41+i*15,
			  xmps_playlist_get_item_at(xmps_config.playlist, i)->display_name, st_length);
	    
	     gdk_rgb_gc_set_foreground(gc, xmps_config.current_skin->playlist_bgcolor.red*65536 + 
				      xmps_config.current_skin->playlist_bgcolor.green*256 + 
				      xmps_config.current_skin->playlist_bgcolor.blue);

	    i++;
	  }
      }
   }
   gdk_gc_destroy(gc);

}


