/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 *  skins_pixmap.h
 *
 *  Header file for the skins pixmap location.
 *  @Author : Damien Chavarria (1999)
 *
 */

#ifndef _SKINS_PIXMAP_H
#define _SKINS_PIXMAP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_GDKPIXBUF

#include <gdk-pixbuf/gdk-pixbuf.h>

/* pixbufs */

GdkPixbuf *main_pixbuf;
GdkPixbuf *buttons_pixbuf;
GdkPixbuf *controls_pixbuf;
GdkPixbuf *digits_pixbuf;
GdkPixbuf *titlebar_pixbuf;
GdkPixbuf *playlist_pixbuf;

#else /* GDK_PIXBUF */

#include <gtk/gtk.h>

/* pixmaps */

GdkPixmap *main_pixmap;
GdkPixmap *buttons_pixmap;
GdkPixmap *controls_pixmap;
GdkPixmap *digits_pixmap;
GdkPixmap *letters_pixmap;
GdkPixmap *titlebar_pixmap;
GdkPixmap *playlist_pixmap;

#endif /* GDK_PIXBUF */

#ifdef HAVE_GNOME

GdkPixmap *logo_pixmap;

#endif

/* for loading the pixmaps */

GdkBitmap *mask;
GtkStyle  *style;

#endif

