/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * Most of this code is taken from
 * the XMMS project http://www.xmms.org
 */

/**
 *  xmps_skins_browser.c
 *
 *  Functions for handling the change skins
 *  @Author : Damien Chavarria (1999)
 *
 */

/* INCLUDES */

#include "xmps_skin_browser.h"
#include <string.h>
#include <stdio.h>

/* FUNCTIONS */


gint skinwin_delete_event(GtkWidget * widget, GdkEvent * event, gpointer data)
{
        gtk_widget_hide(skin_window);
        return (TRUE);
}

void skin_free_func(gpointer data, gpointer user_data)
{
        g_free(((struct SkinNode *) data)->name);
        g_free(((struct SkinNode *) data)->path);
        g_free(data);
}

gint skins_list_compare_func(gconstpointer a, gconstpointer b)
{
        return strcasecmp(((struct SkinNode *) a)->name, ((struct SkinNode *) b)->name);
}

void change_skin_event(GtkWidget * widget, gint row, gint column, GdkEventButton * event)
{
  if (row == 0) {
    load_default_skin(xmps_config.skinned_window->window);
    xmps_config.current_skin->name = (char *) malloc(9);
    xmps_config.current_skin->name = "(Default)";

    xmps_config.current_skin->directory = (char *) malloc(9);
    xmps_config.current_skin->directory = "(Default)";
    
  }
  else {
    /* On cpoie dans la config */
   xmps_config.current_skin->name = (char *) malloc(strlen(((struct SkinNode *) g_list_nth(skins_list, row - 1)->data)->name) +1);
   strcpy(xmps_config.current_skin->name, ((struct SkinNode *) g_list_nth(skins_list, row - 1)->data)->name);

   xmps_config.current_skin->directory = (char *) malloc(strlen(((struct SkinNode *) g_list_nth(skins_list, row - 1)->data)->path) +1);
   strcpy(xmps_config.current_skin->directory, ((struct SkinNode *) g_list_nth(skins_list, row - 1)->data)->path);


   /* et on charge */
   load_skin(((struct SkinNode *) g_list_nth(skins_list, row - 1)->data)->path, xmps_config.skinned_window->window);
  }

  draw_current_skin(xmps_config.skinned_window, 1);

  /*
   * la playlist
   */

  if(xmps_config.is_playlist_toggled) {
    
    XMPS_DEBUG("updating playlist");

    draw_playlist_main(xmps_config.playlist_window);

    if (xmps_config.playlist_has_focus)
      draw_playlist_titlebar(xmps_config.playlist_window, ACTIVE);
    else
      draw_playlist_titlebar(xmps_config.playlist_window, INACTIVE);

    draw_playlist_add_button(xmps_config.playlist_window, NORMAL);
    draw_playlist_remove_button(xmps_config.playlist_window, NORMAL);
    draw_playlist_sort_button(xmps_config.playlist_window, NORMAL);
    draw_playlist_rand_button(xmps_config.playlist_window, NORMAL);
    draw_playlist_progress_bar(xmps_config.playlist_window);
    draw_playlist_cursor(xmps_config.playlist_window);
    draw_playlist_resize(xmps_config.playlist_window);
    draw_playlist_items(xmps_config.playlist_window);
  }

}


void add_skin(gchar * skin)
{
        struct SkinNode *node = (struct SkinNode *) g_malloc(sizeof (struct SkinNode));
        gchar *tmp;

        node->path = skin;

        tmp = (gchar *) strrchr(skin, '/');
        if (!tmp)
                tmp = skin;
        node->name = (char *) g_malloc(strlen(tmp + 1) + 1);
        strcpy(node->name, tmp + 1);
        tmp = (gchar *) strrchr(node->name, '.');
        if (tmp)
        {
                if (!strcasecmp(tmp, ".zip"))
                        *tmp = '\0';
                if (!strcasecmp(tmp, ".tgz"))
                        *tmp = '\0';
                if (!strcasecmp(tmp, ".gz"))
                        *tmp = '\0';
                if (!strcasecmp(tmp, ".bz2"))
                        *tmp = '\0';
                if (!strcasecmp(tmp, ".tar"))
                        *tmp = '\0';
                tmp = (gchar *) strrchr(node->name, '.');
                if (tmp)
                {               /* maybe we still have to remove a leftover ".tar" */
                        if (!strcasecmp(tmp, ".tar"))
                                *tmp = '\0';
                }
        }
        skins_list = g_list_prepend(skins_list, node);
}

void scan_skindir(char *path)
{
  DIR *dir;
  struct dirent *dirent;
  struct stat statbuf;
  char *file, *tmp;

  dir = opendir(path);
  if (dir)
   {
    while ((dirent = readdir(dir)))
     {
      if (strcmp(dirent->d_name, ".") && strcmp(dirent->d_name, ".."))
       {
        file = (char *) g_malloc(dirent->d_reclen + strlen(path) + 2);
        sprintf(file, "%s/%s", path, dirent->d_name);
        if (!lstat(file, &statbuf))
         {
	   if (S_ISDIR(statbuf.st_mode)) {
	     
	     if(strstr(file, "default") == NULL) {
	       add_skin(file);
	     }
	   }

          else if (S_ISREG(statbuf.st_mode))
           {
            tmp = (gchar *) strrchr(file, '.');
            if (tmp)
             {
	       if (!strcasecmp(tmp, ".xmps_skin"))
		 add_skin(file);
	       else
		 g_free(file);
             }
            else
             g_free(file);
           }
          else
           g_free(file);
         }
        else
         g_free(file);
       }
     }
   closedir(dir);
 }
}

void scan_skins(void)
{
  int i;
  GList *entry;
  gchar *none = "(Default)", *str;

  if (skins_list)
  {
    g_list_foreach(skins_list, skin_free_func, NULL);
    g_list_free(skins_list);
  }
  skins_list = NULL;
  
   str = g_strconcat(g_get_home_dir(), "/.xmps/Skins", NULL);
   scan_skindir(str);
  
  str = g_strconcat(SKIN_PATH, NULL);
  scan_skindir(str);
  g_free(str);
  skins_list = g_list_sort(skins_list, skins_list_compare_func);
  gtk_clist_clear(GTK_CLIST(skin_window_list));
  
  gtk_clist_append(GTK_CLIST(skin_window_list), &none);

  if( !strcmp(xmps_config.current_skin->name, none) ) gtk_clist_select_row(GTK_CLIST(skin_window_list), 0 , 0);

  for (i = 0; i < g_list_length(skins_list); i++)
  {
    entry = g_list_nth(skins_list, i);
    gtk_clist_append(GTK_CLIST(skin_window_list), (gchar **) & ((struct SkinNode *) entry->data)->name);

    if (!strcasecmp(((struct SkinNode *) entry->data)->name, xmps_config.current_skin->name))
      gtk_clist_select_row(GTK_CLIST(skin_window_list), i+1 , 0);
  }
  gtk_clist_thaw(GTK_CLIST(skin_window_list));
}

void xmps_skin_browser_create(void)
{
	gchar *titles[1];
	GtkWidget *vbox, *hbox, *separator, *scrolled_win;

	titles[0] = "Skins available";
	skin_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(skin_window), "Skin Browser");
	gtk_signal_connect(GTK_OBJECT(skin_window), "delete_event", GTK_SIGNAL_FUNC(skinwin_delete_event), NULL);
	gtk_container_border_width(GTK_CONTAINER(skin_window), 10);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(skin_window), vbox);

	skin_window_list = gtk_clist_new_with_titles(1, titles);
	gtk_clist_column_titles_passive(GTK_CLIST(skin_window_list));
	gtk_clist_set_selection_mode(GTK_CLIST(skin_window_list), GTK_SELECTION_SINGLE);
	gtk_widget_set_usize(skin_window_list, 250, 200);
        gtk_signal_connect(GTK_OBJECT(skin_window_list), "select_row", GTK_SIGNAL_FUNC(change_skin_event), NULL);
	scrolled_win = gtk_scrolled_window_new( NULL, NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_win), skin_window_list);
	gtk_container_border_width(GTK_CONTAINER(scrolled_win), 5);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_win), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(vbox), scrolled_win, TRUE, TRUE, 0);

	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, TRUE, 0);

	hbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_SPREAD);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	close_button = gtk_button_new_with_label("Close");
	gtk_signal_connect(GTK_OBJECT(close_button), "clicked", GTK_SIGNAL_FUNC(skinwin_delete_event), NULL);
                           GTK_WIDGET_SET_FLAGS(close_button, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(hbox), close_button, FALSE, FALSE, 0);
	gtk_widget_grab_default(close_button);
}


void xmps_show_skin_browser(void)
{
	if( skins_list != NULL) 
	  gtk_clist_clear(GTK_CLIST(skins_list));
	
	scan_skins();
	
	gtk_widget_show_all(skin_window);
	gtk_widget_grab_focus(skin_window_list);
}


















