/*  XMPS - X Movie Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * libxmps_xml.c : xml-style data manipulation
 *
 */

#include <string.h>
#include <glib.h>
#include "libxmps/libxmps.h"


char *xmps_xml_get_value(char *xml_data, char *tag)
{
  char *start  = NULL;
  char *end    = NULL;
  char *result = NULL;
  char *rend   = NULL;
  int   len;
  
  if(xml_data == NULL || tag == NULL) {

    XMPS_DEBUG("null data");
    return NULL;
  }

  start = strstr(xml_data, g_strconcat("<", tag, ">", NULL));
  end   = strstr(xml_data, g_strconcat("</",tag, ">", NULL));

  if(start != NULL && end != NULL) {

    start += strlen(tag) + 2;

    /* 
     * make a copy of the substring
     */
    
    len = end - start + 1;

    result = (char *) malloc(len);

    rend = result;
    rend += len - 1;

    *rend = '\0';

    strncpy(result, start, end - start );
  
    XMPS_DEBUG("found tag");

    return result;
  }
  else {
    XMPS_DEBUG("could not found tag!");
  }

  return NULL;
}


char *xmps_xml_config_entry_int_new(char *name, int value, char *control, char *label)
{
  char *num;

  num = (char *) malloc(5);

  sprintf(num, "%d", value);
  
  return g_strconcat("<imem><name>", name, "</name><value>", num, "</value><control>", 
		     control, "</control><label>", label, "</label></item>", NULL);
}


char *xmps_xml_config_entry_string_new(char *name, char *value, char *control, char *label)
{
  return g_strconcat("<imem><name>", name, "</name><value>", value, "</value><control>", 
		     control, "</control><label>", label, "</label></item>", NULL);
}





