/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * xmps_menu.c : xmps_menu finctions.
 *
 */

/* includes */

#include <xmps_menu.h>
#include <stdlib.h>

/* functions */

xmps_menu_item_t *xmps_menu_item_new(unsigned int            id, 
				     char                   *label, 
				     xmps_menu_item_type_t   type,
				     unsigned int            group,
				     unsigned int            active)
{
  xmps_menu_item_t *item;
 
  item = (xmps_menu_item_t *) malloc(sizeof(xmps_menu_item_t));

  item->id     = id;
  item->label  = label;
  item->type   = type;
  item->group  = group;
  item->active = active;

  return item;
}

xmps_menu_t *xmps_menu_new(xmps_menu_callback_t callback)
{
  xmps_menu_t *menu;

  menu = (xmps_menu_t *) malloc(sizeof(xmps_menu_t));

  menu->nbr_items = 0;
  menu->position  = 0;
  menu->callback  = callback;
  menu->children  = NULL;

  return menu;
}

void xmps_menu_add(xmps_menu_t *menu, xmps_menu_item_t *item)
{
  if(menu == NULL)
    return;

  menu->children = g_list_append(menu->children, item);
  menu->nbr_items++;
}

void xmps_menu_reset(xmps_menu_t *menu)
{
  if(menu == NULL)
    return;
  menu->position = 0;
}

xmps_menu_item_t *xmps_menu_get_item(xmps_menu_t *menu)
{
  if(menu == NULL || menu->nbr_items == 0)
    return NULL;
  
  return (xmps_menu_item_t *) g_list_nth_data(menu->children, menu->position);
}

int xmps_menu_next(xmps_menu_t *menu)
{
  if(menu == NULL || menu->nbr_items == 0)
    return 0;
  
  if(menu->position < menu->nbr_items - 1 )
    {
      menu->position++;
      return 1;
    }
  else
    return 0;
}
