/*  XMPS - X MPEG Player System
 *  Copyright (C) 1999 Damien Chavarria
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mpeg3private.h"
#include "mpeg3protos.h"
#include "mpeg3title.h"
#include <stdlib.h>


mpeg3_title_t* mpeg3_new_title(mpeg3_t *file, xmps_media_plugin_t *media)
{
  mpeg3_title_t *title = calloc(1, sizeof(mpeg3_title_t));
  
  title->fs = mpeg3_new_fs(media);
  title->file = file;
  
  return title;
}

int mpeg3_delete_title(mpeg3_title_t *title)
{
  mpeg3_delete_fs(title->fs);
  
  if(title->timecode_table_size) {
    free(title->timecode_table);
  }

  free(title);
  return 0;
}


int mpeg3_copy_title(mpeg3_title_t *dst, mpeg3_title_t *src)
{
  int i;

  mpeg3_copy_fs(dst->fs, src->fs);
  dst->total_bytes = src->total_bytes;
	
  if(src->timecode_table_size) {

    dst->timecode_table_allocation = src->timecode_table_allocation;
    dst->timecode_table_size = src->timecode_table_size;
    dst->timecode_table = calloc(1, sizeof(mpeg3demux_timecode_t) * dst->timecode_table_allocation);
    
    for(i = 0; i < dst->timecode_table_size; i++) {
      dst->timecode_table[i] = src->timecode_table[i];
    }
  }
  
  return 0;
}

int mpeg3_dump_title(mpeg3_title_t *title)
{
  int i;
	
  for(i = 0; i < title->timecode_table_size; i++) {
  }
  
  return 0;
}
