/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.convert;

import gnu.gcj.convert.BytesToUnicode;
import gnu.gcj.convert.UnicodeToBytes;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class Convert {
    static void error(String message) {
        System.err.print("convert: ");
        System.err.println(message);
        System.err.println("Usage:  convert [--from srcEncoding] [--to dstEncoding]");
        System.err.println("  [inputfile [outputfile]]");
        System.exit(-1);
    }

    static void missing(String arg) {
        Convert.error("missing arg after `" + arg + "' option");
    }

    public static void main(String[] args) {
        String inName = "-";
        String outName = "-";
        String inEncodingName = null;
        String outEncodingName = "JavaSrc";
        int seenNames = 0;
        boolean reverse = false;
        block10: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.length() == 0) {
                Convert.error("zero-length argument");
            }
            if (arg.charAt(0) == '-') {
                if (arg.equals("-encoding") || arg.equals("--encoding") || args.equals("-from") || arg.equals("--from")) {
                    if (++i == args.length) {
                        Convert.missing(arg);
                    }
                    inEncodingName = args[i];
                    continue;
                }
                if (arg.equals("-to") || arg.equals("--to")) {
                    if (++i == args.length) {
                        Convert.missing(arg);
                    }
                    outEncodingName = args[i];
                    continue;
                }
                if (arg.equals("-i")) {
                    if (++i == args.length) {
                        Convert.missing(arg);
                    }
                    inName = args[i];
                    continue;
                }
                if (arg.equals("-o")) {
                    if (++i == args.length) {
                        Convert.missing(arg);
                    }
                    outName = args[i];
                    continue;
                }
                if (arg.equals("-reverse") || arg.equals("--reverse")) {
                    reverse = true;
                    continue;
                }
                if (arg.equals("-")) {
                    switch (seenNames) {
                        case 0: {
                            inName = "-";
                            ++seenNames;
                            break;
                        }
                        case 1: {
                            outName = "-";
                            ++seenNames;
                            break;
                        }
                        default: {
                            Convert.error("too many `-' arguments");
                            break;
                        }
                    }
                    continue;
                }
                Convert.error("unrecognized argument `" + arg + "'");
                continue;
            }
            switch (seenNames) {
                case 0: {
                    inName = arg;
                    ++seenNames;
                    continue block10;
                }
                case 1: {
                    outName = arg;
                    ++seenNames;
                    continue block10;
                }
                default: {
                    Convert.error("too many filename arguments");
                }
            }
        }
        if (reverse) {
            String tmp = inEncodingName;
            inEncodingName = outEncodingName;
            outEncodingName = tmp;
        }
        try {
            int count;
            BytesToUnicode inDecoder = inEncodingName == null ? BytesToUnicode.getDefaultDecoder() : BytesToUnicode.getDecoder(inEncodingName);
            UnicodeToBytes outEncoder = outEncodingName == null ? UnicodeToBytes.getDefaultEncoder() : UnicodeToBytes.getEncoder(outEncodingName);
            InputStream inStream = inName == "-" ? System.in : new FileInputStream(inName);
            OutputStream outStream = outName == "-" ? System.out : new FileOutputStream(outName);
            InputStreamReader in = new InputStreamReader(inStream, inEncodingName);
            OutputStreamWriter out = new OutputStreamWriter(outStream, outEncodingName);
            char[] buffer = new char[2048];
            while ((count = in.read(buffer)) >= 0) {
                out.write(buffer, 0, count);
            }
            in.close();
            out.close();
        }
        catch (IOException ex) {
            System.err.print("convert exception: ");
            System.err.println(ex);
            System.exit(-1);
        }
    }
}

