/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;

public class Checkbox
extends Component
implements ItemSelectable {
    private ItemListener listeners;
    String label;
    CheckboxGroup group;
    boolean state;

    public Checkbox() {
        this(null, null, false);
    }

    public Checkbox(String label) {
        this(label, null, false);
    }

    public Checkbox(String label, boolean state) {
        this(label, null, state);
    }

    public Checkbox(String label, boolean state, CheckboxGroup group) {
        this(label, group, state);
    }

    public Checkbox(String label, CheckboxGroup group, boolean state) {
        this.label = label;
        this.group = group;
        this.state = state;
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, listener);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCheckbox(this);
        }
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    public String getLabel() {
        return this.label;
    }

    public Object[] getSelectedObjects() {
        Object[] r = this.state ? new Object[]{this.label} : new Object[]{};
        return r;
    }

    public boolean getState() {
        return this.state;
    }

    protected String paramString() {
        return "Checkbox[state=" + this.state + "," + "label=" + this.label + "," + "group=" + this.group + "]";
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.listeners != null) {
            this.listeners.itemStateChanged(event);
        }
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, listener);
    }

    public void setCheckboxGroup(CheckboxGroup group) {
        this.group = group;
        if (this.peer != null) {
            CheckboxPeer cp = (CheckboxPeer)this.peer;
            cp.setCheckboxGroup(group);
        }
    }

    public synchronized void setLabel(String label) {
        this.label = label;
        if (this.peer != null) {
            CheckboxPeer cp = (CheckboxPeer)this.peer;
            cp.setLabel(label == null ? "" : label);
        }
    }

    public void setState(boolean state) {
        this.state = state;
        if (this.peer != null) {
            CheckboxPeer cp = (CheckboxPeer)this.peer;
            cp.setState(state);
        }
    }
}

