/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.peer.LabelPeer;

public class Label
extends Component {
    public static final int CENTER = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    private String text;
    private int alignment;

    public Label() {
        this("", 0);
    }

    public Label(String text) {
        this(text, 0);
    }

    public Label(String text, int alignment) {
        if (alignment != 1 && alignment != 0 && alignment != 2) {
            throw new IllegalArgumentException();
        }
        this.text = text;
        this.alignment = alignment;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createLabel(this);
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public String getText() {
        return this.text;
    }

    protected String paramString() {
        return "Label[" + this.alignment + "," + this.text + "]";
    }

    public void setAlignment(int alignment) {
        if (alignment != 1 && alignment != 0 && alignment != 2) {
            throw new IllegalArgumentException();
        }
        this.alignment = alignment;
        if (this.peer != null) {
            LabelPeer lp = (LabelPeer)this.peer;
            lp.setAlignment(alignment);
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.peer != null) {
            LabelPeer lp = (LabelPeer)this.peer;
            lp.setText(text);
        }
    }
}

