/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.WindowPeer;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;

public class Window
extends Container {
    private String warningString;
    private int state;
    private int windowSerializedDataVersion;
    private transient WindowListener windowListener;
    private transient GraphicsConfiguration graphicsConfiguration;

    static /* synthetic */ Class class$(String type$) {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private /* synthetic */ void finit$() {
        this.warningString = null;
        this.state = 0;
        this.windowSerializedDataVersion = 0;
    }

    Window() {
        this.finit$();
        this.setVisible(false);
        this.setLayout(new BorderLayout());
    }

    Window(GraphicsConfiguration gc) {
        this();
        this.graphicsConfiguration = gc;
    }

    public Window(Frame owner) {
        this((Window)owner);
    }

    public Window(Window owner) {
        this();
        if (owner == null) {
            throw new IllegalArgumentException("owner must not be null");
        }
        this.parent = owner;
    }

    public Window(Window owner, GraphicsConfiguration gc) {
        this(owner);
        this.graphicsConfiguration = gc;
    }

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        return super.getGraphicsConfigurationImpl();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        super.addNotify();
    }

    public void pack() {
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void show() {
        if (this.peer == null) {
            this.addNotify();
        }
        this.validate();
        if (this.isVisible()) {
            this.toFront();
            return;
        }
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.validate();
        super.show();
    }

    public void hide() {
        super.hide();
    }

    public void dispose() {
        int i;
        this.hide();
        Window[] list = this.getOwnedWindows();
        for (i = 0; i < list.length; ++i) {
            list[i].dispose();
        }
        for (i = 0; i < this.ncomponents; ++i) {
            this.component[i].removeNotify();
        }
        this.removeNotify();
    }

    public void toBack() {
        if (this.peer != null) {
            WindowPeer wp = (WindowPeer)this.peer;
            wp.toBack();
        }
    }

    public void toFront() {
        if (this.peer != null) {
            WindowPeer wp = (WindowPeer)this.peer;
            wp.toFront();
        }
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        boolean secure = true;
        if (!secure) {
            if (this.warningString != null) {
                return this.warningString;
            }
            String warning = System.getProperty("awt.appletWarning");
            return warning;
        }
        return null;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    public Window[] getOwnedWindows() {
        return null;
    }

    public synchronized void addWindowListener(WindowListener listener) {
        this.windowListener = AWTEventMulticaster.add(this.windowListener, listener);
    }

    public synchronized void removeWindowListener(WindowListener listener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, listener);
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == Window.class$("java.awt.event.WindowListener")) {
            return Component.getListenersImpl(listenerType, this.windowListener);
        }
        return super.getListeners(listenerType);
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 206 && e.id >= 200 && (this.windowListener != null || (this.eventMask & (long)64) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected void processEvent(AWTEvent evt) {
        if (evt instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)evt);
        } else {
            super.processEvent(evt);
        }
    }

    protected void processWindowEvent(WindowEvent evt) {
        if (this.windowListener != null) {
            switch (evt.getID()) {
                case 205: {
                    this.windowListener.windowActivated(evt);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(evt);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(evt);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(evt);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(evt);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(evt);
                    break;
                }
                case 200: {
                    this.windowListener.windowOpened(evt);
                }
            }
        }
    }

    public Component getFocusOwner() {
        return null;
    }

    public boolean postEvent(Event e) {
        return false;
    }

    public boolean isShowing() {
        return this.isVisible();
    }

    public void applyResourceBundle(ResourceBundle rb) {
    }

    public void applyResourceBundle(String rbName) {
        ResourceBundle rb = ResourceBundle.getBundle(rbName);
        if (rb != null) {
            this.applyResourceBundle(rb);
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        if (this.peer != null) {
            return this.peer.getGraphicsConfiguration();
        }
        return null;
    }
}

