/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;

public class MouseEvent
extends InputEvent {
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 506;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    private long when;
    private int modifiers;
    private int x;
    private int y;
    private int clickCount;
    private boolean popupTrigger;

    public MouseEvent(Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger) {
        super(source, id);
        this.when = when;
        this.modifiers = modifiers;
        this.x = x;
        this.y = y;
        this.clickCount = clickCount;
        this.popupTrigger = popupTrigger;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public String paramString() {
        String r;
        switch (this.id) {
            case 500: {
                r = "MOUSE_CLICKED";
                break;
            }
            case 506: {
                r = "MOUSE_DRAGGED";
                break;
            }
            case 504: {
                r = "MOUSE_ENTERED";
                break;
            }
            case 505: {
                r = "MOUSE_EXITED";
                break;
            }
            case 503: {
                r = "MOUSE_MOVED";
                break;
            }
            case 501: {
                r = "MOUSE_PRESSED";
                break;
            }
            case 502: {
                r = "MOUSE_RELEASED";
                break;
            }
            default: {
                r = "unknown id";
            }
        }
        r = r + new StringBuffer(",(").append(this.x).append(",").append(this.y).append("),modifiers=").append(this.modifiers).append(",clickCount=").append(this.clickCount);
        return r;
    }

    public void translatePoint(int x, int y) {
        this.x += x;
        this.y += y;
    }
}

