/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class AffineTransform
implements Cloneable,
Serializable {
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;
    private int type;

    public AffineTransform() {
        this.setToIdentity();
    }

    public AffineTransform(AffineTransform tx) {
        this.setTransform(tx);
    }

    public AffineTransform(float m00, float m10, float m01, float m11, float m02, float m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.type = 0;
    }

    public AffineTransform(float[] flatmatrix) {
        this.m00 = flatmatrix[0];
        this.m10 = flatmatrix[1];
        this.m01 = flatmatrix[2];
        this.m11 = flatmatrix[3];
        if (flatmatrix.length >= 6) {
            this.m02 = flatmatrix[4];
            this.m12 = flatmatrix[5];
        }
    }

    public AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.type = 32;
    }

    public AffineTransform(double[] flatmatrix) {
        this.m00 = flatmatrix[0];
        this.m10 = flatmatrix[1];
        this.m01 = flatmatrix[2];
        this.m11 = flatmatrix[3];
        if (flatmatrix.length >= 6) {
            this.m02 = flatmatrix[4];
            this.m12 = flatmatrix[5];
        }
    }

    public static AffineTransform getTranslateInstance(double tx, double ty) {
        AffineTransform t = new AffineTransform();
        t.setToTranslation(tx, ty);
        return t;
    }

    public static AffineTransform getRotateInstance(double theta) {
        AffineTransform t = new AffineTransform();
        t.setToRotation(theta);
        return t;
    }

    public static AffineTransform getRotateInstance(double theta, double x, double y) {
        AffineTransform t = new AffineTransform();
        t.rotate(theta, x, y);
        return t;
    }

    public static AffineTransform getScaleInstance(double sx, double sy) {
        AffineTransform t = new AffineTransform();
        t.setToScale(sx, sy);
        return t;
    }

    public static AffineTransform getShearInstance(double shx, double shy) {
        AffineTransform t = new AffineTransform();
        t.setToShear(shx, shy);
        return t;
    }

    public int getType() {
        return this.type;
    }

    public double getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public void getMatrix(double[] flatmatrix) {
        flatmatrix[0] = this.m00;
        flatmatrix[1] = this.m10;
        flatmatrix[2] = this.m01;
        flatmatrix[3] = this.m11;
        if (flatmatrix.length >= 6) {
            flatmatrix[4] = this.m02;
            flatmatrix[5] = this.m12;
        }
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getShearX() {
        return this.m01;
    }

    public double getShearY() {
        return this.m10;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    public void translate(double tx, double ty) {
        this.m02 += tx * this.m00 + ty * this.m01;
        this.m12 += tx * this.m10 + ty * this.m11;
    }

    public void rotate(double theta) {
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        double n00 = this.m00 * c + this.m01 * s;
        double n01 = this.m00 * -s + this.m01 * c;
        double n10 = this.m10 * c + this.m11 * s;
        double n11 = this.m10 * -s + this.m11 * c;
        this.m00 = n00;
        this.m01 = n01;
        this.m10 = n10;
        this.m11 = n11;
    }

    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    public void scale(double sx, double sy) {
        this.m00 *= sx;
        this.m01 *= sy;
        this.m10 *= sx;
        this.m11 *= sy;
    }

    public void shear(double shx, double shy) {
        double n00 = this.m00 + shx * this.m01;
        double n01 = shx * this.m00 + this.m01;
        double n10 = this.m10 * shy + this.m11;
        double n11 = shx * this.m10 + this.m11;
        this.m00 = n00;
        this.m01 = n01;
        this.m10 = n10;
        this.m11 = n11;
    }

    public void setToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.type = 0;
    }

    public void setToTranslation(double tx, double ty) {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m02 = tx;
        this.m12 = ty;
        this.type = 1;
    }

    public void setToRotation(double theta) {
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        this.m00 = c;
        this.m01 = -s;
        this.m02 = 0.0;
        this.m10 = s;
        this.m11 = c;
        this.m12 = 0.0;
        this.type = 16;
    }

    public void setToScale(double sx, double sy) {
        this.m00 = sx;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m11 = sy;
        this.type = sx == sy ? 2 : 4;
    }

    public void setToShear(double shx, double shy) {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m01 = shx;
        this.m10 = shy;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.type = 0;
    }

    public void setTransform(AffineTransform tx) {
        this.m00 = tx.m00;
        this.m01 = tx.m01;
        this.m02 = tx.m02;
        this.m10 = tx.m10;
        this.m11 = tx.m11;
        this.m12 = tx.m12;
        this.type = tx.type;
    }

    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.type = 0;
    }

    public void concatenate(AffineTransform tx) {
        double n00 = this.m00 * tx.m00 + this.m01 * tx.m10;
        double n01 = this.m00 * tx.m01 + this.m01 * tx.m11;
        double n02 = this.m00 * tx.m02 + this.m01 * tx.m12 + this.m02;
        double n10 = this.m10 * tx.m00 + this.m11 * tx.m10;
        double n11 = this.m10 * tx.m01 + this.m11 * tx.m11;
        double n12 = this.m10 * tx.m02 + this.m11 * tx.m12 + this.m12;
        this.m00 = n00;
        this.m01 = n01;
        this.m02 = n02;
        this.m10 = n10;
        this.m11 = n11;
        this.m12 = n12;
    }

    public void preConcatenate(AffineTransform tx) {
        double n00 = tx.m00 * this.m00 + tx.m01 * this.m10;
        double n01 = tx.m00 * this.m01 + tx.m01 * this.m11;
        double n02 = tx.m00 * this.m02 + tx.m01 * this.m12 + tx.m02;
        double n10 = tx.m10 * this.m00 + tx.m11 * this.m10;
        double n11 = tx.m10 * this.m01 + tx.m11 * this.m11;
        double n12 = tx.m10 * this.m02 + tx.m11 * this.m12 + tx.m12;
        this.m00 = n00;
        this.m01 = n01;
        this.m02 = n02;
        this.m10 = n10;
        this.m11 = n11;
        this.m12 = n12;
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        double det = this.getDeterminant();
        if (det == 0.0) {
            throw new NoninvertibleTransformException("can't invert transform");
        }
        double i00 = this.m11 / det;
        double i01 = -this.m10 / det;
        double i02 = 0.0;
        double i10 = this.m01 / det;
        double i11 = -this.m00 / det;
        double i12 = 0.0;
        return new AffineTransform(i00, i01, i02, i10, i11, i12);
    }

    public Point2D transform(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = new Point2D.Double();
        }
        double x = src.getX();
        double y = src.getY();
        double nx = this.m00 * x + this.m01 * y + this.m02;
        double ny = this.m10 * x + this.m11 * y + this.m12;
        dst.setLocation(nx, ny);
        return dst;
    }

    public void transform(Point2D[] src, int srcOff, Point2D[] dst, int dstOff, int num) {
        while (num-- > 0) {
            dst[dstOff] = this.transform(src[srcOff], dst[dstOff]);
            ++srcOff;
            ++dstOff;
        }
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int num) {
        while (num-- > 0) {
            float x = srcPts[srcOff];
            float y = srcPts[srcOff + 1];
            srcOff += 2;
            float nx = (float)(this.m00 * (double)x + this.m01 * (double)y + this.m02);
            float ny = (float)(this.m10 * (double)x + this.m10 * (double)y + this.m12);
            dstPts[dstOff] = nx;
            dstPts[dstOff + 1] = ny;
            dstOff += 2;
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int num) {
        while (num-- > 0) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            srcOff += 2;
            double nx = this.m00 * x + this.m01 * y + this.m02;
            double ny = this.m10 * x + this.m10 * y + this.m12;
            dstPts[dstOff] = nx;
            dstPts[dstOff + 1] = ny;
            dstOff += 2;
        }
    }

    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int num) {
        while (num-- > 0) {
            float x = srcPts[srcOff];
            float y = srcPts[srcOff + 1];
            srcOff += 2;
            double nx = this.m00 * (double)x + this.m01 * (double)y + this.m02;
            double ny = this.m10 * (double)x + this.m10 * (double)y + this.m12;
            dstPts[dstOff] = nx;
            dstPts[dstOff + 1] = ny;
            dstOff += 2;
        }
    }

    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int num) {
        while (num-- > 0) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            srcOff += 2;
            float nx = (float)(this.m00 * x + this.m01 * y + this.m02);
            float ny = (float)(this.m10 * x + this.m10 * y + this.m12);
            dstPts[dstOff] = nx;
            dstPts[dstOff + 1] = ny;
            dstOff += 2;
        }
    }

    public Point2D inverseTransform(Point2D src, Point2D dst) throws NoninvertibleTransformException {
        double det = this.getDeterminant();
        if (det == 0.0) {
            throw new NoninvertibleTransformException("couldn't invert transform");
        }
        if (dst == null) {
            dst = new Point2D.Double();
        }
        double x = src.getX();
        double y = src.getY();
        double nx = (this.m11 * x + -this.m10 * y) / det;
        double ny = (this.m01 * x + -this.m00 * y) / det;
        dst.setLocation(nx, ny);
        return dst;
    }

    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int num) throws NoninvertibleTransformException {
        double det = this.getDeterminant();
        if (det == 0.0) {
            throw new NoninvertibleTransformException("couldn't invert transform");
        }
        while (num-- > 0) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double nx = (this.m11 * x + -this.m10 * y) / det;
            double ny = (this.m01 * x + -this.m00 * y) / det;
            dstPts[dstOff] = nx;
            dstPts[dstOff + 1] = ny;
            dstOff += 2;
            srcOff += 2;
        }
    }

    public Point2D deltaTransform(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = new Point2D.Double();
        }
        double x = src.getX();
        double y = src.getY();
        double nx = this.m00 * x + this.m01 * y;
        double ny = this.m10 * x + this.m11 * y;
        dst.setLocation(nx, ny);
        return dst;
    }

    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int num) {
        while (num-- > 0) {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double nx = this.m00 * x + this.m01 * y;
            double ny = this.m10 * x + this.m11 * y;
            dstPts[dstOff] = nx;
            dstPts[dstOff + 1] = ny;
            dstOff += 2;
            srcOff += 2;
        }
    }

    public Shape createTransformedShape(Shape pSrc) {
        return null;
    }

    public String toString() {
        return null;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0;
    }

    public Object clone() {
        return new AffineTransform(this);
    }

    public int hashCode() {
        return 23;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AffineTransform)) {
            return false;
        }
        AffineTransform t = (AffineTransform)obj;
        return this.m00 == t.m00 && this.m01 == t.m01 && this.m02 == t.m02 && this.m10 == t.m10 && this.m11 == t.m11 && this.m12 == t.m12;
    }

    class Iterator
    implements PathIterator {
        private /* synthetic */ AffineTransform this$0;
        private PathIterator subIterator;

        public Iterator(AffineTransform this$0, PathIterator subIterator) {
            this.this$0 = this$0;
            this.subIterator = subIterator;
        }

        public int currentSegment(double[] coords) {
            int r = this.subIterator.currentSegment(coords);
            int count = 0;
            switch (r) {
                case 3: {
                    count = 3;
                    break;
                }
                case 2: {
                    count = 2;
                    break;
                }
                case 0: 
                case 1: {
                    count = 1;
                    break;
                }
            }
            this.this$0.transform(coords, 0, coords, 0, count);
            return r;
        }

        public int currentSegment(float[] coords) {
            int r = this.subIterator.currentSegment(coords);
            int count = 0;
            switch (r) {
                case 3: {
                    count = 3;
                    break;
                }
                case 2: {
                    count = 2;
                    break;
                }
                case 0: 
                case 1: {
                    count = 1;
                    break;
                }
            }
            this.this$0.transform(coords, 0, coords, 0, count);
            return r;
        }

        public int getWindingRule() {
            return this.subIterator.getWindingRule();
        }

        public boolean isDone() {
            return this.subIterator.isDone();
        }

        public void next() {
            this.subIterator.next();
        }
    }
}

