/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public abstract class Rectangle2D
extends RectangularShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected Rectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(Rectangle2D r) {
        this.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        int o1 = this.outcode(x1, y1);
        int o2 = this.outcode(x2, y2);
        double mx = this.getX();
        double my = this.getY();
        double mx2 = this.getWidth();
        double my2 = this.getHeight();
        x1 -= mx;
        x2 -= mx;
        y1 -= my;
        y2 -= my;
        int xor = o1 ^ o2;
        int or = o1 | o2;
        if ((xor & 0xA) == 0) {
            if ((or & 0xA) != 0) {
                return false;
            }
            return (o1 & 5) != 0 || (o2 & 5) != 0;
        }
        if ((xor & 5) == 0) {
            if ((or & 5) != 0) {
                return false;
            }
            return (o1 & 0xA) != 0 || (o2 & 0xA) != 0;
        }
        double dx = x2 - x1;
        double dy = y2 - y1;
        double t1l = -x1 / dx;
        double t1h = (mx2 - x1) / dx;
        if (t1l >= t1h) {
            return false;
        }
        double t2l = -y1 / dy;
        double t2h = (my2 - y1) / dy;
        return !(t2l >= t2h) && !(t2l >= t1h) && !(t2h < t1l);
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(Point2D p) {
        return this.outcode(p.getX(), p.getY());
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setRect(x, y, w, h);
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.clone();
    }

    public boolean contains(double x, double y) {
        double mx = this.getX();
        double mw = this.getWidth();
        if (x < mx || x >= mx + mw) {
            return false;
        }
        double my = this.getY();
        double mh = this.getHeight();
        return y >= my && y < my + mh;
    }

    public boolean intersects(double x, double y, double w, double h) {
        double mx = this.getX();
        double mw = this.getWidth();
        if (x < mx || x >= mx + mw || x + w < mx || x + w >= mx + mw) {
            return false;
        }
        double my = this.getY();
        double mh = this.getHeight();
        return y >= my && y < my + mh && y + h >= my && y + h < my + mh;
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x + w, y + h);
    }

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public static void intersect(Rectangle2D src1, Rectangle2D src2, Rectangle2D dest) {
        double y2h;
        double x2h;
        double x1l = src1.getMinX();
        double x2l = src2.getMinX();
        double nxl = Math.max(x1l, x2l);
        double x1h = src1.getMaxX();
        double nxh = Math.min(x1h, x2h = src2.getMaxX());
        if (nxh < nxl) {
            nxh = nxl;
        }
        double y1l = src1.getMinY();
        double y2l = src2.getMinY();
        double nyl = Math.max(y1l, y2l);
        double y1h = src1.getMaxY();
        double nyh = Math.min(y1h, y2h = src2.getMaxY());
        if (nyh < nyl) {
            nyh = nyl;
        }
        dest.setFrameFromDiagonal(nxl, nyl, nxh, nyh);
    }

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public static void union(Rectangle2D src1, Rectangle2D src2, Rectangle2D dest) {
        double x1l = src1.getMinX();
        double x2l = src2.getMinX();
        double nxl = Math.max(x1l, x2l);
        double x1h = src1.getMaxX();
        double x2h = src2.getMaxX();
        double nxh = Math.min(x1h, x2h);
        double y1l = src1.getMinY();
        double y2l = src2.getMinY();
        double nyl = Math.max(y1l, y2l);
        double y1h = src1.getMaxY();
        double y2h = src2.getMaxY();
        double nyh = Math.min(y1h, y2h);
        dest.setFrameFromDiagonal(nxl, nyl, nxh, nyh);
    }

    public void add(double newx, double newy) {
        double minx = Math.min(this.getMinX(), newx);
        double maxx = Math.max(this.getMaxX(), newx);
        double miny = Math.min(this.getMinY(), newy);
        double maxy = Math.max(this.getMaxY(), newy);
        this.setFrameFromDiagonal(minx, miny, maxx, maxy);
    }

    public void add(Point2D p) {
        this.add(p.getX(), p.getY());
    }

    public void add(Rectangle2D r) {
        this.add(r.getMinX(), r.getMinY());
        this.add(r.getMaxX(), r.getMaxY());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.getPathIterator(at, 0.0);
    }

    public static class Float
    extends Rectangle2D {
        public float height;
        public float width;
        public float x;
        public float y;

        public Float() {
            this.y = 0.0f;
            this.x = 0.0f;
            this.width = 0.0f;
            this.height = 0.0f;
        }

        public Float(float x, float y, float w, float h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(double x, double y, double w, double h) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)w;
            this.height = (float)h;
        }

        public void setRect(Rectangle2D r) {
            this.x = (float)r.getX();
            this.y = (float)r.getY();
            this.width = (float)r.getWidth();
            this.height = (float)r.getHeight();
        }

        public int outcode(double x, double y) {
            int code = 0;
            if (x < (double)this.x) {
                code |= 1;
            } else if (x >= (double)(this.x + this.width)) {
                code |= 4;
            }
            if (y < (double)this.y) {
                code |= 2;
            } else if (y >= (double)(this.y + this.height)) {
                code |= 8;
            }
            return code;
        }

        public Rectangle2D getBounds2D() {
            return new Float(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D r) {
            Float res = new Float();
            Rectangle2D.intersect(this, r, res);
            return res;
        }

        public Rectangle2D createUnion(Rectangle2D r) {
            Float res = new Float();
            Rectangle2D.union(this, r, res);
            return res;
        }

        public String toString() {
            return "fixme";
        }
    }

    public static class Double
    extends Rectangle2D {
        public double height;
        public double width;
        public double x;
        public double y;

        public Double() {
            this.y = 0.0;
            this.x = 0.0;
            this.width = 0.0;
            this.height = 0.0;
        }

        public Double(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRect(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
        }

        public void setRect(Rectangle2D r) {
            this.x = r.getX();
            this.y = r.getY();
            this.width = r.getWidth();
            this.height = r.getHeight();
        }

        public int outcode(double x, double y) {
            int code = 0;
            if (x < this.x) {
                code |= 1;
            } else if (x >= this.x + this.width) {
                code |= 4;
            }
            if (y < this.y) {
                code |= 2;
            } else if (y >= this.y + this.height) {
                code |= 8;
            }
            return code;
        }

        public Rectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D r) {
            Double res = new Double();
            Rectangle2D.intersect(this, r, res);
            return res;
        }

        public Rectangle2D createUnion(Rectangle2D r) {
            Double res = new Double();
            Rectangle2D.union(this, r, res);
            return res;
        }

        public String toString() {
            return "fixme";
        }
    }
}

