/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    private Writer out;
    char[] buffer;
    int count;
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public BufferedWriter(Writer out) {
        this(out, 8192);
    }

    public BufferedWriter(Writer ox, int size) {
        super(ox);
        this.out = ox;
        this.buffer = new char[size];
        this.count = 0;
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.localFlush();
                this.out.close();
                this.buffer = null;
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buffer == null) {
                    throw new IOException("Stream closed");
                }
                this.localFlush();
                this.out.flush();
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    public void newLine() throws IOException {
        this.write(System.getProperty("line.separator"));
    }

    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                try {
                    if (this.buffer == null) {
                        throw new IOException("Stream closed");
                    }
                    this.buffer[this.count++] = (char)oneChar;
                    if (this.count != this.buffer.length) break block4;
                    this.localFlush();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
            Object var4_3 = null;
        }
    }

    public void write(char[] buf, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            block6: {
                try {
                    if (this.buffer == null) {
                        throw new IOException("Stream closed");
                    }
                    if (this.count + len > this.buffer.length) {
                        this.localFlush();
                        this.out.write(buf, offset, len);
                        break block6;
                    }
                    System.arraycopy(buf, offset, this.buffer, this.count, len);
                    this.count += len;
                    if (this.count != this.buffer.length) break block6;
                    this.localFlush();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
            Object var6_5 = null;
        }
    }

    public void write(String str, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len < str.length()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            block6: {
                try {
                    if (this.buffer == null) {
                        throw new IOException("Stream closed");
                    }
                    if (this.count + len > this.buffer.length) {
                        this.localFlush();
                        this.out.write(str, offset, len);
                        break block6;
                    }
                    str.getChars(offset, offset + len, this.buffer, this.count);
                    this.count += len;
                    if (this.count != this.buffer.length) break block6;
                    this.localFlush();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
            Object var6_5 = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void localFlush() throws IOException {
        if (this.count <= 0) return;
        Object object = this.lock;
        synchronized (object) {
            try {
                this.out.write(this.buffer, 0, this.count);
                this.count = 0;
                return;
            }
            finally {
                Object var3_2 = null;
            }
        }
    }
}

