/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;

    public FileInputStream(String name) throws FileNotFoundException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(name);
        }
        this.fd = new FileDescriptor(name, 1);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public FileInputStream(FileDescriptor fdObj) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(fdObj);
        }
        this.fd = fdObj;
    }

    public int available() throws IOException {
        return this.fd.available();
    }

    public void close() throws IOException {
        if (this.fd.valid()) {
            this.fd.close();
        }
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.fd.finalize();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (!this.fd.valid()) {
            throw new IOException();
        }
        return this.fd;
    }

    public int read() throws IOException {
        return this.fd.read();
    }

    public int read(byte[] b) throws IOException {
        return this.fd.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.fd.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.fd.seek(n, 1);
    }
}

