/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

public class BigDecimal
extends Number
implements Comparable {
    private BigInteger intVal;
    private int scale;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final BigDecimal ZERO = new BigDecimal(BigInteger.valueOf(0L), 0);
    private static final BigDecimal ONE = new BigDecimal(BigInteger.valueOf(1L), 0);
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;

    public BigDecimal(BigInteger num) {
        this(num, 0);
    }

    public BigDecimal(BigInteger num, int scale) {
        if (scale < 0) {
            throw new NumberFormatException("scale of " + scale + " is < 0");
        }
        this.intVal = num;
        this.scale = scale;
    }

    public BigDecimal(double num) {
        this(Double.toString(num));
    }

    public BigDecimal(String num) {
        int point = num.indexOf(46);
        this.intVal = new BigInteger(point == -1 ? num : num.substring(0, point) + num.substring(point + 1));
        this.scale = num.length() - (point == -1 ? num.length() : point + 1);
    }

    public static BigDecimal valueOf(long val) {
        return BigDecimal.valueOf(val, 0);
    }

    public static BigDecimal valueOf(long val, int scale) {
        if (scale == 0) {
            switch ((int)val) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return ONE;
                }
            }
        }
        return new BigDecimal(BigInteger.valueOf(val), scale);
    }

    public BigDecimal add(BigDecimal val) {
        BigInteger op1 = this.intVal;
        BigInteger op2 = val.intVal;
        if (this.scale < val.scale) {
            op1 = op1.multiply(BigInteger.valueOf(10).pow(val.scale - this.scale));
        } else if (this.scale > val.scale) {
            op2 = op2.multiply(BigInteger.valueOf(10).pow(this.scale - val.scale));
        }
        return new BigDecimal(op1.add(op2), Math.max(this.scale, val.scale));
    }

    public BigDecimal subtract(BigDecimal val) {
        return this.add(val.negate());
    }

    public BigDecimal multiply(BigDecimal val) {
        return new BigDecimal(this.intVal.multiply(val.intVal), this.scale + val.scale);
    }

    public BigDecimal divide(BigDecimal val, int roundingMode) {
        return this.divide(val, this.scale, roundingMode);
    }

    public BigDecimal divide(BigDecimal val, int newScale, int roundingMode) {
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("illegal rounding mode: " + roundingMode);
        }
        if (newScale < 0) {
            throw new ArithmeticException("scale is negative: " + newScale);
        }
        if (this.intVal.signum() == 0) {
            return ZERO;
        }
        int valScale = val.scale;
        BigInteger valIntVal = val.intVal;
        int power = newScale + 1 - (this.scale - val.scale);
        if (power < 0) {
            valIntVal = valIntVal.multiply(BigInteger.valueOf(10).pow(-power));
            power = 0;
        }
        BigInteger dividend = this.intVal.multiply(BigInteger.valueOf(10).pow(power));
        BigInteger[] parts = dividend.divideAndRemainder(valIntVal);
        int roundDigit = parts[0].mod(BigInteger.valueOf(10)).intValue();
        BigInteger unrounded = parts[0].divide(BigInteger.valueOf(10));
        if (roundDigit == 0 && parts[1].signum() == 0) {
            return new BigDecimal(unrounded, newScale);
        }
        int sign = unrounded.signum();
        switch (roundingMode) {
            case 7: {
                throw new ArithmeticException("newScale is not large enough");
            }
            case 2: {
                roundingMode = sign == 1 ? 0 : 1;
                break;
            }
            case 3: {
                roundingMode = sign == 1 ? 1 : 0;
                break;
            }
            case 4: {
                roundingMode = roundDigit >= 5 ? 0 : 1;
                break;
            }
            case 5: {
                roundingMode = roundDigit > 5 ? 0 : 1;
                break;
            }
            case 6: {
                if (roundDigit < 5) {
                    roundingMode = 1;
                    break;
                }
                int rightmost = unrounded.mod(BigInteger.valueOf(10)).intValue();
                if (rightmost % 2 == 1) {
                    roundingMode = 0;
                    break;
                }
                int n = roundingMode = roundDigit > 5 ? 0 : 1;
            }
        }
        if (roundingMode == 0) {
            return new BigDecimal(unrounded.add(BigInteger.valueOf(1L)), newScale);
        }
        return new BigDecimal(unrounded, newScale);
    }

    public int compareTo(BigDecimal val) {
        BigInteger[] valParts;
        if (this.scale == val.scale) {
            return this.intVal.compareTo(val.intVal);
        }
        BigInteger[] thisParts = this.intVal.divideAndRemainder(BigInteger.valueOf(10).pow(this.scale));
        int compare = thisParts[0].compareTo((valParts = val.intVal.divideAndRemainder(BigInteger.valueOf(10).pow(val.scale)))[0]);
        if (compare != 0) {
            return compare;
        }
        if (!thisParts[1].equals(BigInteger.valueOf(0L))) {
            while (thisParts[1].mod(BigInteger.valueOf(10)).equals(BigInteger.valueOf(0L))) {
                thisParts[1] = thisParts[1].divide(BigInteger.valueOf(10));
            }
        }
        if (!valParts[1].equals(BigInteger.valueOf(0L))) {
            while (valParts[1].mod(BigInteger.valueOf(10)).equals(BigInteger.valueOf(0L))) {
                valParts[1] = valParts[1].divide(BigInteger.valueOf(10));
            }
        }
        return thisParts[1].compareTo(valParts[1]);
    }

    public int compareTo(Object val) {
        return this.compareTo((BigDecimal)val);
    }

    public boolean equals(Object o) {
        return o instanceof BigDecimal && this.scale == ((BigDecimal)o).scale && this.compareTo((BigDecimal)o) == 0;
    }

    public int hashCode() {
        return this.intValue() ^ this.scale;
    }

    public BigDecimal max(BigDecimal val) {
        if (this.compareTo(val) == 1) {
            return this;
        }
        return val;
    }

    public BigDecimal min(BigDecimal val) {
        if (this.compareTo(val) == -1) {
            return this;
        }
        return val;
    }

    public BigDecimal movePointLeft(int n) {
        if (n < 0) {
            return this.movePointRight(-n);
        }
        return new BigDecimal(this.intVal, this.scale + n);
    }

    public BigDecimal movePointRight(int n) {
        if (n < 0) {
            return this.movePointLeft(-n);
        }
        if (this.scale >= n) {
            return new BigDecimal(this.intVal, this.scale - n);
        }
        return new BigDecimal(this.intVal.multiply(BigInteger.valueOf(10).pow(n - this.scale)), 0);
    }

    public int signum() {
        return this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public BigDecimal abs() {
        return new BigDecimal(this.intVal.abs(), this.scale);
    }

    public BigDecimal negate() {
        return new BigDecimal(this.intVal.negate(), this.scale);
    }

    public String toString() {
        String bigStr = this.intVal.toString();
        if (this.scale == 0) {
            return bigStr;
        }
        int point = bigStr.length() - this.scale;
        boolean negative = bigStr.charAt(0) == '-';
        StringBuffer sb = new StringBuffer(bigStr.length() + 1 + (point <= 0 ? -point + 1 : 0));
        if (negative) {
            sb.append('-');
        }
        while (point <= 0) {
            sb.append('0');
            ++point;
        }
        sb.append(bigStr.substring(negative ? 1 : 0));
        sb.insert(point, '.');
        return sb.toString();
    }

    public BigInteger toBigInteger() {
        if (this.scale == 0) {
            return this.intVal;
        }
        return this.intVal.divide(BigInteger.valueOf(10).pow(this.scale));
    }

    public int intValue() {
        return this.toBigInteger().intValue();
    }

    public long longValue() {
        return this.toBigInteger().longValue();
    }

    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    public BigDecimal setScale(int scale) {
        return this.setScale(scale, 7);
    }

    public BigDecimal setScale(int scale, int roundingMode) {
        return this.divide(ONE, scale, roundingMode);
    }
}

