/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;

public class Socket {
    static SocketImplFactory factory;
    SocketImpl impl;

    protected Socket() {
    }

    protected Socket(SocketImpl impl) throws SocketException {
        this.impl = impl;
    }

    public Socket(String host, int port) throws IOException, UnknownHostException {
        this(factory == null ? new PlainSocketImpl() : factory.createSocketImpl());
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkConnect(host, port);
        }
        this.impl.create(true);
        this.impl.connect(host, port);
    }

    public Socket(InetAddress address, int port) throws IOException {
        this(factory == null ? new PlainSocketImpl() : factory.createSocketImpl());
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkConnect(address.getHostName(), port);
        }
        this.impl.create(true);
        this.impl.connect(address, port);
    }

    public Socket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        this(factory == null ? new PlainSocketImpl() : factory.createSocketImpl());
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkConnect(host, port);
        }
        this.impl.create(true);
        this.impl.bind(localAddr, localPort);
        this.impl.connect(host, port);
    }

    public Socket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this(factory == null ? new PlainSocketImpl() : factory.createSocketImpl());
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkConnect(address.getHostName(), port);
        }
        this.impl.create(true);
        this.impl.bind(localAddr, localPort);
        this.impl.connect(address, port);
    }

    public Socket(String host, int port, boolean stream) throws IOException {
        this.impl = factory == null ? new PlainSocketImpl() : factory.createSocketImpl();
        this.impl.create(stream);
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkConnect(host, port);
        }
        this.impl.connect(host, port);
    }

    public Socket(InetAddress host, int port, boolean stream) throws IOException {
        this.impl = factory == null ? new PlainSocketImpl() : factory.createSocketImpl();
        this.impl.create(stream);
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkConnect(host.getHostName(), port);
        }
        this.impl.connect(host, port);
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException x) {
            System.err.println(x);
            throw new InternalError("Error in PlainSocketImpl.getOption");
        }
    }

    public int getPort() {
        return this.impl.getPort();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public InputStream getInputStream() throws IOException {
        return this.impl.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.impl.getOutputStream();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.impl.setOption(1, new Boolean(on));
    }

    public boolean getTcpNoDelay() throws SocketException {
        Boolean bool = (Boolean)this.impl.getOption(1);
        return bool;
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (on && linger >= 0) {
            if (linger > 65535) {
                linger = 65535;
            }
            this.impl.setOption(128, new Integer(linger));
        } else {
            if (on && linger < 0) {
                throw new IllegalArgumentException("SO_LINGER must be >= 0");
            }
            this.impl.setOption(128, new Boolean(false));
        }
    }

    public int getSoLinger() throws SocketException {
        Object linger = this.impl.getOption(128);
        if (linger instanceof Integer) {
            return (Integer)linger;
        }
        return -1;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + timeout);
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public synchronized int getSoTimeout() throws SocketException {
        Object timeout = this.impl.getOption(4102);
        if (timeout instanceof Integer) {
            return (Integer)timeout;
        }
        return 0;
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid buffer size: " + size);
        }
        this.impl.setOption(4097, new Integer(size));
    }

    public int getSendBufferSize() throws SocketException {
        Integer buf = (Integer)this.impl.getOption(4097);
        return buf;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid buffer size: " + size);
        }
        this.impl.setOption(4098, new Integer(size));
    }

    public int getReceiveBufferSize() throws SocketException {
        Integer buf = (Integer)this.impl.getOption(4098);
        return buf;
    }

    public synchronized void close() throws IOException {
        this.impl.close();
    }

    public String toString() {
        return "Socket" + this.impl.toString();
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory fac) throws IOException {
        factory = fac;
    }
}

