/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class DecimalFormat
extends NumberFormat {
    private boolean decimalSeparatorAlwaysShown;
    private byte groupingSize;
    private byte minExponentDigits;
    private int multiplier;
    private String negativePrefix;
    private String negativeSuffix;
    private String positivePrefix;
    private String positiveSuffix;
    private int serialVersionOnStream;
    private DecimalFormatSymbols symbols;
    private boolean useExponentialNotation;
    private static final long serialVersionUID = 864413376551465018L;
    private static final DecimalFormatSymbols nonLocalizedSymbols = new DecimalFormatSymbols(Locale.US);

    private /* synthetic */ void finit$() {
        this.serialVersionOnStream = 1;
    }

    private final int scanFix(String pattern, int index, StringBuffer buf, String patChars, DecimalFormatSymbols syms, boolean is_suffix) {
        int len = pattern.length();
        buf.setLength(0);
        boolean multiplierSet = false;
        while (index < len) {
            char c = pattern.charAt(index);
            if (c == '\'' && index + 1 < len && pattern.charAt(index + 1) == '\'') {
                buf.append(c);
                ++index;
            } else if (c == '\'' && index + 2 < len && pattern.charAt(index + 2) == '\'') {
                buf.append(pattern.charAt(index + 1));
                index += 2;
            } else if (c == '\u00a4') {
                if (index + 1 < len && pattern.charAt(index + 1) == '\u00a4') {
                    buf.append(syms.getInternationalCurrencySymbol());
                    ++index;
                } else {
                    buf.append(syms.getCurrencySymbol());
                }
            } else if (is_suffix && c == syms.getPercent()) {
                if (multiplierSet) {
                    throw new IllegalArgumentException("multiplier already set - index: " + index);
                }
                multiplierSet = true;
                this.multiplier = 100;
                buf.append(c);
            } else if (is_suffix && c == syms.getPerMill()) {
                if (multiplierSet) {
                    throw new IllegalArgumentException("multiplier already set - index: " + index);
                }
                multiplierSet = true;
                this.multiplier = 1000;
                buf.append(c);
            } else {
                if (patChars.indexOf(c) != -1) break;
                buf.append(c);
            }
            ++index;
        }
        return index;
    }

    private final int scanFormat(String pattern, int index, String patChars, DecimalFormatSymbols syms, boolean is_positive) {
        char c;
        int max = pattern.length();
        int countSinceGroup = 0;
        int zeroCount = 0;
        boolean saw_group = false;
        while (index < max) {
            c = pattern.charAt(index);
            if (c == syms.getDigit()) {
                if (zeroCount > 0) {
                    throw new IllegalArgumentException("digit mark following zero - index: " + index);
                }
                ++countSinceGroup;
            } else if (c == syms.getZeroDigit()) {
                ++zeroCount;
                ++countSinceGroup;
            } else {
                if (c != syms.getGroupingSeparator()) break;
                countSinceGroup = 0;
                saw_group = true;
            }
            ++index;
        }
        if (is_positive) {
            this.groupingUsed = saw_group;
            this.groupingSize = (byte)countSinceGroup;
            this.minimumIntegerDigits = zeroCount;
        }
        if (index == max || pattern.charAt(index) == syms.getGroupingSeparator()) {
            if (is_positive) {
                this.decimalSeparatorAlwaysShown = false;
            }
            return index;
        }
        if (pattern.charAt(index) == syms.getDecimalSeparator()) {
            ++index;
            int hashCount = 0;
            zeroCount = 0;
            while (index < max) {
                char c2 = pattern.charAt(index);
                if (c2 == syms.getZeroDigit()) {
                    if (hashCount > 0) {
                        throw new IllegalArgumentException("zero mark following digit - index: " + index);
                    }
                    ++zeroCount;
                } else if (c2 == syms.getDigit()) {
                    ++hashCount;
                } else {
                    if (c2 == syms.getExponential() || c2 == syms.getPatternSeparator() || patChars.indexOf(c2) == -1) break;
                    throw new IllegalArgumentException("unexpected special character - index: " + index);
                }
                ++index;
            }
            if (is_positive) {
                this.maximumFractionDigits = hashCount + zeroCount;
                this.minimumFractionDigits = zeroCount;
            }
            if (index == max) {
                return index;
            }
        }
        if (pattern.charAt(index) == syms.getExponential()) {
            zeroCount = 0;
            ++index;
            while (index < max) {
                c = pattern.charAt(index);
                if (c == syms.getZeroDigit()) {
                    ++zeroCount;
                } else if (c == syms.getDigit()) {
                    if (zeroCount > 0) {
                        throw new IllegalArgumentException("digit mark following zero in exponent - index: " + index);
                    }
                } else {
                    if (patChars.indexOf(c) == -1) break;
                    throw new IllegalArgumentException("unexpected special character - index: " + index);
                }
                ++index;
            }
            if (is_positive) {
                this.useExponentialNotation = true;
                this.minExponentDigits = (byte)zeroCount;
            }
        }
        return index;
    }

    private final String patternChars(DecimalFormatSymbols syms) {
        StringBuffer buf = new StringBuffer();
        buf.append(syms.getDecimalSeparator());
        buf.append(syms.getDigit());
        buf.append(syms.getExponential());
        buf.append(syms.getGroupingSeparator());
        buf.append(syms.getPatternSeparator());
        buf.append(syms.getPercent());
        buf.append(syms.getPerMill());
        buf.append(syms.getZeroDigit());
        buf.append('\u00a4');
        return buf.toString();
    }

    private final void applyPatternWithSymbols(String pattern, DecimalFormatSymbols syms) {
        this.negativePrefix = "";
        this.negativeSuffix = "";
        this.positivePrefix = "";
        this.positiveSuffix = "";
        this.decimalSeparatorAlwaysShown = false;
        this.groupingSize = 0;
        this.minExponentDigits = 0;
        this.multiplier = 1;
        this.useExponentialNotation = false;
        this.groupingUsed = false;
        this.maximumFractionDigits = 0;
        this.maximumIntegerDigits = 309;
        this.minimumFractionDigits = 0;
        this.minimumIntegerDigits = 1;
        StringBuffer buf = new StringBuffer();
        String patChars = this.patternChars(syms);
        int max = pattern.length();
        int index = this.scanFix(pattern, 0, buf, patChars, syms, false);
        this.positivePrefix = buf.toString();
        index = this.scanFormat(pattern, index, patChars, syms, true);
        index = this.scanFix(pattern, index, buf, patChars, syms, true);
        this.positiveSuffix = buf.toString();
        if (index == pattern.length()) {
            this.negativePrefix = null;
            this.negativeSuffix = null;
        } else {
            if (pattern.charAt(index) != syms.getPatternSeparator()) {
                throw new IllegalArgumentException("separator character expected - index: " + index);
            }
            index = this.scanFix(pattern, index + 1, buf, patChars, syms, false);
            this.negativePrefix = buf.toString();
            index = this.scanFormat(pattern, index, patChars, syms, false);
            index = this.scanFix(pattern, index, buf, patChars, syms, true);
            this.negativeSuffix = buf.toString();
            if (index != pattern.length()) {
                throw new IllegalArgumentException("end of pattern expected - index: " + index);
            }
        }
    }

    public void applyLocalizedPattern(String pattern) {
        this.applyPatternWithSymbols(pattern, this.symbols);
    }

    public void applyPattern(String pattern) {
        this.applyPatternWithSymbols(pattern, nonLocalizedSymbols);
    }

    public Object clone() {
        return new DecimalFormat(this);
    }

    private DecimalFormat(DecimalFormat dup) {
        this.finit$();
        this.decimalSeparatorAlwaysShown = dup.decimalSeparatorAlwaysShown;
        this.groupingSize = dup.groupingSize;
        this.minExponentDigits = dup.minExponentDigits;
        this.multiplier = dup.multiplier;
        this.negativePrefix = dup.negativePrefix;
        this.negativeSuffix = dup.negativeSuffix;
        this.positivePrefix = dup.positivePrefix;
        this.positiveSuffix = dup.positiveSuffix;
        this.symbols = (DecimalFormatSymbols)dup.symbols.clone();
        this.useExponentialNotation = dup.useExponentialNotation;
    }

    public DecimalFormat() {
        this("#,##0.###");
    }

    public DecimalFormat(String pattern) {
        this(pattern, new DecimalFormatSymbols());
    }

    public DecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        this.finit$();
        this.symbols = symbols;
        this.applyPattern(pattern);
    }

    private final boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat dup = (DecimalFormat)obj;
        return this.decimalSeparatorAlwaysShown == dup.decimalSeparatorAlwaysShown && this.groupingSize == dup.groupingSize && this.minExponentDigits == dup.minExponentDigits && this.multiplier == dup.multiplier && this.equals(this.negativePrefix, dup.negativePrefix) && this.equals(this.negativeSuffix, dup.negativeSuffix) && this.equals(this.positivePrefix, dup.positivePrefix) && this.equals(this.positiveSuffix, dup.positiveSuffix) && this.symbols.equals(dup.symbols) && this.useExponentialNotation == dup.useExponentialNotation;
    }

    public StringBuffer format(double number, StringBuffer dest, FieldPosition fieldPos) {
        boolean is_neg;
        if (Double.isNaN(number)) {
            dest.append(this.symbols.getNaN());
            if (fieldPos != null && fieldPos.getField() == 0) {
                int index = dest.length();
                fieldPos.setBeginIndex(index - this.symbols.getNaN().length());
                fieldPos.setEndIndex(index);
            }
            return dest;
        }
        boolean bl = is_neg = number < 0.0;
        if (is_neg) {
            if (this.negativePrefix != null) {
                dest.append(this.negativePrefix);
            } else {
                dest.append(this.symbols.getMinusSign());
                dest.append(this.positivePrefix);
            }
            number = -number;
        } else {
            dest.append(this.positivePrefix);
        }
        int integerBeginIndex = dest.length();
        int integerEndIndex = 0;
        if (Double.isInfinite(number)) {
            dest.append(this.symbols.getInfinity());
            integerEndIndex = dest.length();
        } else {
            int count;
            double baseNumber;
            number *= (double)this.multiplier;
            long exponent = 0L;
            if (this.useExponentialNotation) {
                exponent = (long)(Math.log(number) / Math.log(10.0));
                if (this.minimumIntegerDigits > 0) {
                    exponent -= (long)(this.minimumIntegerDigits - 1);
                }
                baseNumber = (long)(number / Math.pow(10.0, exponent));
            } else {
                baseNumber = number;
            }
            int index = dest.length();
            double intPart = Math.floor(baseNumber += 5.0 * Math.pow(10.0, -this.maximumFractionDigits - 1));
            for (count = 0; count < this.maximumIntegerDigits && (intPart > 0.0 || count < this.minimumIntegerDigits); ++count) {
                long dig = (long)(intPart % 10.0);
                intPart = Math.floor(intPart / 10.0);
                if (this.groupingUsed && count > 0 && count % this.groupingSize == 0) {
                    dest.insert(index, this.symbols.getGroupingSeparator());
                }
                dest.insert(index, (char)((long)this.symbols.getZeroDigit() + dig));
            }
            int decimal_index = integerEndIndex = dest.length();
            int consecutive_zeros = 0;
            int total_digits = 0;
            double fracPart = baseNumber - Math.floor(baseNumber);
            for (count = 0; count < this.maximumFractionDigits && (fracPart != 0.0 || count < this.minimumFractionDigits); fracPart -= Math.floor(fracPart), ++count) {
                ++total_digits;
                long dig = (long)(fracPart *= 10.0);
                consecutive_zeros = dig == 0L ? ++consecutive_zeros : 0;
                dest.append((char)((long)this.symbols.getZeroDigit() + dig));
            }
            int extra_zeros = Math.min(consecutive_zeros, total_digits - this.minimumFractionDigits);
            if (extra_zeros > 0) {
                dest.setLength(dest.length() - extra_zeros);
                total_digits -= extra_zeros;
            }
            if (this.decimalSeparatorAlwaysShown || total_digits > 0) {
                dest.insert(decimal_index, this.symbols.getDecimalSeparator());
                if (fieldPos != null && fieldPos.getField() == 1) {
                    fieldPos.setBeginIndex(decimal_index + 1);
                    fieldPos.setEndIndex(dest.length());
                }
            }
            if (this.useExponentialNotation) {
                dest.append(this.symbols.getExponential());
                dest.append(exponent < 0L ? (char)'-' : '+');
                index = dest.length();
                for (count = 0; exponent > 0L || count < this.minExponentDigits; exponent /= (long)10, ++count) {
                    long dig = exponent % (long)10;
                    dest.insert(index, (char)((long)this.symbols.getZeroDigit() + dig));
                }
            }
        }
        if (fieldPos != null && fieldPos.getField() == 0) {
            fieldPos.setBeginIndex(integerBeginIndex);
            fieldPos.setEndIndex(integerEndIndex);
        }
        dest.append(is_neg && this.negativeSuffix != null ? this.negativeSuffix : this.positiveSuffix);
        return dest;
    }

    public StringBuffer format(long number, StringBuffer dest, FieldPosition fieldPos) {
        int count;
        boolean is_neg;
        if (this.useExponentialNotation) {
            return this.format((double)number, dest, fieldPos);
        }
        boolean bl = is_neg = number < 0L;
        if (is_neg) {
            if (this.negativePrefix != null) {
                dest.append(this.negativePrefix);
            } else {
                dest.append(this.symbols.getMinusSign());
                dest.append(this.positivePrefix);
            }
            number = -number;
        } else {
            dest.append(this.positivePrefix);
        }
        int integerBeginIndex = dest.length();
        int index = dest.length();
        for (count = 0; count < this.maximumIntegerDigits && (number > 0L || count < this.minimumIntegerDigits); ++count) {
            long dig = number % (long)10;
            number /= (long)10;
            if (dig < 0L) {
                dig = -dig;
                number = -number;
            }
            if (this.groupingUsed && count > 0 && count % this.groupingSize == 0) {
                dest.insert(index, this.symbols.getGroupingSeparator());
            }
            dest.insert(index, (char)((long)this.symbols.getZeroDigit() + dig));
        }
        if (fieldPos != null && fieldPos.getField() == 0) {
            fieldPos.setBeginIndex(integerBeginIndex);
            fieldPos.setEndIndex(dest.length());
        }
        if (this.decimalSeparatorAlwaysShown || this.minimumFractionDigits > 0) {
            dest.append(this.symbols.getDecimalSeparator());
            if (fieldPos != null && fieldPos.getField() == 1) {
                fieldPos.setBeginIndex(dest.length());
                fieldPos.setEndIndex(dest.length() + this.minimumFractionDigits);
            }
        }
        for (count = 0; count < this.minimumFractionDigits; ++count) {
            dest.append(this.symbols.getZeroDigit());
        }
        dest.append(is_neg && this.negativeSuffix != null ? this.negativeSuffix : this.positiveSuffix);
        return dest;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.symbols;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public int hashCode() {
        int hash = this.negativeSuffix.hashCode() ^ this.negativePrefix.hashCode() ^ this.positivePrefix.hashCode() ^ this.positiveSuffix.hashCode();
        return hash;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public Number parse(String str, ParsePosition pos) {
        String suffix;
        boolean is_neg = false;
        int index = pos.getIndex();
        StringBuffer buf = new StringBuffer();
        boolean got_pos = str.startsWith(this.positivePrefix, index);
        String np = this.negativePrefix != null ? this.negativePrefix : this.positivePrefix + this.symbols.getMinusSign();
        boolean got_neg = str.startsWith(np, index);
        if (got_pos && got_neg) {
            if (np.length() > this.positivePrefix.length()) {
                is_neg = true;
                index += np.length();
            } else {
                index += this.positivePrefix.length();
            }
        } else if (got_neg) {
            is_neg = true;
            index += np.length();
        } else if (got_pos) {
            index += this.positivePrefix.length();
        } else {
            pos.setErrorIndex(index);
            return null;
        }
        int start_index = index;
        int max = str.length();
        char zero = this.symbols.getZeroDigit();
        int last_group = -1;
        boolean int_part = true;
        boolean exp_part = false;
        while (index < max) {
            char c = str.charAt(index);
            if (this.groupingUsed && c == this.symbols.getGroupingSeparator()) {
                if (last_group != -1 && (index - last_group) % this.groupingSize != 0) {
                    pos.setErrorIndex(index);
                    return null;
                }
                last_group = index;
            } else if (c >= zero && c <= zero + 9) {
                buf.append((char)(c - zero + 48));
                exp_part = false;
            } else {
                if (this.parseIntegerOnly) break;
                if (c == this.symbols.getDecimalSeparator()) {
                    if (last_group != -1 && (index - last_group) % this.groupingSize != 0) {
                        pos.setErrorIndex(index);
                        return null;
                    }
                    buf.append('.');
                    int_part = false;
                } else if (c == this.symbols.getExponential()) {
                    buf.append('E');
                    int_part = false;
                    exp_part = true;
                } else {
                    if (!exp_part || c != '+' && c != '-' && c != this.symbols.getMinusSign()) break;
                    buf.append(c);
                }
            }
            ++index;
        }
        if (index == start_index) {
            pos.setErrorIndex(index);
            return null;
        }
        boolean got_pos_suf = str.startsWith(this.positiveSuffix, index);
        String ns = this.negativePrefix == null ? this.positiveSuffix : this.negativeSuffix;
        boolean got_neg_suf = str.startsWith(ns, index);
        if (is_neg) {
            if (!got_neg_suf) {
                pos.setErrorIndex(index);
                return null;
            }
        } else if (got_pos && got_neg && got_neg_suf) {
            is_neg = true;
        } else if (got_pos != got_pos_suf && got_neg != got_neg_suf) {
            pos.setErrorIndex(index);
            return null;
        }
        String string = suffix = is_neg ? ns : this.positiveSuffix;
        if (is_neg) {
            buf.insert(0, '-');
        }
        String t = buf.toString();
        Number result = null;
        try {
            result = new Long(t);
        }
        catch (NumberFormatException x1) {
            try {
                result = new Double(t);
            }
            catch (NumberFormatException x2) {
                // empty catch block
            }
        }
        if (result == null) {
            pos.setErrorIndex(index);
            return null;
        }
        pos.setIndex(index + suffix.length());
        return result;
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        this.symbols = newSymbols;
    }

    public void setDecimalSeparatorAlwaysShown(boolean newValue) {
        this.decimalSeparatorAlwaysShown = newValue;
    }

    public void setGroupingSize(int groupSize) {
        this.groupingSize = (byte)groupSize;
    }

    public void setMaximumFractionDigits(int newValue) {
        this.maximumFractionDigits = Math.min(newValue, 340);
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.maximumIntegerDigits = Math.min(newValue, 309);
    }

    public void setMinimumFractionDigits(int newValue) {
        this.minimumFractionDigits = Math.min(newValue, 340);
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.minimumIntegerDigits = Math.min(newValue, 309);
    }

    public void setMultiplier(int newValue) {
        this.multiplier = newValue;
    }

    public void setNegativePrefix(String newValue) {
        this.negativePrefix = newValue;
    }

    public void setNegativeSuffix(String newValue) {
        this.negativeSuffix = newValue;
    }

    public void setPositivePrefix(String newValue) {
        this.positivePrefix = newValue;
    }

    public void setPositiveSuffix(String newValue) {
        this.positiveSuffix = newValue;
    }

    private final void quoteFix(StringBuffer buf, String text, String patChars) {
        int len = text.length();
        for (int index = 0; index < len; ++index) {
            char c = text.charAt(index);
            if (patChars.indexOf(c) != -1) {
                buf.append('\'');
                buf.append(c);
                buf.append('\'');
                continue;
            }
            buf.append(c);
        }
    }

    private final String computePattern(DecimalFormatSymbols syms) {
        int i;
        StringBuffer mainPattern = new StringBuffer();
        int total_digits = Math.max(this.minimumIntegerDigits, this.groupingUsed ? this.groupingSize + 1 : 0);
        for (i = 0; i < total_digits - this.minimumIntegerDigits; ++i) {
            mainPattern.append(syms.getDigit());
        }
        for (i = total_digits - this.minimumIntegerDigits; i < total_digits; ++i) {
            mainPattern.append(syms.getZeroDigit());
        }
        if (this.groupingUsed) {
            mainPattern.insert(mainPattern.length() - this.groupingSize, syms.getGroupingSeparator());
        }
        if (this.minimumFractionDigits > 0 || this.maximumFractionDigits > 0 || this.decimalSeparatorAlwaysShown) {
            mainPattern.append(syms.getDecimalSeparator());
        }
        for (i = 0; i < this.minimumFractionDigits; ++i) {
            mainPattern.append(syms.getZeroDigit());
        }
        for (i = this.minimumFractionDigits; i < this.maximumFractionDigits; ++i) {
            mainPattern.append(syms.getDigit());
        }
        if (this.useExponentialNotation) {
            mainPattern.append(syms.getExponential());
            for (i = 0; i < this.minExponentDigits; ++i) {
                mainPattern.append(syms.getZeroDigit());
            }
            if (this.minExponentDigits == 0) {
                mainPattern.append(syms.getDigit());
            }
        }
        String main = mainPattern.toString();
        String patChars = this.patternChars(syms);
        mainPattern.setLength(0);
        this.quoteFix(mainPattern, this.positivePrefix, patChars);
        mainPattern.append(main);
        this.quoteFix(mainPattern, this.positiveSuffix, patChars);
        if (this.negativePrefix != null) {
            this.quoteFix(mainPattern, this.negativePrefix, patChars);
            mainPattern.append(main);
            this.quoteFix(mainPattern, this.negativeSuffix, patChars);
        }
        return mainPattern.toString();
    }

    public String toLocalizedPattern() {
        return this.computePattern(this.symbols);
    }

    public String toPattern() {
        return this.computePattern(nonLocalizedSymbols);
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
            this.serialVersionOnStream = 1;
        }
    }
}

