/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Date
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7523967970034938905L;
    private transient long millis;

    public Date() {
        this.millis = System.currentTimeMillis();
    }

    public Date(long millis) {
        this.millis = millis;
    }

    public Date(int year, int month, int date, int hours, int minutes, int seconds) {
        this.setTime(year, month, date, hours, minutes, seconds);
    }

    public Date(int year, int month, int date, int hours, int minutes) {
        this.setTime(year, month, date, hours, minutes, 0);
    }

    public Date(int year, int month, int date) {
        this.setTime(year, month, date, 0, 0, 0);
    }

    public Date(String s) {
        this(Date.parse(s));
    }

    private static int skipParens(String string, int offset) {
        int i;
        int len = string.length();
        int p = 0;
        for (i = offset; i < len; ++i) {
            if (string.charAt(i) == '(') {
                ++p;
                continue;
            }
            if (string.charAt(i) != ')') continue;
            if (--p == 0) {
                return i + 1;
            }
            if (p >= 0) continue;
            return i;
        }
        return i;
    }

    private static int parseTz(String tok, char sign) {
        int num;
        try {
            num = Integer.parseInt(tok.substring(1));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(tok);
        }
        num = num < 24 ? (num *= 60) : num / 100 * 60 + num % 100;
        if (sign == '-') {
            return -num;
        }
        return num;
    }

    private static int parseMonth(String tok) {
        String[] months = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
        for (int i = 0; i < 12; ++i) {
            if (!months[i].startsWith(tok)) continue;
            return i;
        }
        return -1;
    }

    private static boolean parseDayOfWeek(String tok) {
        String[] daysOfWeek = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
        for (int i = 0; i < 7; ++i) {
            if (!daysOfWeek[i].startsWith(tok)) continue;
            return true;
        }
        return false;
    }

    public static long parse(String string) {
        int openParenOffset;
        int year = -1;
        int month = -1;
        int day = -1;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int timezone = 0;
        boolean localTimezone = true;
        StringBuffer buf = new StringBuffer();
        int off = 0;
        while ((openParenOffset = string.indexOf(40, off)) >= 0) {
            buf.append(string.substring(off, openParenOffset));
            off = Date.skipParens(string, openParenOffset);
        }
        buf.append(string.substring(off));
        StringTokenizer strtok = new StringTokenizer(buf.toString().toUpperCase(), " \t\n\r,");
        while (strtok.hasMoreTokens()) {
            String tok = strtok.nextToken();
            char firstch = tok.charAt(0);
            if ((firstch == '+' || firstch == '-') && year >= 0) {
                timezone = Date.parseTz(tok, firstch);
                localTimezone = false;
                continue;
            }
            if (firstch >= '0' && firstch <= '9') {
                while (tok != null && tok.length() > 0) {
                    int num;
                    int colon = tok.indexOf(58);
                    int slash = tok.indexOf(47);
                    int hyphen = tok.indexOf(45);
                    int punctOffset = tok.length();
                    if (colon >= 0) {
                        punctOffset = Math.min(punctOffset, colon);
                    }
                    if (slash >= 0) {
                        punctOffset = Math.min(punctOffset, slash);
                    }
                    if (hyphen >= 0) {
                        punctOffset = Math.min(punctOffset, hyphen);
                    }
                    if (punctOffset == tok.length()) {
                        punctOffset = -1;
                    }
                    try {
                        num = Integer.parseInt(punctOffset < 0 ? tok : tok.substring(0, punctOffset));
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException(tok);
                    }
                    if (num > 70 && (punctOffset < 0 || punctOffset == slash)) {
                        year = num > 1900 ? num - 1900 : num;
                    } else if (punctOffset > 0 && punctOffset == colon) {
                        if (hour < 0) {
                            hour = num;
                        } else {
                            minute = num;
                        }
                    } else if (punctOffset > 0 && punctOffset == slash) {
                        if (month < 0) {
                            month = num - 1;
                        } else {
                            day = num;
                        }
                    } else if (hour >= 0 && minute < 0) {
                        minute = num;
                    } else if (minute >= 0 && second < 0) {
                        second = num;
                    } else if (day < 0) {
                        day = num;
                    } else {
                        throw new IllegalArgumentException(tok);
                    }
                    if (punctOffset < 0 || punctOffset + 1 >= tok.length()) {
                        tok = null;
                        continue;
                    }
                    tok = tok.substring(punctOffset + 1);
                }
                continue;
            }
            if (firstch >= 'A' && firstch <= 'Z') {
                if (tok.equals("AM")) {
                    if (hour < 1 || hour > 12) {
                        throw new IllegalArgumentException(tok);
                    }
                    if (hour != 12) continue;
                    hour = 0;
                    continue;
                }
                if (tok.equals("PM")) {
                    if (hour < 1 || hour > 12) {
                        throw new IllegalArgumentException(tok);
                    }
                    if (hour >= 12) continue;
                    hour += 12;
                    continue;
                }
                if (Date.parseDayOfWeek(tok)) continue;
                if (tok.equals("UT") || tok.equals("UTC") || tok.equals("GMT")) {
                    localTimezone = false;
                    continue;
                }
                if (tok.startsWith("UT") || tok.startsWith("GMT")) {
                    char sign;
                    int signOffset = 3;
                    if (tok.charAt(1) == 'T' && tok.charAt(2) != 'C') {
                        signOffset = 2;
                    }
                    if ((sign = tok.charAt(signOffset)) != '+' && sign != '-') {
                        throw new IllegalArgumentException(tok);
                    }
                    timezone = Date.parseTz(tok.substring(signOffset), sign);
                    localTimezone = false;
                    continue;
                }
                int tmpMonth = Date.parseMonth(tok);
                if (tmpMonth >= 0) {
                    month = tmpMonth;
                    continue;
                }
                if (tok.length() == 3 && tok.charAt(2) == 'T') {
                    char ch = tok.charAt(0);
                    if (ch == 'E') {
                        timezone = -300;
                    } else if (ch == 'C') {
                        timezone = -360;
                    } else if (ch == 'M') {
                        timezone = -420;
                    } else if (ch == 'P') {
                        timezone = -480;
                    } else {
                        throw new IllegalArgumentException(tok);
                    }
                    if (tok.charAt(1) == 'D') {
                        timezone += 60;
                    } else if (tok.charAt(1) != 'S') {
                        throw new IllegalArgumentException(tok);
                    }
                    localTimezone = false;
                    continue;
                }
                throw new IllegalArgumentException(tok);
            }
            throw new IllegalArgumentException(tok);
        }
        if (minute < 0) {
            minute = 0;
        }
        if (second < 0) {
            second = 0;
        }
        if (year < 0 || month < 0 || day < 0 || hour < 0) {
            throw new IllegalArgumentException("Missing field");
        }
        return Date.UTC(year, month, day, hour, minute, second) + (long)(localTimezone ? new Date(year, month, day).getTimezoneOffset() * 60 * 1000 : -timezone * 60 * 1000);
    }

    public boolean after(Date when) {
        return this.millis > when.millis;
    }

    public boolean before(Date when) {
        return this.millis < when.millis;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Date && ((Date)obj).millis == this.millis;
    }

    public long getTime() {
        return this.millis;
    }

    public int hashCode() {
        return (int)this.millis ^ (int)(this.millis >>> 32);
    }

    private void setTime(int year, int month, int date, int hours, int minutes, int seconds) {
        GregorianCalendar cal = new GregorianCalendar(year + 1900, month, date, hours, minutes, seconds);
        this.millis = cal.getTimeInMillis();
    }

    public void setTime(long millis) {
        this.millis = millis;
    }

    private int getField(int fld) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this);
        return cal.get(fld);
    }

    public int getYear() {
        return this.getField(1) - 1900;
    }

    public int getMonth() {
        return this.getField(2);
    }

    public int getDate() {
        return this.getField(5);
    }

    public int getDay() {
        return this.getField(7) - 1;
    }

    public int getHours() {
        return this.getField(11);
    }

    public int getMinutes() {
        return this.getField(12);
    }

    public int getSeconds() {
        return this.getField(13);
    }

    private void setField(int fld, int value) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this);
        cal.set(fld, value);
        this.millis = cal.getTimeInMillis();
    }

    public void setYear(int year) {
        this.setField(1, 1900 + year);
    }

    public void setMonth(int month) {
        this.setField(2, month);
    }

    public void setDate(int date) {
        this.setField(5, date);
    }

    public void setHours(int hours) {
        this.setField(11, hours);
    }

    public void setMinutes(int minutes) {
        this.setField(12, minutes);
    }

    public void setSeconds(int seconds) {
        this.setField(13, seconds);
    }

    public int getTimezoneOffset() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this);
        return -(cal.get(15) + cal.get(16) / 60000);
    }

    public String toString() {
        SimpleDateFormat fmt = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy", Locale.US);
        fmt.setTimeZone(TimeZone.getDefault());
        return fmt.format(this);
    }

    public String toGMTString() {
        SimpleDateFormat fmt = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.format(this);
    }

    public String toLocaleString() {
        DateFormat fmt = DateFormat.getDateTimeInstance();
        fmt.setTimeZone(TimeZone.getDefault());
        return fmt.format(this);
    }

    public static long UTC(int year, int month, int date, int hours, int minutes, int seconds) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.set(year + 1900, month, date, hours, minutes, seconds);
        return cal.getTimeInMillis();
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.millis = input.readLong();
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeLong(this.millis);
    }
}

