/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    static final long serialVersionUID = 876323262645176354L;
    transient Entry first;
    transient Entry last;
    transient int size;

    private /* synthetic */ void finit$() {
        this.size = 0;
    }

    private Entry getEntry(int n) {
        Entry e;
        if (n < this.size / 2) {
            e = this.first;
            while (n-- > 0) {
                e = e.next;
            }
        } else {
            e = this.last;
            while (++n < this.size) {
                e = e.previous;
            }
        }
        return e;
    }

    private void removeEntry(Entry e) {
        if (this.size == 1) {
            this.last = null;
            this.first = null;
        } else if (e == this.first) {
            this.first = e.next;
            e.next.previous = null;
        } else if (e == this.last) {
            this.last = e.previous;
            e.previous.next = null;
        } else {
            e.next.previous = e.previous;
            e.previous.next = e.next;
        }
        this.size += -1;
    }

    public LinkedList() {
        this.finit$();
    }

    public LinkedList(Collection c) {
        this.finit$();
        this.addAll(c);
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.first.data;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.last.data;
    }

    public Object removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        this.size += -1;
        ++this.modCount;
        Object r = this.first.data;
        if (this.first.next != null) {
            this.first.next.previous = null;
        } else {
            this.last = null;
        }
        this.first = this.first.next;
        return r;
    }

    public Object removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        this.size += -1;
        ++this.modCount;
        Object r = this.last.data;
        if (this.last.previous != null) {
            this.last.previous.next = null;
        } else {
            this.first = null;
        }
        this.last = this.last.previous;
        return r;
    }

    public void addFirst(Object o) {
        ++this.modCount;
        Entry e = new Entry(o);
        if (this.size == 0) {
            this.first = this.last = e;
        } else {
            e.next = this.first;
            this.first.previous = e;
            this.first = e;
        }
        ++this.size;
    }

    public void addLast(Object o) {
        ++this.modCount;
        this.addLastEntry(new Entry(o));
    }

    private void addLastEntry(Entry e) {
        if (this.size == 0) {
            this.first = this.last = e;
        } else {
            e.previous = this.last;
            this.last.next = e;
            this.last = e;
        }
        ++this.size;
    }

    public boolean contains(Object o) {
        Entry e = this.first;
        while (e != null) {
            if (e.data == null ? o == null : o.equals(e.data)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object o) {
        ++this.modCount;
        this.addLastEntry(new Entry(o));
        return true;
    }

    public boolean remove(Object o) {
        ++this.modCount;
        Entry e = this.first;
        while (e != null) {
            if (e.data == null ? o == null : o.equals(e.data)) {
                this.removeEntry(e);
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public boolean addAll(int index, Collection c) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        ++this.modCount;
        int csize = c.size();
        if (csize == 0) {
            return false;
        }
        Iterator itr = c.iterator();
        Entry after = null;
        Entry before = null;
        if (index != this.size) {
            after = this.getEntry(index);
            before = after.previous;
        } else {
            before = this.last;
        }
        Entry e = new Entry(itr.next());
        e.previous = before;
        Entry prev = e;
        Entry firstNew = e;
        for (int pos = 1; pos < csize; ++pos) {
            e = new Entry(itr.next());
            e.previous = prev;
            prev.next = e;
            prev = e;
        }
        prev.next = after;
        if (after != null) {
            after.previous = e;
        } else {
            this.last = e;
        }
        if (before != null) {
            before.next = firstNew;
        } else {
            this.first = firstNew;
        }
        this.size += csize;
        return true;
    }

    public void clear() {
        ++this.modCount;
        this.first = null;
        this.last = null;
        this.size = 0;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        Entry e = this.getEntry(index);
        return e.data;
    }

    public Object set(int index, Object o) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        Entry e = this.getEntry(index);
        Object old = e.data;
        e.data = o;
        return old;
    }

    public void add(int index, Object o) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        ++this.modCount;
        this.addEntry(index, new Entry(o));
    }

    private void addEntry(int index, Entry e) {
        if (index < this.size) {
            Entry after;
            e.next = after = this.getEntry(index);
            e.previous = after.previous;
            if (after.previous == null) {
                this.first = e;
            } else {
                after.previous.next = e;
            }
            after.previous = e;
            ++this.size;
        } else {
            this.addLastEntry(e);
        }
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        ++this.modCount;
        Entry e = this.getEntry(index);
        this.removeEntry(e);
        return e.data;
    }

    public int indexOf(Object o) {
        int index = 0;
        Entry e = this.first;
        while (e != null) {
            if (e.data == null ? o == null : o.equals(e.data)) {
                return index;
            }
            ++index;
            e = e.next;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int index = this.size - 1;
        Entry e = this.last;
        while (e != null) {
            if (e.data == null ? o == null : o.equals(e.data)) {
                return index;
            }
            --index;
            e = e.previous;
        }
        return -1;
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
        return new LinkedListItr(this, index);
    }

    public Object clone() {
        LinkedList copy = null;
        try {
            copy = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.size = 0;
        copy.addAll(this);
        return copy;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size];
        Entry e = this.first;
        for (int i = 0; i < this.size; ++i) {
            array[i] = e.data;
            e = e.next;
        }
        return array;
    }

    public Object[] toArray(Object[] array) {
        if (array.length < this.size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        } else if (array.length > this.size) {
            array[this.size] = null;
        }
        Entry e = this.first;
        for (int i = 0; i < this.size; ++i) {
            array[i] = e.data;
            e = e.next;
        }
        return array;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.size);
        Iterator itr = this.iterator();
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(itr.next());
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        int serialSize = s.readInt();
        for (int i = 0; i < serialSize; ++i) {
            this.addLastEntry(new Entry(s.readObject()));
        }
    }

    class LinkedListItr
    implements ListIterator {
        private /* synthetic */ LinkedList this$0;
        int knownMod;
        Entry next;
        Entry previous;
        Entry lastReturned;
        int position;

        LinkedListItr(LinkedList this$0, int index) {
            this.this$0 = this$0;
            if (index == this$0.size) {
                this.next = null;
                this.previous = this$0.last;
            } else {
                this.next = this$0.getEntry(index);
                this.previous = this.next.previous;
            }
            this.position = index;
            this.knownMod = this$0.modCount;
        }

        private void checkMod() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        public int nextIndex() {
            this.checkMod();
            return this.position;
        }

        public int previousIndex() {
            this.checkMod();
            return this.position - 1;
        }

        public boolean hasNext() {
            this.checkMod();
            return this.next != null;
        }

        public boolean hasPrevious() {
            this.checkMod();
            return this.previous != null;
        }

        public Object next() {
            this.checkMod();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ++this.position;
            this.lastReturned = this.previous = this.next;
            this.next = this.lastReturned.next;
            return this.lastReturned.data;
        }

        public Object previous() {
            this.checkMod();
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.position += -1;
            this.lastReturned = this.next = this.previous;
            this.previous = this.lastReturned.previous;
            return this.lastReturned.data;
        }

        public void remove() {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == this.previous) {
                this.position += -1;
            }
            this.next = this.lastReturned.next;
            this.previous = this.lastReturned.previous;
            ++this.this$0.modCount;
            ++this.knownMod;
            this.this$0.removeEntry(this.lastReturned);
            this.lastReturned = null;
        }

        public void add(Object o) {
            this.checkMod();
            ++this.this$0.modCount;
            ++this.knownMod;
            Entry e = new Entry(o);
            e.previous = this.previous;
            e.next = this.next;
            if (this.previous != null) {
                this.previous.next = e;
            } else {
                this.this$0.first = e;
            }
            if (this.next != null) {
                this.next.previous = e;
                this.next = this.next.next;
            } else {
                this.this$0.last = e;
            }
            this.previous = e;
            ++this.this$0.size;
            ++this.position;
            this.lastReturned = null;
        }

        public void set(Object o) {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.data = o;
        }
    }

    static class Entry {
        Object data;
        Entry next;
        Entry previous;

        Entry(Object data) {
            this.data = data;
        }
    }
}

