/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Observer;
import java.util.Vector;

public class Observable {
    private boolean changed = false;
    private Vector observerVec = new Vector();

    public synchronized void addObserver(Observer obs) {
        if (!this.observerVec.contains(obs)) {
            this.observerVec.addElement(obs);
        }
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized int countObservers() {
        return this.observerVec.size();
    }

    public synchronized void deleteObserver(Observer obs) {
        this.observerVec.removeElement(obs);
    }

    public synchronized void deleteObservers() {
        this.observerVec.removeAllElements();
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    public void notifyObservers(Object arg) {
        if (this.changed) {
            int numObs = this.observerVec.size();
            for (int i = 0; i < numObs; ++i) {
                ((Observer)this.observerVec.elementAt(i)).update(this, arg);
            }
            this.changed = false;
        }
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }
}

